/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.userrights.invoice;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.export.AsyncSimpleExportPopupInsert;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.NumberTextFieldAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.PeriodEditorAnalysisItem;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.UserInvoiceExportAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.generic.GenericAnalysisReportType;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.List;

public class PrintUserLicenseInvoiceComponent
extends AsyncSimpleExportPopupInsert<UserLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<NumberTextField> amount;
    private TitledItem<NumberTextField> amountMobileUser;
    private TitledPeriodEditor dateChooser;

    public PrintUserLicenseInvoiceComponent(AnalysisSmartExternalOpenTool<UserLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        Node d = INodeCreator.getDefaultImpl().getNode4DTO((Object)0.0, false, false);
        this.amount = new TitledItem<NumberTextField>(new NumberTextField(d, TextFieldType.DOUBLE), Words.AMOUNT_PER_YEAR, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new NumberTextFieldAnalysisItem(this.amount, "amount"));
        d = INodeCreator.getDefaultImpl().getNode4DTO((Object)0.0, false, false);
        this.amountMobileUser = new TitledItem<NumberTextField>(new NumberTextField(d, TextFieldType.DOUBLE), Words.AMOUNT_PER_YEAR_MOBILE_USER, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new NumberTextFieldAnalysisItem(this.amountMobileUser, "amountMobileUser"));
        PeriodComplete p = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        this.dateChooser = new TitledPeriodEditor((Node<PeriodComplete>)n, null);
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.dateChooser, "period"));
    }

    @Override
    public boolean canExportAll() {
        return true;
    }

    @Override
    public boolean chooseExportFormat() {
        return true;
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        String text = this.amount.getElement().getText();
        if (text == null || text.isEmpty()) {
            ScreenValidationObject screenValidationObject = new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AMOUNT_IS_SET);
            return ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{screenValidationObject});
        }
        return super.validateBeforePrint();
    }

    @Override
    public String getTitleString() {
        return Words.USER_LICENSE_INVOICE;
    }

    @Override
    public GenericAnalysisReportType getReportType() {
        return GenericAnalysisReportType.UserLicenseInvoice;
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        String amountText = this.amount.getElement().getText();
        UserInvoiceExportAnalysisReportConfiguration config = new UserInvoiceExportAnalysisReportConfiguration(this.getReportFormatType());
        config.setAmountFullUser(amountText);
        config.setStartDate(this.dateChooser.getStartDate());
        config.setEndDate(this.dateChooser.getEndDate());
        String amountMobileUser = this.amountMobileUser.getElement().getText();
        config.setAmountMobileUser(amountMobileUser);
        return config;
    }
}

