/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.recipe.factsheet;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.submodules.print.recipe.factsheet.ReformulateConverter;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.recipe.RecipeServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.RecipeReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.loaders.RecipeVariantLoader;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantReference;
import ch.icit.pegasus.server.core.dtos.report.RecipeFactsheetConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.report.RecipeFactsheetConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RecipeAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PrintRecipeFactSheetComponent
extends DefaultScrollablePrintPopup2<RecipeComplete>
implements ButtonListener,
NodeListener {
    private static final long serialVersionUID = 1L;
    private boolean isNoPro;
    private final Node<RecipeComplete> currentRecipe;
    private final Node configNode;
    private TitledItem<DateChooser> dueDate;
    private boolean showMaterialPriceAllowed;
    private boolean showProcessPriceAllowed;
    private TextLabel options;
    private final List<CostOption> optionsList = new ArrayList<CostOption>();
    private TitledItem<CheckBox> includeImage;
    private TitledItem<CheckBox> includeGross;
    private TitledItem<CheckBox> includeNet;
    private TitledItem<CheckBox> includePurchaseWaste;
    private TitledItem<CheckBox> includeAllergens;
    private TitledItem<CheckBox> includeAdditives;
    private TitledItem<CheckBox> includeTraces;
    private TitledItem<CheckBox> includeOthers;
    private TitledItem<CheckBox> includeSummary;
    private HorizontalSeparator sep5;
    private TitledItem<TextLabel> reformulate;
    private TitledItem<CheckBox> checkRecalc;
    private ArrowConnectorIcon connector;
    private TextLabel targetText;
    private InputComboBox targetAmount;
    private HorizontalSeparator sep6;
    private TitledItem<TitledItem<CheckBox>> selectAll;
    private Table2 table;

    public PrintRecipeFactSheetComponent(Node<RecipeComplete> node) {
        super(false, true, ReportTypeE.RECIPE);
        this.currentRecipe = node;
        Runnable r = () -> {
            ModuleAccessRightComplete r1 = HUDToolkit.getCurrentAccessRight(RecipeAccess.MODULE_RECIPE, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
            for (DataFieldAccessRightComplete a : r1.getFieldAccessRights()) {
                if (a.getField().getName().equals(RecipeAccess.SHOW_MATERIAL_COSTS.getName())) {
                    this.showMaterialPriceAllowed = true;
                    continue;
                }
                if (!a.getField().getName().equals(RecipeAccess.SHOW_PROCESS_COSTS.getName())) continue;
                this.showProcessPriceAllowed = true;
            }
        };
        this.loadBeforeShowing(r);
        RecipeFactsheetConfigurationComplete config = new RecipeFactsheetConfigurationComplete();
        RecipeComplete p = (RecipeComplete)this.currentRecipe.getValue(RecipeComplete.class);
        if (p != null) {
            config.setReformulate(new QuantityComplete(p.getCurrentVariant().getYield()));
        }
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
        this.loadVariants();
    }

    private void loadVariants() {
        Runnable r = () -> {
            RecipeComplete p = (RecipeComplete)this.currentRecipe.getValue();
            try {
                List ret = ((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipeVariants(new ListWrapper(p.getVariants())).getList();
                this.currentRecipe.getChildNamed(RecipeComplete_.variants).removeExistingValues();
                ArrayList refs = new ArrayList();
                refs.addAll(ret);
                this.currentRecipe.getChildNamed(RecipeComplete_.variants).setValue(refs, 0L);
                this.currentRecipe.getChildNamed(RecipeComplete_.variants).updateNode();
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        };
        this.loadBeforeShowing(r);
    }

    private void loadSubRecipes() {
        try {
            Map ids = ((RecipeReportServiceManager)ServiceManagerRegistry.getService(RecipeReportServiceManager.class)).getSubRecipes((RecipeReference)this.currentRecipe.getValue(), new TimestampWrapper((Timestamp)this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.dueDate).getValue())).getMap();
            Node idNode = this.currentRecipe.getChildNamed(new String[]{"suprecipes"});
            if (idNode == null) {
                idNode = new Node();
                idNode.setName("suprecipes");
                this.currentRecipe.addChild(idNode, 0L);
            } else {
                idNode.removeAllChilds();
            }
            idNode.removeExistingValues();
            idNode.setValue((Object)ids, 0L);
        }
        catch (ClientServerCallException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        if (this.isNoPro) {
            return;
        }
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            switch (n) {
                case "gross": {
                    this.includeGross.getElement().setChecked(b);
                    break;
                }
                case "net": {
                    this.includeNet.getElement().setChecked(b);
                    break;
                }
                case "image": {
                    this.includeImage.getElement().setChecked(b);
                    break;
                }
                case "waste": {
                    this.includePurchaseWaste.getElement().setChecked(b);
                    break;
                }
                case "allergens": {
                    this.includeAllergens.getElement().setChecked(b);
                    break;
                }
                case "additives": {
                    this.includeAdditives.getElement().setChecked(b);
                    break;
                }
                case "traces": {
                    this.includeTraces.getElement().setChecked(b);
                    break;
                }
                case "others": {
                    this.includeOthers.getElement().setChecked(b);
                    break;
                }
                case "summary": {
                    this.includeSummary.getElement().setChecked(b);
                }
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        if (!this.isNoPro) {
            conf.addProperty("gross", "" + this.includeGross.getElement().isChecked());
            conf.addProperty("net", "" + this.includeNet.getElement().isChecked());
            conf.addProperty("image", "" + this.includeImage.getElement().isChecked());
            conf.addProperty("waste", "" + this.includePurchaseWaste.getElement().isChecked());
            conf.addProperty("allergens", "" + this.includeAllergens.getElement().isChecked());
            conf.addProperty("additives", "" + this.includeAdditives.getElement().isChecked());
            conf.addProperty("others", "" + this.includeOthers.getElement().isChecked());
            conf.addProperty("traces", "" + this.includeTraces.getElement().isChecked());
            conf.addProperty("summary", "" + this.includeSummary.getElement().isChecked());
        }
        return conf;
    }

    @Override
    public void insertElements() {
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        this.getViewContainer().setLayout(new Layout());
        int innerGap = 5;
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.selectedVariant).addNodeListener((NodeListener)this);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.dueDate)), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.getElement().setIsTimestamp(true);
        this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.dueDate).addNodeListener((NodeListener)this);
        if (!this.isNoPro) {
            this.options = new TextLabel(Words.OPTIONS);
            if (this.showMaterialPriceAllowed) {
                this.optionsList.add(new CostOption(Words.INCLUDE_MATERIAL_COSTS, Words.DETAILS, this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.includeCosts), this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.includeCostDetails), fb, f, 5));
            }
            if (this.showProcessPriceAllowed) {
                this.optionsList.add(new CostOption(Words.INCLUDE_PROCESS_COSTS, Words.DETAILS, this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.includeProcessCosts), this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.includeProcessCostDetails), fb, f, 5));
            }
            this.includeSummary = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SUMMARY, TitledItem.TitledItemOrientation.EAST);
            this.includeSummary.setTitleFont(f);
            this.includeSummary.setTitleForeground(fb);
            this.includeAllergens = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ALLERGENS, TitledItem.TitledItemOrientation.EAST);
            this.includeAllergens.setTitleFont(f);
            this.includeAllergens.setTitleForeground(fb);
            this.includeAdditives = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ADDITIVES, TitledItem.TitledItemOrientation.EAST);
            this.includeAdditives.setTitleFont(f);
            this.includeAdditives.setTitleForeground(fb);
            this.includeTraces = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_TRACES, TitledItem.TitledItemOrientation.EAST);
            this.includeTraces.setTitleFont(f);
            this.includeTraces.setTitleForeground(fb);
            this.includeOthers = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_OTHERS, TitledItem.TitledItemOrientation.EAST);
            this.includeOthers.setTitleFont(f);
            this.includeOthers.setTitleForeground(fb);
            this.includeImage = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.includeImage)), Words.INCLUDE_IMAGE, TitledItem.TitledItemOrientation.EAST);
            this.includeGross = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.includeBrutto)), Words.INCLUDE + " " + Words.GROSS, TitledItem.TitledItemOrientation.EAST);
            this.includeNet = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.includeNetto)), Words.INCLUDE + " " + Words.NET, TitledItem.TitledItemOrientation.EAST);
            this.includePurchaseWaste = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.includePurchaseWaste)), Words.INCLUDE_PURCHASE_WASTE, TitledItem.TitledItemOrientation.EAST);
            this.options.setForeground(this.includeImage.getTitle().getComponentForeground());
            this.includeImage.setTitleForeground(fb);
            this.includeGross.setTitleForeground(fb);
            this.includeNet.setTitleForeground(fb);
            this.includePurchaseWaste.setTitleForeground(fb);
            this.sep5 = new HorizontalSeparator();
            this.reformulate = new TitledItem<TextLabel>(new TextLabel(this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.selectedVariant), ConverterRegistry.getConverter(ReformulateConverter.class)), Words.REFORMULATE, TitledItem.TitledItemOrientation.NORTH);
            this.checkRecalc = new TitledItem<CheckBox>(new CheckBox(), Words.RECALCULATE, TitledItem.TitledItemOrientation.EAST);
            this.checkRecalc.setInnerGap(innerGap);
            this.checkRecalc.getTitle().setFont(f);
            this.checkRecalc.getTitle().setForeground(fb);
            this.connector = new ArrowConnectorIcon();
            this.targetText = new TextLabel(Words.TARGET);
            this.targetAmount = new InputComboBox(this.configNode.getChildNamed(new DtoField[]{RecipeFactsheetConfigurationComplete_.reformulate, QuantityComplete_.quantity}), this.configNode.getChildNamed(new DtoField[]{RecipeFactsheetConfigurationComplete_.reformulate, QuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.targetAmount.setEnabled(false);
            this.targetAmount.setMaxKommaStellen(3);
            this.checkRecalc.getElement().addButtonListener(this);
            this.sep6 = new HorizontalSeparator();
            TitledItem<CheckBox> sb = new TitledItem<CheckBox>(new CheckBox(), Words.SELECT_ALL, TitledItem.TitledItemOrientation.EAST);
            sb.getTitle().setFont(f);
            sb.getTitle().setForeground(fb);
            sb.setInnerGap(innerGap);
            sb.getElement().addButtonListener(this);
            this.selectAll = new TitledItem<TitledItem<CheckBox>>(sb, Words.RECIPE_SELECTION, TitledItem.TitledItemOrientation.NORTH);
            this.table = new Table2(false, "", true, false);
            ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
            int tw = 60;
            columns.add(new TableColumnInfo(Words.PRINT, null, null, null, "", tw, tw, tw));
            columns.add(new TableColumnInfo(Words.RECIPE, null, null, null, "", 30, 30, 30));
            ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
            this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
            this.getViewContainer().add(this.options);
            for (CostOption o : this.optionsList) {
                this.getViewContainer().add(o);
            }
            this.getViewContainer().add(this.includeGross);
            this.getViewContainer().add(this.includeNet);
            this.getViewContainer().add(this.includeImage);
            this.getViewContainer().add(this.includePurchaseWaste);
            this.getViewContainer().add(this.includeAllergens);
            this.getViewContainer().add(this.includeAdditives);
            this.getViewContainer().add(this.includeTraces);
            this.getViewContainer().add(this.includeOthers);
            this.getViewContainer().add(this.includeSummary);
            this.getViewContainer().add(this.sep5);
            this.getViewContainer().add(this.reformulate);
            this.getViewContainer().add(this.checkRecalc);
            this.getViewContainer().add(this.connector);
            this.getViewContainer().add(this.targetText);
            this.getViewContainer().add(this.targetAmount);
            this.getViewContainer().add(this.sep6);
            this.getViewContainer().add(this.selectAll);
            this.getViewContainer().add(this.table);
        }
        this.getViewContainer().add(this.dueDate);
        this.ensureSelectAllState();
        this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.selectedVariant).setValue((Object)((RecipeComplete)this.currentRecipe.getValue()).getCurrentVariant(), 0L);
    }

    private Node createRecipeList() {
        ViewNode list = new ViewNode("List");
        Node n = this.currentRecipe.getChildNamed(new String[]{"suprecipes"});
        if (n != null && n.getValue() != null) {
            for (Map.Entry e : ((Map)n.getValue()).entrySet()) {
                ViewNode nn = new ViewNode("");
                nn.setValue(e, 0L);
                list.addChild((Node)nn, 0L);
            }
        }
        return list;
    }

    @Override
    public String getTitleString() {
        if (Boolean.TRUE.equals(((RecipeComplete)this.currentRecipe.getValue()).getServiceItem())) {
            return Words.SERVICE_ITEM_FACT_SHEET;
        }
        return Words.RECIPE_FACT_SHEET;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentRecipe.getChildNamed(new DtoField[]{RecipeComplete_.currentVariant, RecipeVariantLight_.name}).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.options != null) {
            this.dueDate.kill();
            if (!this.isNoPro) {
                this.options.kill();
                for (CostOption o : this.optionsList) {
                    o.kill();
                }
                this.includeGross.kill();
                this.includeNet.kill();
                this.includeImage.kill();
                this.includePurchaseWaste.kill();
                this.sep5.kill();
                this.sep6.kill();
                this.reformulate.kill();
                this.checkRecalc.kill();
                this.connector.kill();
                this.targetText.kill();
                this.selectAll.kill();
                this.table.kill();
            }
        }
        if (this.includeAllergens != null) {
            this.includeAllergens.kill();
        }
        if (this.includeAdditives != null) {
            this.includeAdditives.kill();
        }
        if (this.includeOthers != null) {
            this.includeOthers.kill();
        }
        if (this.includeTraces != null) {
            this.includeTraces.kill();
        }
        if (this.includeSummary != null) {
            this.includeSummary.kill();
        }
        this.sep5 = null;
        this.options = null;
        if (this.optionsList != null) {
            this.optionsList.clear();
        }
        this.includeGross = null;
        this.includeNet = null;
        this.includeImage = null;
        this.dueDate = null;
        this.sep6 = null;
        this.reformulate = null;
        this.checkRecalc = null;
        this.connector = null;
        this.targetText = null;
        this.includeAllergens = null;
        this.includeAdditives = null;
        this.includeTraces = null;
        this.includeOthers = null;
        this.includeSummary = null;
        this.selectAll = null;
        this.table = null;
        this.includePurchaseWaste = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.dueDate.setVisible(true);
        if (!this.isNoPro) {
            this.options.setVisible(true);
            for (CostOption o : this.optionsList) {
                o.setVisible(true);
            }
            this.includeGross.setVisible(true);
            this.includeNet.setVisible(true);
            this.includeImage.setVisible(true);
            this.includePurchaseWaste.setVisible(true);
            this.sep5.setVisible(true);
            this.sep6.setVisible(true);
            this.reformulate.setVisible(true);
            this.checkRecalc.setVisible(true);
            this.connector.setVisible(true);
            this.targetText.setVisible(true);
            this.selectAll.setVisible(true);
            this.table.setVisible(true);
            if (this.includeAllergens != null) {
                this.includeAllergens.setVisible(true);
            }
            if (this.includeAdditives != null) {
                this.includeAdditives.setVisible(true);
            }
            if (this.includeTraces != null) {
                this.includeTraces.setVisible(true);
            }
            if (this.includeOthers != null) {
                this.includeOthers.setVisible(true);
            }
            if (this.includeSummary != null) {
                this.includeSummary.setVisible(true);
            }
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(false);
        }
        if (this.options != null) {
            this.options.setVisible(false);
        }
        if (this.optionsList != null) {
            for (CostOption o : this.optionsList) {
                o.setVisible(false);
            }
        }
        if (this.includeGross != null) {
            this.includeGross.setVisible(false);
        }
        if (this.includeNet != null) {
            this.includeNet.setVisible(false);
        }
        if (this.includeImage != null) {
            this.includeImage.setVisible(false);
        }
        if (this.sep5 != null) {
            this.sep5.setVisible(false);
        }
        if (this.sep6 != null) {
            this.sep6.setVisible(false);
        }
        if (this.reformulate != null) {
            this.reformulate.setVisible(false);
        }
        if (this.checkRecalc != null) {
            this.checkRecalc.setVisible(false);
        }
        if (this.connector != null) {
            this.connector.setVisible(false);
        }
        if (this.targetText != null) {
            this.targetText.setVisible(false);
        }
        if (this.targetAmount != null) {
            this.targetAmount.setVisible(false);
        }
        if (this.selectAll != null) {
            this.selectAll.setVisible(false);
        }
        if (this.table != null) {
            this.table.setVisible(false);
        }
        if (this.includePurchaseWaste != null) {
            this.includePurchaseWaste.setVisible(false);
        }
        if (this.includeAllergens != null) {
            this.includeAllergens.setVisible(false);
        }
        if (this.includeAdditives != null) {
            this.includeAdditives.setVisible(false);
        }
        if (this.includeTraces != null) {
            this.includeTraces.setVisible(false);
        }
        if (this.includeOthers != null) {
            this.includeOthers.setVisible(false);
        }
        if (this.includeSummary != null) {
            this.includeSummary.setVisible(false);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        block5: {
            block4: {
                super.buttonPressed(source, x, y);
                if (source != this.checkRecalc.getElement()) break block4;
                this.targetAmount.setEnabled(this.checkRecalc.getElement().isChecked());
                break block5;
            }
            if (source != this.selectAll.getElement().getElement()) break block5;
            if (this.selectAll.getElement().getElement().isChecked()) {
                for (Table2RowPanel p : this.table.getRows()) {
                    TableRowImpl l = (TableRowImpl)p;
                    l.selectCheckBox();
                }
            } else {
                for (Table2RowPanel p : this.table.getRows()) {
                    TableRowImpl l = (TableRowImpl)p;
                    l.deselectBox();
                }
            }
        }
    }

    private void ensureSelectAllState() {
        if (!this.isNoPro) {
            if (this.table.getRows().size() == 0) {
                this.selectAll.setEnabled(false);
                this.table.setEnabled(false);
            } else {
                this.selectAll.setEnabled(true);
                this.table.setEnabled(true);
            }
            this.selectAll.getElement().getElement().setChecked(true);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintRecipeFactSheetComponent.this.getSelectedReport();
                PrintRecipeFactSheetComponent.this.configNode.commit();
                RecipeFactsheetConfigurationComplete config = (RecipeFactsheetConfigurationComplete)PrintRecipeFactSheetComponent.this.configNode.getValue();
                config.setStylesheet(file);
                if (!PrintRecipeFactSheetComponent.this.showMaterialPriceAllowed) {
                    config.setIncludeCosts(Boolean.valueOf(false));
                    config.setIncludeCostDetails(Boolean.valueOf(false));
                }
                if (!PrintRecipeFactSheetComponent.this.showProcessPriceAllowed) {
                    config.setIncludeProcessCosts(Boolean.valueOf(false));
                    config.setIncludeProcessCostDetails(Boolean.valueOf(false));
                }
                if (!PrintRecipeFactSheetComponent.this.isNoPro) {
                    config.setIncludeAllergens(Boolean.valueOf(((CheckBox)PrintRecipeFactSheetComponent.this.includeAllergens.getElement()).isChecked()));
                    config.setIncludeAdditives(Boolean.valueOf(((CheckBox)PrintRecipeFactSheetComponent.this.includeAdditives.getElement()).isChecked()));
                    config.setIncludeOthers(Boolean.valueOf(((CheckBox)PrintRecipeFactSheetComponent.this.includeOthers.getElement()).isChecked()));
                    config.setIncludeTraces(Boolean.valueOf(((CheckBox)PrintRecipeFactSheetComponent.this.includeTraces.getElement()).isChecked()));
                    config.setIncludeSummary(Boolean.valueOf(((CheckBox)PrintRecipeFactSheetComponent.this.includeSummary.getElement()).isChecked()));
                } else {
                    config.setIncludeAllergens(Boolean.valueOf(false));
                    config.setIncludeAdditives(Boolean.valueOf(false));
                    config.setIncludeOthers(Boolean.valueOf(false));
                    config.setIncludeTraces(Boolean.valueOf(false));
                    config.setIncludeSummary(Boolean.valueOf(false));
                    config.setIncludeNetto(Boolean.valueOf(true));
                    config.setIncludeBrutto(Boolean.valueOf(true));
                }
                config.setDto((IDTO)new RecipeReference(((RecipeComplete)PrintRecipeFactSheetComponent.this.currentRecipe.getValue()).getId()));
                if (((RadioButton)PrintRecipeFactSheetComponent.this.asPDF.getElement()).isChecked()) {
                    config.setFormat(ReportingOutputFormatE.PDF);
                } else {
                    config.setFormat(ReportingOutputFormatE.XLSX);
                }
                if (PrintRecipeFactSheetComponent.this.table != null && PrintRecipeFactSheetComponent.this.table.getModel() != null && PrintRecipeFactSheetComponent.this.table.getModel().getNode() != null) {
                    for (Table2RowPanel rowPanel : PrintRecipeFactSheetComponent.this.table.getRows()) {
                        TableRowImpl i = (TableRowImpl)rowPanel;
                        if (!i.isChecked()) continue;
                        config.getSubRecipes().add(new RecipeReference((Long)((Map.Entry)i.getModel().getNode().getValue()).getKey()));
                    }
                }
                config.setRecipe((RecipeComplete)PrintRecipeFactSheetComponent.this.currentRecipe.getValue());
                PegasusFileComplete t = (PegasusFileComplete)((RecipeReportServiceManager)ServiceManagerRegistry.getService(RecipeReportServiceManager.class)).getRecipeCard(config).getValue();
                PrintRecipeFactSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintRecipeFactSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<RecipeComplete> getCurrentNode() {
        return this.currentRecipe;
    }

    @Override
    public BatchJob<RecipeComplete> createBatchJob(Node<RecipeComplete> value, ThreadSafeExecutable job) {
        return null;
    }

    public void valueChanged(final Node<?> node) {
        ThreadSafeExecutable r = null;
        if (node.getName().equals(RecipeFactsheetConfigurationComplete_.dueDate.getFieldName())) {
            r = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    PrintRecipeFactSheetComponent.this.loadSubRecipes();
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            if (PrintRecipeFactSheetComponent.this.isKilled()) {
                                return;
                            }
                            if (!PrintRecipeFactSheetComponent.this.isNoPro) {
                                PrintRecipeFactSheetComponent.this.table.getModel().setNode(PrintRecipeFactSheetComponent.this.createRecipeList());
                            }
                            PrintRecipeFactSheetComponent.this.popup.enableOKButton(true);
                            PrintRecipeFactSheetComponent.this.popup.enablePreviewButton(true);
                            PrintRecipeFactSheetComponent.this.ensureSelectAllState();
                        }

                        public void errorOccurred(ClientException exception) {
                            if (PrintRecipeFactSheetComponent.this.isKilled()) {
                                return;
                            }
                            InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)PrintRecipeFactSheetComponent.this);
                            PrintRecipeFactSheetComponent.this.popup.enableOKButton(true);
                            PrintRecipeFactSheetComponent.this.popup.enablePreviewButton(true);
                            PrintRecipeFactSheetComponent.this.ensureSelectAllState();
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
        } else if (node.getName().equals(RecipeFactsheetConfigurationComplete_.selectedVariant.getFieldName())) {
            if (node.getValue(RecipeVariantComplete.class) == null) {
                r = new ThreadSafeExecutable(){

                    @Override
                    public Node<?> loadData() throws Exception {
                        new RecipeVariantLoader((RecipeVariantReference)node.getValue(RecipeVariantReference.class), null, node, PrintRecipeFactSheetComponent.this);
                        return null;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                PrintRecipeFactSheetComponent.this.popup.enableOKButton(false);
                                PrintRecipeFactSheetComponent.this.popup.enablePreviewButton(false);
                            }

                            public void errorOccurred(ClientException exception) {
                                PrintRecipeFactSheetComponent.this.popup.enableOKButton(false);
                                PrintRecipeFactSheetComponent.this.popup.enablePreviewButton(false);
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
            } else {
                RecipeVariantComplete rvc = (RecipeVariantComplete)node.getValue(RecipeVariantComplete.class);
                this.configNode.getChildNamed(RecipeFactsheetConfigurationComplete_.dueDate).setValue((Object)new Timestamp(System.currentTimeMillis()), 0L);
                this.configNode.getChildNamed(new DtoField[]{RecipeFactsheetConfigurationComplete_.reformulate, QuantityComplete_.quantity}).setValue((Object)rvc.getYield().getQuantity(), 0L);
                this.configNode.getChildNamed(new DtoField[]{RecipeFactsheetConfigurationComplete_.reformulate, QuantityComplete_.unit}).setValue((Object)rvc.getYield().getUnit(), 0L);
            }
        }
        if (r != null) {
            this.popup.enableOKButton(false);
            this.popup.enablePreviewButton(false);
            ThreadSafeLoader.run(r);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return false;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private CheckBox print;
        private TextLabel label;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.print = new CheckBox();
            this.print.setChecked(true);
            this.label = new TextLabel((String)((Map.Entry)m.getNode().getValue()).getValue());
            this.print.addButtonListener(this);
            this.print.setProgress(1.0f);
            this.label.setProgress(1.0f);
            this.setLayout(new InnerLayout());
            this.add(this.print);
            this.add(this.label);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.print.getStringValue();
                }
                case 1: {
                    return this.label.getText();
                }
            }
            return null;
        }

        public Long getCurrentId() {
            if (this.print.isChecked()) {
                return (Long)((Map.Entry)this.model.getNode().getValue()).getKey();
            }
            return null;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.print.kill();
            this.print = null;
            this.label.kill();
            this.label = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.print.setEnabled(isEnabled);
            this.label.setEnabled(isEnabled);
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.print.getFocusComponents();
        }

        public void deselectBox() {
            this.print.setChecked(false);
        }

        public void selectCheckBox() {
            this.print.setChecked(true);
        }

        public boolean isChecked() {
            return this.print.isChecked();
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            PrintRecipeFactSheetComponent.this.ensureSelectAllState();
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.print.setLocation((int)((double)w - TableRowImpl.this.print.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - TableRowImpl.this.print.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.print.setSize(TableRowImpl.this.print.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.label.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.label.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.label.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.label.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class CostOption
    extends JPanelFadable
    implements Focusable,
    ButtonListener {
        private static final long serialVersionUID = 1L;
        private TitledItem<CheckBox> firstItem;
        private ArrowConnectorIcon connector;
        private TitledItem<CheckBox> secondItem;

        public CostOption(String name1, String name2, Node first, Node second, Color fG, Font cF, int innerGap) {
            this.setOpaque(false);
            this.firstItem = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)first), name1, TitledItem.TitledItemOrientation.EAST);
            this.firstItem.setInnerGap(innerGap);
            this.firstItem.getTitle().setFont(cF);
            this.firstItem.getTitle().setForeground(fG);
            this.firstItem.getElement().addButtonListener(this);
            if (name2 != null) {
                this.connector = new ArrowConnectorIcon();
                this.secondItem = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)second), name2, TitledItem.TitledItemOrientation.EAST);
                this.secondItem.setInnerGap(innerGap);
                this.secondItem.getTitle().setFont(cF);
                this.secondItem.getTitle().setForeground(fG);
                this.secondItem.getElement().addButtonListener(this);
            }
            this.setLayout(new InnerLayout());
            this.add(this.firstItem);
            if (name2 != null) {
                this.add(this.secondItem);
                this.add(this.connector);
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.firstItem.setEnabled(isEnabled);
            if (this.secondItem != null) {
                this.secondItem.setEnabled(isEnabled);
            }
        }

        protected void checkIt() {
            this.firstItem.getElement().setChecked(true);
            if (this.secondItem != null) {
                this.secondItem.setEnabled(true);
            }
        }

        protected void uncheckIt() {
            this.firstItem.getElement().setChecked(false);
            if (this.secondItem != null) {
                this.secondItem.getElement().setChecked(false);
                this.secondItem.setEnabled(false);
            }
        }

        protected boolean isChecked() {
            return this.firstItem.getElement().isChecked();
        }

        protected boolean isDetailsChecked() {
            if (this.secondItem != null) {
                return this.secondItem.getElement().isChecked();
            }
            return false;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.firstItem.kill();
            this.firstItem = null;
            if (this.connector != null) {
                this.connector.kill();
            }
            this.connector = null;
            if (this.secondItem != null) {
                this.secondItem.kill();
            }
            this.secondItem = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.firstItem);
            CheckedListAdder.addToList(focusList, this.secondItem);
            return focusList;
        }

        @Override
        public Selectable getSelectDelegationComponent() {
            return null;
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source != this.firstItem.getElement() && source == this.secondItem.getElement()) {
                this.firstItem.getElement().setChecked(true);
            }
        }

        @Override
        public void requestFocusInWindowNow() {
            this.firstItem.requestFocusInWindowNow();
        }

        public void setFirstCheck(boolean checked) {
            this.firstItem.getElement().setChecked(checked);
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int innerGap = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_inner_horizontal_border"));
                CostOption.this.firstItem.setLocation(0, (int)(((double)parent.getHeight() - CostOption.this.firstItem.getPreferredSize().getHeight()) / 2.0));
                CostOption.this.firstItem.setSize(CostOption.this.firstItem.getPreferredSize());
                int cx = (parent.getWidth() - ArrowConnectorIcon.getPreferredWidth()) / 2;
                if (CostOption.this.connector != null) {
                    CostOption.this.connector.setLocation(cx, (int)(((double)parent.getHeight() - CostOption.this.connector.getPreferredSize().getHeight()) / 2.0));
                    CostOption.this.connector.setSize(CostOption.this.connector.getPreferredSize());
                    CostOption.this.secondItem.setLocation(CostOption.this.connector.getX() + CostOption.this.connector.getWidth() + 20, (int)(((double)parent.getHeight() - CostOption.this.secondItem.getPreferredSize().getHeight()) / 2.0));
                    CostOption.this.secondItem.setSize(CostOption.this.secondItem.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int h = (int)(CostOption.this.firstItem.getPreferredSize().getHeight() + 2.0);
                return new Dimension(0, h);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintRecipeFactSheetComponent.this.layoutInheritedComponents(parent);
            if (PrintRecipeFactSheetComponent.this.options != null) {
                PrintRecipeFactSheetComponent.this.dueDate.setLocation(PrintRecipeFactSheetComponent.this.border, y);
                PrintRecipeFactSheetComponent.this.dueDate.setSize(parent.getWidth() - 2 * PrintRecipeFactSheetComponent.this.border, (int)PrintRecipeFactSheetComponent.this.dueDate.getPreferredSize().getHeight());
                y = PrintRecipeFactSheetComponent.this.dueDate.getY() + PrintRecipeFactSheetComponent.this.dueDate.getHeight() + PrintRecipeFactSheetComponent.this.border;
                if (!PrintRecipeFactSheetComponent.this.isNoPro) {
                    PrintRecipeFactSheetComponent.this.options.setLocation(PrintRecipeFactSheetComponent.this.border, y);
                    PrintRecipeFactSheetComponent.this.options.setSize(parent.getWidth() - 2 * PrintRecipeFactSheetComponent.this.border, (int)PrintRecipeFactSheetComponent.this.options.getPreferredSize().getHeight());
                    y = PrintRecipeFactSheetComponent.this.options.getY() + PrintRecipeFactSheetComponent.this.options.getHeight() + PrintRecipeFactSheetComponent.this.border / 2;
                    for (CostOption o : PrintRecipeFactSheetComponent.this.optionsList) {
                        o.setLocation(PrintRecipeFactSheetComponent.this.border, y);
                        o.setSize(parent.getWidth() - 2 * PrintRecipeFactSheetComponent.this.border, (int)o.getPreferredSize().getHeight());
                        y = o.getY() + o.getHeight() + PrintRecipeFactSheetComponent.this.border / 2;
                    }
                    y += PrintRecipeFactSheetComponent.this.border / 2;
                    if (PrintRecipeFactSheetComponent.this.includeSummary != null) {
                        PrintRecipeFactSheetComponent.this.includeSummary.setLocation(PrintRecipeFactSheetComponent.this.border, y);
                        PrintRecipeFactSheetComponent.this.includeSummary.setSize(PrintRecipeFactSheetComponent.this.includeSummary.getPreferredSize());
                        y = PrintRecipeFactSheetComponent.this.includeSummary.getY() + PrintRecipeFactSheetComponent.this.includeSummary.getHeight() + PrintRecipeFactSheetComponent.this.border;
                    }
                    PrintRecipeFactSheetComponent.this.includeGross.setLocation(PrintRecipeFactSheetComponent.this.border, y);
                    PrintRecipeFactSheetComponent.this.includeGross.setSize(PrintRecipeFactSheetComponent.this.includeGross.getPreferredSize());
                    if (PrintRecipeFactSheetComponent.this.includeNet != null) {
                        PrintRecipeFactSheetComponent.this.includeNet.setLocation((parent.getWidth() - PrintRecipeFactSheetComponent.this.border) / 2 + PrintRecipeFactSheetComponent.this.border, y);
                        PrintRecipeFactSheetComponent.this.includeNet.setSize(PrintRecipeFactSheetComponent.this.includeNet.getPreferredSize());
                        y = PrintRecipeFactSheetComponent.this.includeNet.getY() + PrintRecipeFactSheetComponent.this.includeNet.getHeight() + PrintRecipeFactSheetComponent.this.border;
                    }
                    PrintRecipeFactSheetComponent.this.includeImage.setLocation(PrintRecipeFactSheetComponent.this.border, PrintRecipeFactSheetComponent.this.includeGross.getY() + PrintRecipeFactSheetComponent.this.includeGross.getHeight() + PrintRecipeFactSheetComponent.this.border / 2);
                    PrintRecipeFactSheetComponent.this.includeImage.setSize(PrintRecipeFactSheetComponent.this.includeImage.getPreferredSize());
                    y = PrintRecipeFactSheetComponent.this.includeImage.getY() + PrintRecipeFactSheetComponent.this.includeImage.getHeight() + PrintRecipeFactSheetComponent.this.border / 2;
                    PrintRecipeFactSheetComponent.this.includePurchaseWaste.setLocation(PrintRecipeFactSheetComponent.this.border, PrintRecipeFactSheetComponent.this.includeImage.getY() + PrintRecipeFactSheetComponent.this.includeImage.getHeight() + PrintRecipeFactSheetComponent.this.border / 2);
                    PrintRecipeFactSheetComponent.this.includePurchaseWaste.setSize(PrintRecipeFactSheetComponent.this.includePurchaseWaste.getPreferredSize());
                    y = PrintRecipeFactSheetComponent.this.includePurchaseWaste.getY() + PrintRecipeFactSheetComponent.this.includePurchaseWaste.getHeight() + PrintRecipeFactSheetComponent.this.border;
                    if (PrintRecipeFactSheetComponent.this.includeAllergens != null) {
                        PrintRecipeFactSheetComponent.this.includeAllergens.setLocation(PrintRecipeFactSheetComponent.this.border, y);
                        PrintRecipeFactSheetComponent.this.includeAllergens.setSize(PrintRecipeFactSheetComponent.this.includeAllergens.getPreferredSize());
                    }
                    if (PrintRecipeFactSheetComponent.this.includeAdditives != null) {
                        PrintRecipeFactSheetComponent.this.includeAdditives.setLocation((parent.getWidth() - PrintRecipeFactSheetComponent.this.border) / 2 + PrintRecipeFactSheetComponent.this.border, y);
                        PrintRecipeFactSheetComponent.this.includeAdditives.setSize(PrintRecipeFactSheetComponent.this.includeAdditives.getPreferredSize());
                        y = PrintRecipeFactSheetComponent.this.includeAdditives.getY() + PrintRecipeFactSheetComponent.this.includeAdditives.getHeight() + PrintRecipeFactSheetComponent.this.border / 2;
                    }
                    if (PrintRecipeFactSheetComponent.this.includeTraces != null) {
                        PrintRecipeFactSheetComponent.this.includeTraces.setLocation(PrintRecipeFactSheetComponent.this.border, y);
                        PrintRecipeFactSheetComponent.this.includeTraces.setSize(PrintRecipeFactSheetComponent.this.includeTraces.getPreferredSize());
                    }
                    if (PrintRecipeFactSheetComponent.this.includeOthers != null) {
                        PrintRecipeFactSheetComponent.this.includeOthers.setLocation((parent.getWidth() - PrintRecipeFactSheetComponent.this.border) / 2 + PrintRecipeFactSheetComponent.this.border, y);
                        PrintRecipeFactSheetComponent.this.includeOthers.setSize(PrintRecipeFactSheetComponent.this.includeOthers.getPreferredSize());
                        y = PrintRecipeFactSheetComponent.this.includeOthers.getY() + PrintRecipeFactSheetComponent.this.includeOthers.getHeight() + PrintRecipeFactSheetComponent.this.border;
                    }
                    PrintRecipeFactSheetComponent.this.sep5.setLocation(0, y);
                    PrintRecipeFactSheetComponent.this.sep5.setSize(parent.getWidth(), (int)PrintRecipeFactSheetComponent.this.sep5.getPreferredSize().getHeight());
                    PrintRecipeFactSheetComponent.this.reformulate.setLocation(PrintRecipeFactSheetComponent.this.border, PrintRecipeFactSheetComponent.this.sep5.getY() + PrintRecipeFactSheetComponent.this.sep5.getHeight() + PrintRecipeFactSheetComponent.this.border);
                    PrintRecipeFactSheetComponent.this.reformulate.setSize(parent.getWidth() - 2 * PrintRecipeFactSheetComponent.this.border, (int)PrintRecipeFactSheetComponent.this.reformulate.getPreferredSize().getHeight());
                    PrintRecipeFactSheetComponent.this.checkRecalc.setLocation(PrintRecipeFactSheetComponent.this.border, PrintRecipeFactSheetComponent.this.reformulate.getY() + PrintRecipeFactSheetComponent.this.reformulate.getHeight() + PrintRecipeFactSheetComponent.this.border / 2);
                    PrintRecipeFactSheetComponent.this.checkRecalc.setSize(PrintRecipeFactSheetComponent.this.checkRecalc.getPreferredSize());
                    PrintRecipeFactSheetComponent.this.connector.setLocation(PrintRecipeFactSheetComponent.this.checkRecalc.getX() + PrintRecipeFactSheetComponent.this.checkRecalc.getWidth() + 20, (int)((double)PrintRecipeFactSheetComponent.this.checkRecalc.getY() + (PrintRecipeFactSheetComponent.this.checkRecalc.getPreferredSize().getHeight() - PrintRecipeFactSheetComponent.this.connector.getPreferredSize().getHeight()) / 2.0) - 4);
                    PrintRecipeFactSheetComponent.this.connector.setSize(PrintRecipeFactSheetComponent.this.connector.getPreferredSize());
                    PrintRecipeFactSheetComponent.this.targetText.setLocation(PrintRecipeFactSheetComponent.this.connector.getX() + PrintRecipeFactSheetComponent.this.connector.getWidth() + 20, (int)((double)PrintRecipeFactSheetComponent.this.checkRecalc.getY() + (PrintRecipeFactSheetComponent.this.checkRecalc.getPreferredSize().getHeight() - PrintRecipeFactSheetComponent.this.targetText.getPreferredSize().getHeight()) / 2.0) - 4);
                    PrintRecipeFactSheetComponent.this.targetText.setSize(PrintRecipeFactSheetComponent.this.targetText.getPreferredSize());
                    PrintRecipeFactSheetComponent.this.targetAmount.setLocation(PrintRecipeFactSheetComponent.this.targetText.getX() + PrintRecipeFactSheetComponent.this.targetText.getWidth() + 20, (int)((double)PrintRecipeFactSheetComponent.this.checkRecalc.getY() + (PrintRecipeFactSheetComponent.this.checkRecalc.getPreferredSize().getHeight() - PrintRecipeFactSheetComponent.this.targetAmount.getPreferredSize().getHeight()) / 2.0) - 4);
                    PrintRecipeFactSheetComponent.this.targetAmount.setSize(PrintRecipeFactSheetComponent.this.targetAmount.getPreferredSize());
                    PrintRecipeFactSheetComponent.this.sep6.setLocation(0, PrintRecipeFactSheetComponent.this.targetAmount.getY() + PrintRecipeFactSheetComponent.this.targetAmount.getHeight() + PrintRecipeFactSheetComponent.this.border);
                    PrintRecipeFactSheetComponent.this.sep6.setSize(parent.getWidth(), (int)PrintRecipeFactSheetComponent.this.sep6.getPreferredSize().getHeight());
                    PrintRecipeFactSheetComponent.this.selectAll.setLocation(PrintRecipeFactSheetComponent.this.border, PrintRecipeFactSheetComponent.this.sep6.getY() + PrintRecipeFactSheetComponent.this.sep6.getHeight() + PrintRecipeFactSheetComponent.this.border);
                    PrintRecipeFactSheetComponent.this.selectAll.setSize(PrintRecipeFactSheetComponent.this.selectAll.getPreferredSize());
                    PrintRecipeFactSheetComponent.this.table.setLocation(PrintRecipeFactSheetComponent.this.border, PrintRecipeFactSheetComponent.this.selectAll.getY() + PrintRecipeFactSheetComponent.this.selectAll.getHeight() + PrintRecipeFactSheetComponent.this.border);
                    PrintRecipeFactSheetComponent.this.table.setSize(parent.getWidth() - 2 * PrintRecipeFactSheetComponent.this.border, parent.getHeight() - (PrintRecipeFactSheetComponent.this.table.getY() + PrintRecipeFactSheetComponent.this.border));
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintRecipeFactSheetComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (PrintRecipeFactSheetComponent.this.options != null) {
                h = (int)((double)h + PrintRecipeFactSheetComponent.this.dueDate.getPreferredSize().getHeight());
                h += PrintRecipeFactSheetComponent.this.border;
                if (!PrintRecipeFactSheetComponent.this.isNoPro) {
                    h = (int)((double)h + PrintRecipeFactSheetComponent.this.options.getPreferredSize().getHeight());
                    h += PrintRecipeFactSheetComponent.this.border;
                    for (CostOption o : PrintRecipeFactSheetComponent.this.optionsList) {
                        h = (int)((double)h + o.getPreferredSize().getHeight());
                        h += PrintRecipeFactSheetComponent.this.border / 2;
                    }
                    h += PrintRecipeFactSheetComponent.this.border / 2;
                    h = (int)((double)h + (PrintRecipeFactSheetComponent.this.includeGross.getPreferredSize().getHeight() + (double)(PrintRecipeFactSheetComponent.this.border / 2)));
                    h = (int)((double)h + (PrintRecipeFactSheetComponent.this.includeNet.getPreferredSize().getHeight() + (double)(PrintRecipeFactSheetComponent.this.border / 2)));
                    h = (int)((double)h + (PrintRecipeFactSheetComponent.this.includeImage.getPreferredSize().getHeight() + (double)(PrintRecipeFactSheetComponent.this.border / 2)));
                    h = (int)((double)h + (PrintRecipeFactSheetComponent.this.includePurchaseWaste.getPreferredSize().getHeight() + (double)PrintRecipeFactSheetComponent.this.border));
                    if (PrintRecipeFactSheetComponent.this.includeSummary != null) {
                        h = (int)((double)h + PrintRecipeFactSheetComponent.this.includeSummary.getPreferredSize().getHeight());
                        h += PrintRecipeFactSheetComponent.this.border / 2;
                    }
                    if (PrintRecipeFactSheetComponent.this.includeAllergens != null) {
                        h = (int)((double)h + PrintRecipeFactSheetComponent.this.includeAllergens.getPreferredSize().getHeight());
                        h += PrintRecipeFactSheetComponent.this.border / 2;
                    }
                    if (PrintRecipeFactSheetComponent.this.includeTraces != null) {
                        h = (int)((double)h + PrintRecipeFactSheetComponent.this.includeTraces.getPreferredSize().getHeight());
                        h += PrintRecipeFactSheetComponent.this.border / 2;
                    }
                    h += PrintRecipeFactSheetComponent.this.border / 2;
                    h = (int)((double)h + (PrintRecipeFactSheetComponent.this.sep5.getPreferredSize().getHeight() + (double)PrintRecipeFactSheetComponent.this.border));
                    h = (int)((double)h + (PrintRecipeFactSheetComponent.this.reformulate.getPreferredSize().getHeight() + (double)PrintRecipeFactSheetComponent.this.border));
                    h = (int)((double)h + (PrintRecipeFactSheetComponent.this.checkRecalc.getPreferredSize().getHeight() + (double)PrintRecipeFactSheetComponent.this.border));
                    h = (int)((double)h + (PrintRecipeFactSheetComponent.this.sep6.getPreferredSize().getHeight() + (double)PrintRecipeFactSheetComponent.this.border));
                    h = (int)((double)h + (PrintRecipeFactSheetComponent.this.selectAll.getPreferredSize().getHeight() + (double)PrintRecipeFactSheetComponent.this.border));
                    h += 200;
                }
            }
            return new Dimension(w, h);
        }
    }
}

