/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.recipe.usage;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.icons.ToogleSkinIcon;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchTypeE;
import ch.icit.pegasus.server.core.dtos.search.ProductVariantSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.RecipeSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.RecipeVariantSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PrintRecipeUseageComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private final Node<RecipeComplete> currentRecipe;
    private TitledItem<DateChooser> dateChooser;
    private TitledItem<Table2> table;
    protected boolean isLoadingRemains = false;

    public PrintRecipeUseageComponent(Node<RecipeComplete> currentNode) {
        super(true, false);
        this.currentRecipe = currentNode;
        this.getViewContainer().setLayout(new Layout());
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    public String getLoadingRemains() {
        return "Load Recipe Data";
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        this.createComponents();
        this.isLoadingRemains = true;
        this.loadItems();
    }

    private void loadItems() {
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.removeInheritedComponents();
        this.ensureAnimation(this.getLoadingRemains());
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductSearchConfiguration c;
                ProductVariantLight next;
                RecipeComplete recL = (RecipeComplete)PrintRecipeUseageComponent.this.currentRecipe.getValue(RecipeComplete.class);
                ProductVariantSearchConfiguration psc = new ProductVariantSearchConfiguration();
                psc.setRecipe(new RecipeReference(recL.getId()));
                psc.setValidityDate(new Timestamp(PrintRecipeUseageComponent.this.dateChooser != null ? ((Date)((DateChooser)PrintRecipeUseageComponent.this.dateChooser.getElement()).getNode().getValue()).getTime() : System.currentTimeMillis()));
                RecipeVariantSearchConfiguration rsc = new RecipeVariantSearchConfiguration();
                rsc.setRecipe(new RecipeReference(recL.getId()));
                rsc.setValidityDate(new Timestamp(PrintRecipeUseageComponent.this.dateChooser != null ? ((Date)((DateChooser)PrintRecipeUseageComponent.this.dateChooser.getElement()).getNode().getValue()).getTime() : System.currentTimeMillis()));
                Iterator productIterator = null;
                Iterator recipeIterator = null;
                productIterator = new SearchResultIterator((ASearchConfiguration)psc).iterator();
                recipeIterator = new SearchResultIterator((ASearchConfiguration)rsc).iterator();
                ViewNode nn = new ViewNode("");
                while (productIterator.hasNext()) {
                    next = (ProductVariantLight)productIterator.next();
                    if (next.getProduct() == null) {
                        c = new ProductSearchConfiguration();
                        c.setNumber(next.getProductNumber());
                        c.setProductSearchType(ProductSearchTypeE.PRODUCT_NUMBER);
                        ProductComplete product = (ProductComplete)new SearchResultIterator((ASearchConfiguration)c).next();
                        next.setProduct(product);
                    }
                    nn.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)next, false, false), 0L);
                }
                while (recipeIterator.hasNext()) {
                    next = (RecipeVariantLight)recipeIterator.next();
                    if (next.getRecipe() == null) {
                        c = new RecipeSearchConfiguration();
                        c.setNumber(next.getNumber());
                        RecipeComplete recipe = (RecipeComplete)new SearchResultIterator((ASearchConfiguration)c).next();
                        next.setRecipe(recipe);
                    }
                    nn.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)next, false, false), 0L);
                }
                return nn;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintRecipeUseageComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void remoteObjectLoaded(Node node) {
        if (this.isLoadingRemains) {
            this.popup.enableCancelButton(true);
            if (this.errorMSG == null) {
                this.removeAnimation(false);
                this.createInners();
                this.table.getElement().getModel().setNode(node);
                this.createComponents();
                this.popup.enableCancelButton(true);
            } else {
                this.removeAnimation(true);
            }
            this.isLoadingRemains = false;
        } else {
            this.table.getElement().getModel().setNode(node);
            this.removeAnimation(false);
            this.popup.enableOKButton(true);
            this.popup.enableCancelButton(true);
            this.showInheritedComponents();
            super.remoteObjectLoaded(node);
        }
    }

    public String getUnableToLoadString() {
        return "Unable to load recipe usage:";
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
        }
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(false);
        }
    }

    @Override
    public void showInheritedComponents() {
        super.showInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(true);
        }
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(true);
        }
    }

    public String getInnerText() {
        return "RECIPE IS USED IN";
    }

    private void createInners() {
        this.dateChooser = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.table = new TitledItem<Table2>(new Table2(false, null, true, false), this.getInnerText(), TitledItem.TitledItemOrientation.NORTH);
        this.table.setIgnorePrefHeight(true);
        this.table.getElement().setRequestFocusOnAdd(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.CUSTOMER, null, null, null, "", 60, 60, 60));
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", 60, 60, 60));
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.VALIDITY, null, null, null, "", TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        columns.add(new TableColumnInfo("Deleted", null, null, null, "", DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getElement().getCellPadding()));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        this.table.getElement().setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.setProgress(1.0f);
        this.dateChooser.getElement().addDateChooserListener((source, selectedDate) -> this.loadItems());
        this.getViewContainer().add(this.dateChooser);
        this.getViewContainer().add(this.table);
    }

    @Override
    public String getTitleString() {
        return "RECIPE NAME";
    }

    @Override
    protected String getProgressText() {
        if (this.isLoadingRemains) {
            return "Load Recipe Data";
        }
        return "Print Recipe Usage";
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentRecipe.getChildNamed(new DtoField[]{RecipeComplete_.currentVariant, RecipeVariantLight_.name}).getValue();
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Date dueDate = (Date)((DateChooser)PrintRecipeUseageComponent.this.dateChooser.getElement()).getNode().getValue();
                PegasusFileComplete file = (PegasusFileComplete)((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).printRecipeUsage((RecipeReference)PrintRecipeUseageComponent.this.currentRecipe.getValue(), new DateWrapper(dueDate), ReportingOutputFormatE.XLSX).getValue();
                PrintPopupToolkit.previewFile(file);
                return new ViewNode("");
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintRecipeUseageComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel type;
        private TextLabel customer;
        private TextLabel validity;
        private TextLabel number;
        private TextLabel name;
        private ToogleSkinIcon skin;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            boolean deleted = false;
            this.type = new TextLabel();
            if (m.getNode().getValue() instanceof ProductVariantLight) {
                this.type.setText("Product");
                this.name = new TextLabel(m.getNode().getChildNamed(new String[]{"name"}), ConverterRegistry.getConverter(StringConverter.class));
                this.number = new TextLabel(m.getNode().getChildNamed(new String[]{"product-number"}), ConverterRegistry.getConverter(IntegerConverter.class));
                this.customer = new TextLabel(m.getNode().getChildNamed(new String[]{"product-customer-code"}));
                this.validity = new TextLabel(m.getNode().getChildNamed(new String[]{"validityPeriod"}), ConverterRegistry.getConverter(PeriodConverter.class));
                deleted = ((ProductVariantLight)m.getNode().getValue()).getProduct().getIsDeleted();
            } else if (m.getNode().getValue() instanceof RecipeVariantLight) {
                this.type.setText("Recipe");
                this.name = new TextLabel(m.getNode().getChildNamed(new String[]{"name"}), ConverterRegistry.getConverter(StringConverter.class));
                this.number = new TextLabel(m.getNode().getChildNamed(new String[]{"number"}), ConverterRegistry.getConverter(IntegerConverter.class));
                this.validity = new TextLabel(m.getNode().getChildNamed(new String[]{"validityPeriod"}), ConverterRegistry.getConverter(PeriodConverter.class));
                deleted = ((RecipeVariantLight)m.getNode().getValue()).getRecipe().getIsDeleted();
            } else {
                return;
            }
            this.skin = new ToogleSkinIcon(DefaultSkins.CheckCrossBoxIcon, !deleted);
            this.type.setProgress(1.0f);
            this.number.setProgress(1.0f);
            this.name.setProgress(1.0f);
            this.validity.setProgress(1.0f);
            this.skin.setProgress(1.0f);
            this.setLayout(new Layout());
            this.add(this.type);
            this.add(this.number);
            this.add(this.name);
            if (this.customer != null) {
                this.add(this.customer);
            }
            this.add(this.validity);
            this.add(this.skin);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.type.kill();
            this.number.kill();
            this.name.kill();
            this.skin.kill();
            if (this.customer != null) {
                this.customer.kill();
            }
            this.validity.kill();
            this.type = null;
            this.number = null;
            this.name = null;
            this.customer = null;
            this.validity = null;
            this.skin = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.type.getText();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(new String[]{"number"}).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(new String[]{"name"}).getValue();
                }
                case 4: {
                    return this.model.getNode().getChildNamed(new String[]{"validityPeriod"}).getValue();
                }
                case 5: {
                    return null;
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            if (this.type != null) {
                this.type.setEnabled(isEnabled);
            }
            if (this.number != null) {
                this.number.setEnabled(isEnabled);
            }
            if (this.name != null) {
                this.name.setEnabled(isEnabled);
            }
            if (this.customer != null) {
                this.customer.setEnabled(isEnabled);
            }
            if (this.validity != null) {
                this.validity.setEnabled(isEnabled);
            }
            if (this.skin != null) {
                this.skin.setEnabled(isEnabled);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                if (TableRowImpl.this.model.getNode().getValue() instanceof ProductVariantLight) {
                    TableRowImpl.this.customer.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customer.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.customer.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customer.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                    TableRowImpl.this.number.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.number.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.number.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.number.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                    TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                    TableRowImpl.this.validity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.validity.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.validity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.validity.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                    TableRowImpl.this.skin.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.skin.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.skin.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.skin.getPreferredSize().getHeight());
                } else if (TableRowImpl.this.model.getNode().getValue() instanceof RecipeVariantLight) {
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                    TableRowImpl.this.number.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.number.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.number.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.number.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                    TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                    TableRowImpl.this.validity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.validity.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.validity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.validity.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                    TableRowImpl.this.skin.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.skin.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.skin.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.skin.getPreferredSize().getHeight());
                }
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = PrintRecipeUseageComponent.this.layoutInheritedComponents(parent);
            cy += PrintRecipeUseageComponent.this.border;
            if (PrintRecipeUseageComponent.this.dateChooser != null) {
                PrintRecipeUseageComponent.this.dateChooser.setLocation(PrintRecipeUseageComponent.this.border, cy);
                PrintRecipeUseageComponent.this.dateChooser.setSize(PrintRecipeUseageComponent.this.dateChooser.getPreferredSize());
                cy = PrintRecipeUseageComponent.this.dateChooser.getY() + PrintRecipeUseageComponent.this.dateChooser.getHeight() + PrintRecipeUseageComponent.this.border / 2;
            }
            if (PrintRecipeUseageComponent.this.table != null) {
                PrintRecipeUseageComponent.this.table.setLocation(PrintRecipeUseageComponent.this.border, cy);
                PrintRecipeUseageComponent.this.table.setSize(parent.getWidth() - 2 * PrintRecipeUseageComponent.this.border, parent.getHeight() - (cy + PrintRecipeUseageComponent.this.border));
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintRecipeUseageComponent.this.getInheritedComponentsHeight() + PrintRecipeUseageComponent.this.border;
            return new Dimension(0, h);
        }
    }
}

