/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.store.checkin.labels.article;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupLight;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupLight_;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class PrintArticleLabelsComponent
extends DefaultScrollablePrintPopup2<StockCheckinGroupLight> {
    private static final long serialVersionUID = 1L;
    private Node<StockCheckinGroupLight> order;
    private TitledItem<TextField> startPosition;
    private TitledItem<CheckBox> includeBarCode;

    public PrintArticleLabelsComponent(Node<StockCheckinGroupLight> currentNode) {
        super(true, true, false, false, ReportTypeE.ARTICLE_STORE_INFO_SHEET);
        this.order = currentNode;
    }

    @Override
    public boolean isReportAllowed(ReportFileComplete reportFile) {
        return reportFile.getDescription().contains("Label");
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public String getTitleString() {
        return Words.ORDER;
    }

    @Override
    public String getTitleValue() {
        return "" + this.order.getChildNamed(StockCheckinGroupLight_.number).getValue();
    }

    @Override
    public void createComponents() {
        super.createComponents();
        this.getViewContainer().setLayout(new Layout());
        this.includeBarCode = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_BAR_CODE, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.includeBarCode);
        this.includeBarCode.getElement().setChecked(true);
        this.startPosition = new TitledItem<TextField>(new TextField((Node)new DTONode(), TextFieldType.INT), Words.START_POSITION, TitledItem.TitledItemOrientation.NORTH);
        this.startPosition.getElement().setText("1");
        this.getViewContainer().add(this.startPosition);
        this.validate();
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.includeBarCode);
        CheckedListAdder.addToList(focusList, this.startPosition);
        return focusList;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.startPosition.kill();
        this.startPosition = null;
        this.includeBarCode.kill();
        this.includeBarCode = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete selectedReport = PrintArticleLabelsComponent.this.getSelectedReport();
                int count = 1;
                try {
                    count = Integer.valueOf(((TextField)PrintArticleLabelsComponent.this.startPosition.getElement()).getText());
                }
                catch (NumberFormatException e) {
                    count = 1;
                }
                boolean inclBarCode = ((CheckBox)PrintArticleLabelsComponent.this.includeBarCode.getElement()).isChecked();
                PegasusFileComplete t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createArticleLabels(new StockCheckinGroupReference(((StockCheckinGroupLight)PrintArticleLabelsComponent.this.order.getValue()).getId()), selectedReport, count, inclBarCode).getValue();
                PrintArticleLabelsComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleLabelsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<StockCheckinGroupLight> getCurrentNode() {
        return this.order;
    }

    @Override
    public BatchJob<StockCheckinGroupLight> createBatchJob(Node<StockCheckinGroupLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void insertElements() {
        this.createComponents();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintArticleLabelsComponent.this.layoutInheritedComponents(parent);
            PrintArticleLabelsComponent.this.includeBarCode.setLocation(PrintArticleLabelsComponent.this.border, PrintArticleLabelsComponent.this.border + y);
            PrintArticleLabelsComponent.this.includeBarCode.setSize(parent.getWidth() - 2 * PrintArticleLabelsComponent.this.border, (int)PrintArticleLabelsComponent.this.includeBarCode.getPreferredSize().getHeight());
            PrintArticleLabelsComponent.this.startPosition.setLocation(PrintArticleLabelsComponent.this.border, PrintArticleLabelsComponent.this.includeBarCode.getY() + PrintArticleLabelsComponent.this.includeBarCode.getHeight() + PrintArticleLabelsComponent.this.border);
            PrintArticleLabelsComponent.this.startPosition.setSize(parent.getWidth() - 2 * PrintArticleLabelsComponent.this.border, (int)PrintArticleLabelsComponent.this.startPosition.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (PrintArticleLabelsComponent.this.animation != null) {
                return PrintArticleLabelsComponent.this.animation.getPreferredSize();
            }
            int h = PrintArticleLabelsComponent.this.getInheritedComponentsHeight();
            return new Dimension(100, h);
        }
    }
}

