/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.store.checkout.product;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckoutGroupLight;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckoutGroupReference;
import ch.icit.pegasus.server.core.dtos.report.ProductGroupCheckoutReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;

public class PrintProductGroupCheckoutReportComponent
extends DefaultScrollablePrintPopup2<ProductStockCheckoutGroupLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Node<ProductStockCheckoutGroupLight> node;
    private TitledItem<CheckBox> includeCharge;
    private TitledItem<CheckBox> includeExpiryDate;

    public PrintProductGroupCheckoutReportComponent(Node<ProductStockCheckoutGroupLight> node) {
        super(false, true, ReportTypeE.PRODUCT_CHECKOUT_SHEET);
        this.node = node;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.includeCharge = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CHARGE, TitledItem.TitledItemOrientation.EAST);
        this.includeExpiryDate = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_EXPIRY_DATE, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.includeCharge);
        this.getViewContainer().add(this.includeExpiryDate);
        this.createComponents();
    }

    @Override
    public String getTitleString() {
        return Words.CHECKOUT_GROUP;
    }

    @Override
    public String getTitleValue() {
        return ((ProductStockCheckoutGroupLight)this.node.getValue()).getName();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintProductGroupCheckoutReportComponent.this.getSelectedReport();
                ProductGroupCheckoutReportConfiguration config = new ProductGroupCheckoutReportConfiguration();
                config.setGroup(new ProductStockCheckoutGroupReference(((ProductStockCheckoutGroupLight)PrintProductGroupCheckoutReportComponent.this.node.getValue()).getId()));
                config.setIncludeCharge(((CheckBox)PrintProductGroupCheckoutReportComponent.this.includeCharge.getElement()).isChecked());
                config.setIncludeExpiryDate(((CheckBox)PrintProductGroupCheckoutReportComponent.this.includeExpiryDate.getElement()).isChecked());
                config.setStylesheet(file);
                if (PrintProductGroupCheckoutReportComponent.this.asXLS != null && ((RadioButton)PrintProductGroupCheckoutReportComponent.this.asXLS.getElement()).isChecked()) {
                    config.setFormat(ReportingOutputFormatE.XLSX);
                } else {
                    config.setFormat(ReportingOutputFormatE.PDF);
                }
                PegasusFileComplete t = (PegasusFileComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).createProductGroupCheckoutReport(config).getValue();
                PrintProductGroupCheckoutReportComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductGroupCheckoutReportComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ProductStockCheckoutGroupLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<ProductStockCheckoutGroupLight> createBatchJob(Node<ProductStockCheckoutGroupLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintProductGroupCheckoutReportComponent.this.layoutInheritedComponents(parent) + PrintProductGroupCheckoutReportComponent.this.border;
            PrintProductGroupCheckoutReportComponent.this.includeCharge.setLocation(PrintProductGroupCheckoutReportComponent.this.border, y);
            PrintProductGroupCheckoutReportComponent.this.includeCharge.setSize(PrintProductGroupCheckoutReportComponent.this.includeCharge.getPreferredSize());
            y = PrintProductGroupCheckoutReportComponent.this.includeCharge.getY() + PrintProductGroupCheckoutReportComponent.this.includeCharge.getHeight() + PrintProductGroupCheckoutReportComponent.this.border / 2;
            PrintProductGroupCheckoutReportComponent.this.includeExpiryDate.setLocation(PrintProductGroupCheckoutReportComponent.this.border, y);
            PrintProductGroupCheckoutReportComponent.this.includeExpiryDate.setSize(PrintProductGroupCheckoutReportComponent.this.includeExpiryDate.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductGroupCheckoutReportComponent.this.getInheritedComponentsHeight();
            h += PrintProductGroupCheckoutReportComponent.this.border;
            h = (int)((double)h + PrintProductGroupCheckoutReportComponent.this.includeCharge.getPreferredSize().getHeight());
            h += PrintProductGroupCheckoutReportComponent.this.border / 2;
            h = (int)((double)h + PrintProductGroupCheckoutReportComponent.this.includeExpiryDate.getPreferredSize().getHeight());
            int w = 250;
            return new Dimension(w, h += PrintProductGroupCheckoutReportComponent.this.border);
        }
    }
}

