/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.DragController;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyBox;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyGridPanel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.TopLevelRepainter;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class GalleyBoxDragController
implements DragController {
    private PegasusSubModule thePegasus;

    public GalleyBoxDragController(PegasusSubModule g) {
        this.thePegasus = g;
    }

    @Override
    public void startDragging(GalleyBox box, boolean isResize) {
        GalleyGridPanel aGridPanel = this.thePegasus.getGridPanel4Box(box);
        if (aGridPanel != null && this.thePegasus.getCurrentState() == 7 && !aGridPanel.isSubGrid()) {
            box.setSpecialState(true);
        } else {
            box.setSpecialState(false);
        }
        if (aGridPanel != null) {
            this.thePegasus.startGalleyBoxDragging(box, aGridPanel, box.getNode());
            Rectangle aGridRect = aGridPanel.getGridRectangle();
            if (aGridRect != null) {
                if (!isResize) {
                    box.expandShadowSize(true);
                }
                if (isResize) {
                    Point p = SwingUtilities.convertPoint(box.getParent(), box.getLocation(), aGridPanel);
                    box.setLocation((int)p.getX(), (int)p.getY());
                    box.getParent().remove(box);
                    aGridPanel.add((Component)box, 0);
                    aGridPanel.setComponentZOrder(aGridPanel.getEditor(), 0);
                } else {
                    Point p = SwingUtilities.convertPoint(box.getParent(), box.getLocation(), this.thePegasus);
                    box.setLocation((int)p.getX(), (int)p.getY());
                    box.setDragStartPoint(box.getX(), box.getY());
                    box.getParent().remove(box);
                    this.thePegasus.add((Component)box, 0);
                }
                aGridPanel.removeBox(box);
            }
        }
    }

    @Override
    public void stopDragging(GalleyBox box) {
        this.thePegasus.stopGalleyBoxDragging();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkUnderground(GalleyBox item) {
        int dragItemY;
        int dragItemX = item.getX() + item.getDragOffsetX();
        GalleyGridPanel aGridPanel = this.thePegasus.getIntersectingGalleyGrid(dragItemX, dragItemY = item.getY() + item.getDragOffsetY());
        if (aGridPanel == null) return false;
        if (!aGridPanel.isGridActiv()) {
            return false;
        }
        Rectangle gridRect = aGridPanel.getGridRectangle();
        dragItemX = (int)((double)dragItemX - gridRect.getX());
        dragItemY = (int)((double)dragItemY - gridRect.getY());
        double aXSize = 0.0;
        double aYSize = item.getDHeight();
        double aZSize = 0.0;
        if (aGridPanel.isSubGrid()) {
            aXSize = item.getDDepth();
        } else {
            aXSize = item.getDWidth();
            aZSize = item.getDDepth();
        }
        int res = aGridPanel.isEmptyField(dragItemX, dragItemY -= item.getDragOffsetY(), aXSize, aYSize, aZSize);
        if (res <= 0) return false;
        item.expandShadowSize(false);
        if (this.thePegasus.getCurrentState() == 7 && !aGridPanel.isSubGrid()) {
            if (aGridPanel.getModel().getNode().getName().equals("Balley")) {
                aGridPanel.addBox(dragItemX, dragItemY, item);
                return true;
            } else {
                if (res > 1) {
                    GalleyBox box = aGridPanel.getBox4ConcretCoordinates(dragItemX, dragItemY);
                    item.setBehindBox(box);
                    box.setFrontBox(item);
                    item.setSecondTrolley(true);
                }
                aGridPanel.addSpecialBox(dragItemX, dragItemY, item);
            }
            return true;
        } else if (this.thePegasus.getCurrentState() == 7) {
            Node dragNode = item.getNode();
            Node galleyNode = aGridPanel.getModel().getNode();
            if (!this.thePegasus.getItemInputRule().isInputAllowed(galleyNode, dragNode)) return false;
            aGridPanel.addBox(dragItemX, dragItemY, item);
            aGridPanel.highlightGrid(-1, -1);
            return true;
        } else {
            aGridPanel.addBox(dragItemX, dragItemY, item);
            aGridPanel.highlightGrid(-1, -1);
        }
        return true;
    }

    @Override
    public void moveBox(int x, int y, GalleyBox item) {
        Rectangle or = new Rectangle();
        or.setBounds(item.getX(), item.getY(), item.getWidth(), item.getHeight());
        Rectangle nr = new Rectangle();
        nr.setBounds(x, y, item.getWidth(), item.getHeight());
        item.movePanel(x, y, false);
        int dragItemX = item.getX() + item.getDragOffsetX();
        int dragItemY = item.getY() + item.getDragOffsetY();
        GalleyGridPanel aGridPanel = this.thePegasus.getIntersectingGalleyGrid(dragItemX, dragItemY);
        if (aGridPanel != null) {
            Rectangle gridRect = aGridPanel.getGridRectangle();
            dragItemX = (int)((double)dragItemX - gridRect.getX());
            dragItemY = (int)((double)dragItemY - gridRect.getY());
            if (this.thePegasus.getCurrentState() != 7 || !aGridPanel.isSubGrid()) {
                // empty if block
            }
            boolean isPreview = false;
            if (aGridPanel.isSubGrid()) {
                isPreview = true;
                aGridPanel.setMultiplier(item.getDDepth(), item.getDHeight(), item.getDDepth());
            } else if (this.thePegasus.getCurrentState() == 3) {
                isPreview = true;
                aGridPanel.setMultiplier(item.getDWidth(), item.getDHeight(), item.getDDepth());
            }
            if (isPreview) {
                this.thePegasus.highlightGridPanel(aGridPanel, dragItemX, dragItemY -= item.getDragOffsetY());
            } else {
                this.thePegasus.highlightGridPanel(null, -1, -1);
            }
        } else {
            this.thePegasus.highlightGridPanel(null, -1, -1);
        }
        Rectangle nnr = or.union(nr);
        TopLevelRepainter.simpleRepaint(this.thePegasus, 32L, nnr);
    }

    public void newNodeSelected(Node<String> node, GalleyGridPanel panel) {
    }

    @Override
    public String getSelectedGalleyName() {
        return this.thePegasus.getGalley().getTitleString();
    }

    @Override
    public void removeBox(GalleyBox box) {
        if (box.getGalley() == this.thePegasus.getGalley() && box.isSelected() == 2) {
            this.thePegasus.getGalleySubGalley().getModel().setNode(null);
        }
    }
}

