/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.deliveryinstruction;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.converter.ProductDistributionAmountConverter;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.deliveryinstruction.utils.SPMLStrategyPopup;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.FadeInOutPanel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.ConfigButton;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.ExpandIcon;
import ch.icit.pegasus.client.gui.utils.icons.impl.TableIndentArrow;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.tables.comparators.SequenceNumberComparator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.DeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ProductDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ServiceDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliveryInstructionComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.EquipmentDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.EquipmentDistributionRuleComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyDistributionRuleComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ProductDistributionView
extends FadeInOutPanel {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private Comparator comparator = ComparatorRegistry.getComparator(SequenceNumberComparator.class);

    public ProductDistributionView(Node node) {
        super(true);
        this.setHasBackground(true);
        this.setTitleString(Words.PRODUCT_DISTRIBUTION);
        this.table = new Table2(false, "", false, false);
        this.table.setComparator(ComparatorRegistry.getComparator(SequenceNumberComparator.class));
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(0.0, 0.0, Words.GALLEY, null, null, null, "", 70, 70, 70));
        columns.add(new TableColumnInfo(1.0, 0.0, Words.POSITION, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(0.0, 0.0, Words.AMOUNT, null, null, null, "", 70, 70, 70));
        int tw = 2 * this.table.getCellPadding() + this.table.getInnerCellPadding() + 2 * ArrowButton.getPreferredWidth() + 5;
        columns.add(new TableColumnInfo(0.0, 0.0, Words.SPML_SHORT, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(0.0, 0.0, Words.ALA_CARTE, null, null, null, "", tw, tw, tw));
        tw = 3 * this.table.getCellPadding() + this.table.getInnerCellPadding() + 2 * ArrowButton.getPreferredWidth() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", tw, tw, tw));
        this.table.setModel(new Table2Model(columns, model -> {
            if (model.getNode().getValue() instanceof GalleyDistributionRuleComplete) {
                return new GalleyDistributionView(model);
            }
            if (model.getNode().getValue() instanceof EquipmentDistributionRuleComplete) {
                return new EquipmentDistributionView(model);
            }
            return null;
        }));
        this.setProgress(1.0f);
        this.table.getModel().allInitiated();
        this.table.updateOrder();
        this.setLayout(new Layout());
        this.add(this.table);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
        this.comparator = null;
    }

    public void setNode(Node<DeliverableComplete> node) {
        if (node == null) {
            this.table.resetTable();
            this.setEnabled(false);
        } else {
            this.table.getModel().setNode("galleyDistributionRules", false, node.getChildNamed(new String[]{"deliveryInstruction"}));
            this.setEnabled(true);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
    }

    @Override
    public void layoutPanel(int w, int h, boolean resize) {
    }

    @Override
    public void movePanel(int x, int y, boolean smooth) {
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.getInstance(3, this.theProgress));
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.useCliping) {
            Shape r = this.getClipingArea();
            g2.clip(r);
        }
        this.paintChildren(g2);
    }

    private void deleteEquipmentDistributionRule(Node<EquipmentDistributionRuleComplete> node) {
        Node parent = node.getParent();
        parent.removeChild(node, 0L);
        if (parent.getChildCount() == 0) {
            Node galleyParent = parent.getParent();
            galleyParent.getParent().removeChild(galleyParent, 0L);
            if (galleyParent.getParent().getChildCount() == 0) {
                Node parentX = galleyParent.getParent().getParent();
                parentX.getParent().getParent().removeChild(parentX, 0L);
            } else {
                galleyParent.getParent().commitThis();
                this.table.getModel().setNode(this.table.getModel().getNode());
            }
        } else {
            parent.commitThis();
            this.table.getModel().setNode(this.table.getModel().getNode());
        }
    }

    private void deleteGalleyDistributionRule(Node<GalleyDistributionRuleComplete> node) {
        Node parent = node.getParent();
        parent.removeChild(node, 0L);
        if (parent.getChildCount() == 0) {
            Node parentX = parent.getParent();
            parentX.getParent().getParent().removeChild(parentX, 0L);
        } else {
            parent.commitThis();
            this.table.getModel().setNode(this.table.getModel().getNode());
        }
    }

    public void resetTable() {
        this.setNode(null);
    }

    private class EquipmentDistributionView
    extends SortableTable2RowPanel
    implements NodeListener,
    ButtonListener,
    InnerPopUpListener2 {
        private static final long serialVersionUID = 1L;
        private Node node;
        private Node equipmentNode;
        private TextLabel position;
        private TextLabel amount;
        private Node insertDistributionRule;
        private TableIndentArrow indentArrow;
        private CheckBox isSPML;
        private ConfigButton configSPMLStrat;
        private CheckBox isAlaCarte;
        private boolean isMeal;
        private boolean usesSPML;
        private boolean usesAlaCarte;
        private GalleyDistributionView injectedParent;
        private boolean isInit;

        public EquipmentDistributionView(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.FOUR);
            this.setSortAttributeName(EquipmentDistributionRuleComplete_.sequenceNumber);
            this.setStartEndOffset(0, 1);
            this.isInit = true;
            this.setLayout(new EquipmentRowLayout());
            this.node = m.getNode();
            try {
                Node deliverable = m.getNode().getParent().getParent().getParent().getParent().getParent();
                if (deliverable.getValue() instanceof ProductDeliverableComplete) {
                    this.isMeal = false;
                    this.usesSPML = false;
                    this.usesAlaCarte = false;
                } else if (deliverable.getValue() instanceof ArticleDeliverableLight) {
                    this.isMeal = false;
                    this.usesSPML = false;
                    this.usesAlaCarte = false;
                } else if (deliverable.getValue() instanceof ArticleDeliverableComplete) {
                    this.isMeal = false;
                    this.usesSPML = false;
                    this.usesAlaCarte = false;
                } else if (deliverable.getValue() instanceof ServiceDeliverableComplete) {
                    this.isMeal = true;
                    ServiceDeliverableComplete sd = (ServiceDeliverableComplete)deliverable.getValue();
                    this.usesAlaCarte = sd.getLoadingGroup().getDeliverAlaCarte();
                    this.usesSPML = sd.getLoadingGroup().getDeliverSpml();
                }
            }
            catch (Exception e) {
                this.isMeal = false;
                this.usesSPML = false;
                this.usesAlaCarte = false;
            }
            if (this.node.getChildNamed(EquipmentDistributionRuleComplete_.spmlSequenceNumber).getValue() == null) {
                this.node.getChildNamed(EquipmentDistributionRuleComplete_.spmlSequenceNumber).setValue((Object)1, 0L);
            }
            if (this.isMeal) {
                this.isSPML = new CheckBox((Node<Boolean>)this.node.getChildNamed(EquipmentDistributionRuleComplete_.isSPMLEquipment));
                this.isSPML.addButtonListener(this);
                this.isAlaCarte = new CheckBox((Node<Boolean>)this.node.getChildNamed(EquipmentDistributionRuleComplete_.isAlaCarteEquipment));
                this.configSPMLStrat = new ConfigButton();
                this.configSPMLStrat.addButtonListener(this);
            }
            this.insertDistributionRule = this.node.getChildNamed(EquipmentDistributionRuleComplete_.insertDistributionRule);
            this.insertDistributionRule.addNodeListener((NodeListener)this);
            this.equipmentNode = this.node.getChildNamed(EquipmentDistributionRuleComplete_.galleyEquipment);
            String text = ((GalleyEquipmentComplete)this.equipmentNode.getValue()).getPositionCode();
            if (((GalleyEquipmentComplete)this.equipmentNode.getValue()).getEquipmentSetType() == GalleyEquipmentSetTypeE.HOLD) {
                text = text + " (" + Words.HOLD.toUpperCase() + ")";
            }
            this.position = new TextLabel(text);
            this.position.setProgress(1.0f);
            this.add(this.position);
            this.indentArrow = new TableIndentArrow();
            this.indentArrow.setProgress(1.0f);
            this.amount = new TextLabel(this.model.getNode().getChildNamed(EquipmentDistributionRuleComplete_.insertDistributionRule), ConverterRegistry.getConverter(ProductDistributionAmountConverter.class));
            this.amount.setProgress(1.0f);
            this.isInit = false;
            this.ensureAmount();
            this.ensureConfigState();
            this.add(this.indentArrow);
            this.add(this.amount);
            if (this.isSPML != null) {
                this.add(this.isSPML);
                this.add(this.isAlaCarte);
                this.add(this.configSPMLStrat);
            }
        }

        private void ensureConfigState() {
            if (this.configSPMLStrat != null) {
                this.configSPMLStrat.setEnabled(this.isSPML.isChecked());
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                ProductDistributionView.this.deleteEquipmentDistributionRule((Node<EquipmentDistributionRuleComplete>)this.model.getNode());
            } else {
                super.buttonPressed(source, x, y);
                if (source == this.isSPML) {
                    this.configSPMLStrat.setEnabled(this.isSPML.isChecked());
                } else if (source == this.configSPMLStrat) {
                    InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                    popUp.setAttributes(this.configSPMLStrat, false, false, Words.CONFIG_SPML_STRATEGY);
                    popUp.setView(new SPMLStrategyPopup(this.model.getNode().getChildNamed(EquipmentDistributionRuleComplete_.spmlStowingRule)));
                    popUp.showPopUp(x, y, -1, -1, this, this.configSPMLStrat, PopupType.NORMAL);
                }
            }
        }

        @Override
        protected void moveUp() {
            int i = this.injectedParent.getChildren().indexOf(this);
            if (i > this.startOffset) {
                Table2RowPanel p = this.injectedParent.getChildren().get(--i);
                Integer i1 = (Integer)this.getModel().getNode().getChildNamed(new String[]{this.attName}).getValue();
                Integer i2 = (Integer)p.getModel().getNode().getChildNamed(new String[]{this.attName}).getValue();
                p.getModel().getNode().getChildNamed(new String[]{this.attName}).setValue((Object)i1, System.currentTimeMillis());
                this.getModel().getNode().getChildNamed(new String[]{this.attName}).setValue((Object)i2, System.currentTimeMillis());
                this.model.getParentModel().getTable().updateOrder();
                this.model.getParentModel().getTable().revalidate();
            }
        }

        @Override
        protected void moveDown() {
            int i = this.injectedParent.getChildren().indexOf(this);
            if (i < this.injectedParent.getChildren().size() - this.endOffset) {
                Table2RowPanel p = this.injectedParent.getChildren().get(++i);
                Integer i1 = (Integer)this.getModel().getNode().getChildNamed(new String[]{this.attName}).getValue();
                Integer i2 = (Integer)p.getModel().getNode().getChildNamed(new String[]{this.attName}).getValue();
                p.getModel().getNode().getChildNamed(new String[]{this.attName}).setValue((Object)i1, System.currentTimeMillis());
                this.getModel().getNode().getChildNamed(new String[]{this.attName}).setValue((Object)i2, System.currentTimeMillis());
                this.model.getParentModel().getTable().updateOrder();
                this.model.getParentModel().getTable().relayoutRequested();
            }
        }

        protected void injectParent(GalleyDistributionView gc) {
            this.injectedParent = gc;
        }

        private void ensureAmount() {
            if (this.isInit) {
                return;
            }
            this.amount.updateString();
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public void updateRowOrder() {
            if (this.attName == null) {
                return;
            }
            int i = (Integer)this.getModel().getNode().getChildNamed(new String[]{this.attName}).getValue();
            if (i == this.startOffset) {
                this.upButton.setEnabled(false);
            } else {
                this.upButton.setEnabled(true);
            }
            if (i == this.injectedParent.getChildren().size() - this.endOffset) {
                this.downButton.setEnabled(false);
            } else {
                this.downButton.setEnabled(true);
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            if (this.isSPML != null) {
                this.isSPML.setEnabled(isEnabled && this.usesSPML);
                this.configSPMLStrat.setEnabled(this.isSPML.isEnabled());
            }
            if (this.isAlaCarte != null) {
                this.isAlaCarte.setEnabled(isEnabled && this.usesAlaCarte);
            }
            this.position.setEnabled(isEnabled);
            this.amount.setEnabled(isEnabled);
            this.indentArrow.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            if (this.model == null) {
                return;
            }
            this.model.getNode().getChildNamed(EquipmentDistributionRuleComplete_.sequenceNumber).removeNodeListener((NodeListener)this);
            this.model.getNode().removeNodeListener((NodeListener)this);
            super.kill();
            if (this.insertDistributionRule != null) {
                this.insertDistributionRule.removeNodeListener((NodeListener)this);
            }
            if (this.node != null) {
                this.node.removeNodeListener((NodeListener)this);
            }
            this.node = null;
            if (this.equipmentNode != null) {
                this.equipmentNode.removeNodeListener((NodeListener)this);
            }
            this.equipmentNode = null;
            if (this.insertDistributionRule != null) {
                this.insertDistributionRule.removeNodeListener((NodeListener)this);
            }
            this.insertDistributionRule = null;
            if (this.isSPML != null) {
                this.isSPML.kill();
            }
            if (this.configSPMLStrat != null) {
                this.configSPMLStrat.kill();
            }
            if (this.isAlaCarte != null) {
                this.isAlaCarte.kill();
            }
            this.isSPML = null;
            this.configSPMLStrat = null;
            this.isAlaCarte = null;
            if (this.position != null) {
                this.position.kill();
            }
            if (this.amount != null) {
                this.amount.kill();
            }
            if (this.indentArrow != null) {
                this.indentArrow.kill();
            }
            this.position = null;
            this.amount = null;
            this.indentArrow = null;
        }

        public void childAdded(Node<?> source, Node<?> child) {
            if (source == this.insertDistributionRule) {
                this.ensureAmount();
            }
        }

        public void childRemoved(Node<?> source, Node<?> child) {
            if (source == this.insertDistributionRule) {
                this.ensureAmount();
            }
        }

        public void valueChanged(Node<?> node) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
            if (this.configSPMLStrat != null) {
                this.configSPMLStrat.ensureState();
            }
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class EquipmentRowLayout
        extends DefaultLayout {
            private EquipmentRowLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = EquipmentDistributionView.this.model.getParentModel().getColumnWidth(0);
                int inset = EquipmentDistributionView.this.model.getParentModel().getTable().getCellPadding();
                int currentX = 0;
                if (EquipmentDistributionView.this.indentArrow != null) {
                    EquipmentDistributionView.this.indentArrow.setLocation(currentX + w / 2, 2);
                    EquipmentDistributionView.this.indentArrow.setSize(w / 2 - inset, (int)((double)(parent.getHeight() / 2) + EquipmentDistributionView.this.indentArrow.getPreferredSize().getHeight() / 2.0) - 1);
                }
                currentX += w;
                w = EquipmentDistributionView.this.model.getParentModel().getColumnWidth(1);
                if (EquipmentDistributionView.this.position != null) {
                    EquipmentDistributionView.this.position.setLocation(currentX + inset, (int)(((double)parent.getHeight() - EquipmentDistributionView.this.position.getPreferredSize().getHeight()) / 2.0));
                    EquipmentDistributionView.this.position.setSize(w - 2 * inset, (int)EquipmentDistributionView.this.position.getPreferredSize().getHeight());
                }
                currentX += w;
                w = EquipmentDistributionView.this.model.getParentModel().getColumnWidth(2);
                if (EquipmentDistributionView.this.amount != null) {
                    EquipmentDistributionView.this.amount.setLocation(currentX + inset, (int)(((double)parent.getHeight() - EquipmentDistributionView.this.amount.getPreferredSize().getHeight()) / 2.0));
                    EquipmentDistributionView.this.amount.setSize(w - 2 * inset, (int)EquipmentDistributionView.this.amount.getPreferredSize().getHeight());
                }
                currentX += w;
                w = EquipmentDistributionView.this.model.getParentModel().getColumnWidth(3);
                if (EquipmentDistributionView.this.isSPML != null) {
                    EquipmentDistributionView.this.isSPML.setLocation(currentX + EquipmentDistributionView.this.getCellPadding(), (int)((double)parent.getHeight() - EquipmentDistributionView.this.isSPML.getPreferredSize().getHeight()) / 2);
                    EquipmentDistributionView.this.isSPML.setSize(EquipmentDistributionView.this.isSPML.getPreferredSize());
                    EquipmentDistributionView.this.configSPMLStrat.setLocation(EquipmentDistributionView.this.isSPML.getX() + EquipmentDistributionView.this.isSPML.getWidth() + EquipmentDistributionView.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - EquipmentDistributionView.this.configSPMLStrat.getPreferredSize().getHeight()) / 2.0));
                    EquipmentDistributionView.this.configSPMLStrat.setSize(EquipmentDistributionView.this.configSPMLStrat.getPreferredSize());
                }
                currentX += w;
                w = EquipmentDistributionView.this.model.getParentModel().getColumnWidth(4);
                if (EquipmentDistributionView.this.isAlaCarte != null) {
                    EquipmentDistributionView.this.isAlaCarte.setLocation(currentX + EquipmentDistributionView.this.getCellPadding(), (int)((double)parent.getHeight() - EquipmentDistributionView.this.isAlaCarte.getPreferredSize().getHeight()) / 2);
                    EquipmentDistributionView.this.isAlaCarte.setSize(EquipmentDistributionView.this.isAlaCarte.getPreferredSize());
                }
                EquipmentDistributionView.this.setControlsX(currentX += w);
                EquipmentDistributionView.this.layoutSortButtons(currentX, parent.getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(20, EquipmentDistributionView.this.getDefaultRowHeight());
            }
        }
    }

    private class GalleyDistributionView
    extends SortableTable2RowPanel
    implements NodeListener,
    ButtonListener {
        private Node node;
        private Node galleyNode;
        private Node equipmentDistributionRules;
        private ExpandIcon expandIcon;
        private TextLabel galleyName;
        private TextLabel doorwayName;
        private TextLabel amountName;
        private boolean isInit;

        public GalleyDistributionView(Table2RowModel m) {
            super(m);
            this.isInit = true;
            this.setUseControlSkin(Table2RowPanel.TableControlsType.FOUR);
            this.setLayout(new GalleyRowLayout());
            this.setLayoutInnerChildsSelf(true);
            this.setSortAttributeName(GalleyDistributionRuleComplete_.sequenceNumber);
            this.setStartEndOffset(0, 1);
            this.node = m.getNode();
            this.node.getAllChildAddEventsFor((NodeListener)this, new String[]{"equipmentDistributionRules", "galleyEquipmentSet", "percentage", "sequenceNumber"});
            this.equipmentDistributionRules = this.node.getChildNamed(new String[]{"equipmentDistributionRules"});
            this.equipmentDistributionRules.addNodeListener((NodeListener)this);
            this.equipmentDistributionRules.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            this.galleyNode = this.node.getChildNamed(new String[]{"galleyEquipmentSet"});
            this.galleyName = new TextLabel(((GalleyEquipmentSetComplete)this.galleyNode.getValue()).getGalleyCode());
            this.galleyName.setProgress(1.0f);
            this.add(this.galleyName);
            this.doorwayName = new TextLabel(((GalleyEquipmentSetComplete)this.galleyNode.getValue()).getDoorway());
            this.doorwayName.setProgress(1.0f);
            this.add(this.doorwayName);
            this.galleyName = new TextLabel(this.galleyNode.getChildNamed(new String[]{"galleyCode"}));
            this.galleyName.setProgress(1.0f);
            this.add(this.galleyName);
            this.doorwayName = new TextLabel(this.galleyNode.getChildNamed(new String[]{"doorway"}));
            this.doorwayName.setProgress(1.0f);
            this.add(this.doorwayName);
            this.node.getChildNamed(new String[]{"sequenceNumber"}).addNodeListener((NodeListener)this);
            this.expandIcon = new ExpandIcon();
            this.expandIcon.setExpanded(true);
            this.amountName = new TextLabel();
            this.expandIcon.setProgress(1.0f);
            this.expandIcon.addButtonListener(this);
            this.amountName.setProgress(1.0f);
            this.isInit = false;
            this.ensureAmount();
            this.ensurePercentage();
            this.add(this.expandIcon);
            this.add(this.amountName);
        }

        private void ensurePercentage() {
        }

        private void ensureAmount() {
            if (this.isInit || this.isKilled()) {
                return;
            }
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            Node n = this.model.getNode().getChildNamed(new String[]{"equipmentDistributionRules"});
            Iterator it = n.getChilds();
            int amount = 0;
            while (it.hasNext()) {
                Node dr = (Node)it.next();
                Node idr = dr.getChildNamed(new String[]{"insertDistributionRule"});
                Iterator it2 = idr.getChilds();
                while (it2.hasNext()) {
                    Node idr2 = (Node)it2.next();
                    Node aDR = idr2.getChildNamed(new String[]{"quantity"});
                    amount += ((Integer)aDR.getValue()).intValue();
                }
            }
            Node diInst = this.model.getNode().getParent().getParent();
            if (diInst != null && diInst.getValue() instanceof DeliveryInstructionComplete) {
                Node item = diInst.getParent();
                if (item.getValue() instanceof ArticleDeliverableComplete || item.getValue() instanceof ArticleDeliverableLight) {
                    Node u = item.getChildNamed(new String[]{"unit"});
                    if (u != null && u.getValue() != null) {
                        this.amountName.setText("" + amount + " " + ((UnitComplete)u.getValue()).getShortName());
                    } else {
                        this.amountName.setText("" + amount + " " + settings.getPieceUnit().getShortName());
                    }
                } else {
                    this.amountName.setText("" + amount + " " + settings.getPieceUnit().getShortName());
                }
            } else {
                this.amountName.setText("" + amount + " " + settings.getPieceUnit().getShortName());
            }
        }

        @Override
        public void updateRowOrder() {
            super.updateRowOrder();
            Collections.sort(this.children, ProductDistributionView.this.comparator);
            for (Table2RowPanel p : this.children) {
                p.updateRowOrder();
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.expandIcon.setEnabled(isEnabled);
            this.galleyName.setEnabled(isEnabled);
            this.doorwayName.setEnabled(isEnabled);
            this.amountName.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getChildNamed(new String[]{"sequenceNumber"}).removeNodeListener((NodeListener)this);
            this.model.getNode().removeNodeListener((NodeListener)this);
            super.kill();
            if (this.equipmentDistributionRules != null) {
                this.equipmentDistributionRules.removeNodeListener((NodeListener)this);
            }
            this.equipmentDistributionRules = null;
            if (this.node != null) {
                this.node.removeNodeListener((NodeListener)this);
            }
            this.node = null;
            if (this.galleyNode != null) {
                this.galleyNode.removeNodeListener((NodeListener)this);
            }
            this.galleyNode = null;
            this.expandIcon.kill();
            this.expandIcon = null;
            this.galleyName.kill();
            this.galleyName = null;
            this.doorwayName.kill();
            this.doorwayName = null;
            this.amountName.kill();
            this.amountName = null;
        }

        public void childAdded(Node<?> source, Node<?> child) {
            if (source == this.equipmentDistributionRules) {
                Table2RowModel t = this.addRow(child);
                t.getView().setLayoutInnerChildsSelf(true);
                try {
                    this.ensureAmount();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public Table2RowModel addRow(Node<?> n) {
            Table2RowModel m = super.addRow(n);
            ((EquipmentDistributionView)m.getView()).injectParent(this);
            return m;
        }

        public void childRemoved(Node<?> source, Node<?> child) {
            if (source == this.equipmentDistributionRules) {
                try {
                    this.ensureAmount();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void valueChanged(Node<?> node) {
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                ProductDistributionView.this.deleteGalleyDistributionRule((Node<GalleyDistributionRuleComplete>)this.model.getNode());
            } else {
                super.buttonPressed(source, x, y);
                if (source == this.expandIcon) {
                    this.isExpanded = !this.isExpanded;
                    for (Table2RowPanel p : this.children) {
                        p.setVisible(this.isExpanded);
                    }
                    this.model.getParentModel().getTable().relayoutRequested();
                }
            }
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class GalleyRowLayout
        extends DefaultLayout {
            private GalleyRowLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = GalleyDistributionView.this.model.getParentModel().getColumnWidth(0);
                int inset = GalleyDistributionView.this.model.getParentModel().getTable().getCellPadding();
                int currentX = 0;
                if (GalleyDistributionView.this.expandIcon != null) {
                    GalleyDistributionView.this.expandIcon.setLocation(currentX + inset, (int)(((double)parent.getHeight() - GalleyDistributionView.this.expandIcon.getPreferredSize().getHeight()) / 2.0));
                    GalleyDistributionView.this.expandIcon.setSize(GalleyDistributionView.this.expandIcon.getPreferredSize());
                    currentX += inset + GalleyDistributionView.this.expandIcon.getWidth() + inset;
                }
                if (GalleyDistributionView.this.galleyName != null) {
                    GalleyDistributionView.this.galleyName.setLocation(currentX, (int)(((double)parent.getHeight() - GalleyDistributionView.this.galleyName.getPreferredSize().getHeight()) / 2.0));
                    GalleyDistributionView.this.galleyName.setSize(w - (currentX + inset), (int)GalleyDistributionView.this.galleyName.getPreferredSize().getHeight());
                    currentX += GalleyDistributionView.this.galleyName.getWidth() + inset;
                }
                w = GalleyDistributionView.this.model.getParentModel().getColumnWidth(1);
                if (GalleyDistributionView.this.doorwayName != null) {
                    GalleyDistributionView.this.doorwayName.setLocation(currentX + inset, (int)(((double)parent.getHeight() - GalleyDistributionView.this.doorwayName.getPreferredSize().getHeight()) / 2.0));
                    GalleyDistributionView.this.doorwayName.setSize(w - 2 * inset, (int)GalleyDistributionView.this.doorwayName.getPreferredSize().getHeight());
                }
                currentX += w;
                w = GalleyDistributionView.this.model.getParentModel().getColumnWidth(2);
                if (GalleyDistributionView.this.amountName != null) {
                    GalleyDistributionView.this.amountName.setLocation(currentX + inset, (int)(((double)parent.getHeight() - GalleyDistributionView.this.amountName.getPreferredSize().getHeight()) / 2.0));
                    GalleyDistributionView.this.amountName.setSize(w - 2 * inset, (int)GalleyDistributionView.this.amountName.getPreferredSize().getHeight());
                }
                currentX += w;
                w = GalleyDistributionView.this.model.getParentModel().getColumnWidth(3);
                currentX += w;
                w = GalleyDistributionView.this.model.getParentModel().getColumnWidth(4);
                GalleyDistributionView.this.setControlsX(currentX += w);
                GalleyDistributionView.this.layoutSortButtons(currentX, parent.getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(20, GalleyDistributionView.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ProductDistributionView.this.layoutTitle(parent);
            ProductDistributionView.this.table.setLocation(1, ProductDistributionView.this.getTitleHeight());
            ProductDistributionView.this.table.setSize(parent.getWidth() - 2, parent.getHeight() - (ProductDistributionView.this.table.getY() + 1));
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, ProductDistributionView.this.getTitleHeight());
        }
    }
}

