/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.logic;

import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.GalleyComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.StowagePositionComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.StowagePositionSpecificationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Dimension3dComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class Toolkit {
    public static boolean isDimensionEquals(Dimension3dComplete dim1, Dimension3dComplete dim2) {
        if (dim1 != null && dim2 != null) {
            Double oH = dim1.getHeight();
            Double oW = dim1.getWidth();
            Double oD = dim1.getDepth();
            Double tH = dim2.getHeight();
            Double tW = dim2.getWidth();
            Double tD = dim2.getDepth();
            if (oH.equals(tH) && oW.equals(tW) && oD.equals(tD)) {
                return true;
            }
        }
        return false;
    }

    public static List<ScreenValidationObject> isAircraftValid(AircraftComplete c) {
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        String coCode = s.getLooseEquipmentType().getCode();
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        for (GalleyComplete gc : c.getGalleys()) {
            Hashtable<String, StowagePositionComplete> registry = new Hashtable<String, StowagePositionComplete>();
            for (StowagePositionSpecificationComplete spec : gc.getStowagePositionSpecifications()) {
                String msg;
                for (StowagePositionComplete a : spec.getAlternativePositions()) {
                    if (registry.get(a.getCode()) != null) {
                        msg = "Galley " + gc.getCode() + " alternativ " + a.getCode();
                        rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, msg));
                        continue;
                    }
                    if (a.getCode().equals(coCode)) {
                        msg = "Stowage Position Code '" + coCode + "' is a reserved name for default Compartments, please choose another name";
                        rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, msg));
                        continue;
                    }
                    registry.put(a.getCode(), a);
                }
                for (StowagePositionComplete a : spec.getDefaultPositions()) {
                    if (registry.get(a.getCode()) != null) {
                        msg = "Galley " + gc.getCode() + " default " + a.getCode();
                        rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, msg));
                        continue;
                    }
                    if (a.getCode().equals(coCode)) {
                        msg = "Stowage Position Code '" + coCode + "' is a reserved name for 'default Compartment', please choose another name";
                        rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, msg));
                        continue;
                    }
                    registry.put(a.getCode(), a);
                }
            }
        }
        return rets;
    }
}

