/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.gui.hud.ConnectionToOutside;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.RowPanel;
import ch.icit.pegasus.client.gui.table.RowSelectionListener;
import ch.icit.pegasus.client.gui.table.TableModel;
import ch.icit.pegasus.client.gui.table.utils.NodeChildIndexComparator;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.animators.AnimationContainer;
import ch.icit.pegasus.client.gui.utils.animators.AnimationListener;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.BackgroundedContainer;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.LoadingStateComponent;
import ch.icit.pegasus.server.core.general.IUniversal;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class Table<T extends IUniversal, E extends Enum<E>>
extends BackgroundedContainer
implements AttributeListener,
AnimationContainer,
LoadingStateComponent,
VisibleContainer {
    private static final long serialVersionUID = 1L;
    private ScrollPane scrollPane;
    private TableModel<T, E> model;
    private JPanel viewPort;
    private ArrayList<RowPanel<T>> rows = new ArrayList();
    private TableLafListener lafListener;
    private RowPanel headerRow;
    private RowPanel hiddenHeaderRowEditor;
    private RowPanel addRow;
    private RowPanel hiddenAddRowEditor;
    private int tableVerticalGap = 5;
    private int tableHorizontal_row_border;
    private boolean isEnabled = true;
    private int headerRowHeight;
    private Comparator<RowPanel> currentComparator;
    private boolean overrideComparator;
    private SmartIconConfiguration possibleSmartIcons = SmartIconConfiguration.NONE;
    private boolean isReady;
    private LoadingAnimation animater;
    private boolean isLoadingData = false;
    private boolean isHeaderRowInUse = true;
    private ConnectionToOutside outsideReference;
    private boolean stopItAnyway;
    private AWTEventListener listener;

    public Table(ConnectionToOutside con) {
        this.outsideReference = con;
        this.installTable();
    }

    public ConnectionToOutside getOutSideConnection() {
        return this.outsideReference;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setReady(boolean isReady) {
        this.isReady = isReady;
    }

    public void setSortedRow(Enum<?> e, boolean isAsc) {
        if (this.headerRow != null) {
            this.headerRow.setTableSortAttribute(e, isAsc);
        }
    }

    public void setDisableAddRow(boolean disableAddRow) {
        this.addRow.kill();
        this.addRow = null;
        this.model.removeAddRow();
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    protected void tryToMoveUp() {
        if (this.model != null && this.model.getSelectedRow() != null && this.model.getSelectedRow().getView() != null && this.model.getSelectedRow().getView().hasFocus() && !this.model.getSelectedRow().getView().isExpanded()) {
            int i = this.model.getViewableRows().indexOf(this.model.getSelectedRow().getView());
            while (i > 0) {
                RowPanel<T> nSelection = this.model.getViewableRows().get(--i);
                if (nSelection.isDisabled()) continue;
                this.model.setSelectedModel(nSelection.getModel(), false);
                return;
            }
        }
    }

    protected void tryToMoveDown() {
        if (this.model != null && this.model.getSelectedRow() != null && this.model.getSelectedRow().getView() != null && this.model.getSelectedRow().getView().hasFocus() && !this.model.getSelectedRow().getView().isExpanded()) {
            int i = this.model.getViewableRows().indexOf(this.model.getSelectedRow().getView());
            while (i < this.model.getViewableRows().size() - 1) {
                RowPanel<T> nSelection = this.model.getViewableRows().get(++i);
                if (nSelection.isDisabled()) continue;
                this.model.setSelectedModel(nSelection.getModel(), false);
                return;
            }
        }
    }

    protected void tryToExpand() {
        if (this.model.getSelectedRow() != null && this.model.getSelectedRow().getView() != null && this.model.getSelectedRow().getView().hasFocus() && !this.model.getSelectedRow().getView().isExpanded() && this.model.getSelectedRow().isExpandable()) {
            this.model.getSelectedRow().expandRow(true);
            this.model.getSelectedRow().toggleExpandButton(true);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        for (RowPanel<T> row : this.rows) {
            row.getModel().kill();
        }
        this.derestigerKeyEvents();
        for (RowPanel<T> p : this.rows) {
            p.kill();
        }
        this.rows.clear();
        this.rows = null;
        JPanelKillable.removeAllComponentListeners(this.viewPort);
        this.scrollPane.kill();
        this.scrollPane = null;
        this.listenerList.getListenerList();
        this.viewPort = null;
        this.lafListener = null;
        this.headerRow.kill();
        this.headerRow = null;
        if (this.addRow != null) {
            this.addRow.kill();
        }
        this.addRow = null;
        if (this.animater != null) {
            this.animater.kill();
        }
        this.animater = null;
        this.model.kill();
        this.model = null;
        if (this.hiddenHeaderRowEditor != null) {
            this.hiddenHeaderRowEditor.kill();
        }
        this.hiddenHeaderRowEditor = null;
        if (this.hiddenAddRowEditor != null) {
            this.hiddenAddRowEditor.kill();
        }
        this.hiddenAddRowEditor = null;
        this.currentComparator = null;
        this.possibleSmartIcons = null;
        this.outsideReference = null;
        this.listener = null;
    }

    public LoadingAnimation setLoadingAnimationText(String t) {
        if (this.ensureAnimator(t)) {
            this.add((Component)this.animater, 0);
            this.animater.fadeIn();
            this.animater.start();
        }
        this.animater.stateChanged(t);
        return this.animater;
    }

    public void hideAnimation() {
        if (this.animater != null) {
            this.animater.kill();
            this.animater = null;
        }
    }

    public void setCurrentComparator(Comparator<RowPanel> comp) {
        if (comp != null) {
            this.currentComparator = comp;
            this.overrideComparator = true;
        } else {
            this.currentComparator = null;
            this.overrideComparator = false;
        }
        this.layoutRows();
    }

    public void setPossibleSmartIcons(SmartIconConfiguration smart) {
        this.possibleSmartIcons = smart;
    }

    public SmartIconConfiguration getPossibleSmartIcons() {
        return this.possibleSmartIcons;
    }

    public void configureSmartScreenButtonOnRows() {
        for (RowPanel<T> panel : this.rows) {
            panel.configureSmartButtons();
        }
    }

    public int getHeaderRowHeight() {
        return this.headerRowHeight;
    }

    public RowPanel getRow4Node(Node node) {
        for (RowPanel<T> r : this.rows) {
            if (r.getModel().getNode() != node) continue;
            return r;
        }
        return null;
    }

    private void installTable() {
        this.scrollPane = new ScrollPane();
        this.scrollPane.getVerticalScrollBar().setFocusable(false);
        this.scrollPane.getVerticalScrollBar().addMouseListener(this);
        this.scrollPane.getHorizontalScrollBar().setFocusable(true);
        this.scrollPane.getHorizontalScrollBar().addMouseListener(this);
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                Table.this.model.horizontalScrollValueChanged();
            }
        });
        this.viewPort = new JPanel(){

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(Table.this.viewPort.getBackground());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.paintChildren(g2);
            }
        };
        this.viewPort.setLayout(null);
        this.viewPort.setFocusable(true);
        this.viewPort.addMouseListener(this);
        this.setProgress(1.0f);
        this.lafListener = new TableLafListener();
        this.lafListener.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        this.scrollPane.setViewportView(this.viewPort);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setVisible(true);
        this.viewPort.setVisible(true);
        this.setLayout(null);
        this.registerKeyEvents();
        this.add(this.scrollPane);
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public void activateDataLoadingAnimation(String t, Integer a, Integer b) {
        if (!this.isLoadingData) {
            this.isLoadingData = true;
            if (this.addRow != null) {
                this.addRow.setDisabled(true);
            }
            if (this.ensureAnimator("")) {
                this.add((Component)this.animater, 0);
            }
            this.animater.fadeIn();
            if (t != null) {
                String t1 = t;
                if (a != null && b != null) {
                    t1 = t1 + " " + a + "/" + b;
                }
                this.animater.stateChanged(t1);
            } else {
                this.animater.stateChanged("");
            }
            this.animater.setProgress(1.0f);
            this.animater.start();
            this.invalidate();
            this.validate();
        }
    }

    private boolean ensureAnimator(String text) {
        if (this.animater == null) {
            this.animater = new LoadingAnimation();
            this.animater.getFader().setAnimationContainer(this);
            this.animater.stateChanged(text);
            this.animater.setMetaParent(this);
            return true;
        }
        return false;
    }

    public void setLoadingData(boolean isLoadingData) {
        this.isLoadingData = isLoadingData;
    }

    public void setStopItAnyWay() {
        this.stopItAnyway = true;
    }

    @Override
    public void deactivateDataLoadingAnimation() {
    }

    public boolean allDownloaded() {
        boolean wasOK = true;
        if (this.isLoadingData) {
            if (this.animater != null || this.stopItAnyway) {
                if (this.animater != null) {
                    this.animater.fadeOut(true);
                }
                this.animater = null;
            } else {
                wasOK = false;
            }
        } else {
            wasOK = false;
        }
        if (this.addRow != null) {
            this.addRow.setDisabled(false);
        }
        return wasOK;
    }

    public LoadingAnimation getLoadingAnimation() {
        return this.animater;
    }

    public boolean isAbleToStopAnimation() {
        if (this.animater != null) {
            return this.animater.isAbleToStop();
        }
        return true;
    }

    public TableModel<T, E> getModel() {
        return this.model;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        if (this.addRow != null) {
            this.addRow.setEnabled(isEnabled);
        }
        if (this.hiddenAddRowEditor != null) {
            this.hiddenAddRowEditor.setEnabled(isEnabled);
        }
        if (this.hiddenHeaderRowEditor != null) {
            this.hiddenHeaderRowEditor.setEnabled(isEnabled);
        }
        if (this.headerRow != null) {
            this.headerRow.setEnabled(isEnabled);
        }
        for (RowPanel<T> p : this.rows) {
            p.setEnabled(isEnabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!(e.getSource() instanceof JScrollBar)) {
            super.mousePressed(e);
        }
        this.model.setSelectedModel(null, false);
    }

    public void setModel(TableModel model) {
        this.model = model;
    }

    public void setAddRow(RowPanel addRow, RowPanel hiddenEditor) {
        if (this.addRow != null && this.addRow != addRow) {
            this.remove(this.addRow);
        }
        this.addRow = addRow;
        this.hiddenAddRowEditor = hiddenEditor;
        if (hiddenEditor != null) {
            this.viewPort.add(hiddenEditor);
        }
        this.addRow.setEnabled(this.isEnabled());
        this.add(this.addRow);
        this.addRow.fadeIn();
    }

    public RowPanel getAddRow() {
        return this.addRow;
    }

    public RowPanel getHeaderRow() {
        return this.headerRow;
    }

    public void setHeaderRow(RowPanel headerRow, RowPanel hiddenEditor) {
        if (this.headerRow != null && this.headerRow != headerRow) {
            this.remove(this.headerRow);
        }
        this.headerRow = headerRow;
        this.hiddenHeaderRowEditor = hiddenEditor;
        this.headerRow.setProgress(1.0f);
        if (this.hiddenHeaderRowEditor != null) {
            this.viewPort.add(this.hiddenHeaderRowEditor);
        }
        this.add(this.headerRow);
    }

    @Override
    public void setSize(int w, int h) {
        if (this.addRow != null) {
            this.addRow.setLocation(0, 0);
        }
        super.setSize(w, h);
        this.model.ensureColumnWidths(-1, -1, false, true);
        this.layoutRows();
    }

    protected int getViewPortHeight() {
        return this.scrollPane.getHeight();
    }

    protected int getViewPortY() {
        return (int)this.scrollPane.getVisibleRect().getY();
    }

    protected JScrollBar getScrollBar(int orientation) {
        switch (orientation) {
            case 1: {
                return this.scrollPane.getVerticalScrollBar();
            }
            case 0: {
                return this.scrollPane.getHorizontalScrollBar();
            }
        }
        return null;
    }

    protected void layoutRows() {
        int viewSpace;
        if (this.model == null) {
            return;
        }
        int currentY = 0;
        int currentWidth = this.model.getColumnWidth(-1);
        if (currentWidth != (viewSpace = this.getViewableWidth(false))) {
            this.model.ensureColumnWidths(-1, 0, false, false);
            currentWidth = viewSpace;
        }
        if (this.animater != null) {
            this.animater.setSize(this.animater.getPreferredSize());
            this.animater.setLocation((this.getWidth() - this.animater.getWidth()) / 2, (this.getHeight() - this.animater.getHeight()) / 2);
        }
        if (this.addRow != null) {
            this.addRow.setSize(this.getWidth(), this.addRow.getPreferredHeight());
            this.headerRow.setLocation(this.skin.getImage11(Button.ButtonState.UP).getWidth() - 2, this.addRow.getY() + this.addRow.getHeight());
            this.headerRow.setSize(currentWidth + 20, this.headerRow.getPreferredHeight());
        } else {
            this.headerRow.setLocation(this.skin.getImage11(Button.ButtonState.UP).getWidth() - 2, this.skin.getImage21(Button.ButtonState.UP).getHeight() - 2);
            this.headerRow.setSize(currentWidth + 20, this.headerRow.getPreferredHeight());
        }
        if (this.hiddenAddRowEditor != null) {
            this.hiddenAddRowEditor.setLocation(this.tableHorizontal_row_border, currentY);
            this.hiddenAddRowEditor.setSize(currentWidth, this.hiddenAddRowEditor.getPreferredHeight());
            if (this.hiddenAddRowEditor.isAnimating() || this.hiddenAddRowEditor.isExpanded()) {
                currentY += this.hiddenAddRowEditor.getHeight();
                currentY += this.tableVerticalGap;
            }
        }
        if (this.hiddenHeaderRowEditor != null) {
            this.hiddenHeaderRowEditor.setLocation(0, currentY);
            this.hiddenHeaderRowEditor.setSize(this.scrollPane.getWidth(), this.hiddenHeaderRowEditor.getPreferredHeight());
            if (this.hiddenAddRowEditor != null && (this.hiddenAddRowEditor.isAnimating() || this.hiddenAddRowEditor.isExpanded())) {
                currentY += this.hiddenHeaderRowEditor.getHeight();
            }
        }
        currentY += this.tableVerticalGap;
        if (this.overrideComparator) {
            if (this.currentComparator != null) {
                // empty if block
            }
        } else if (this.currentComparator == null) {
            this.currentComparator = ComparatorRegistry.getComparator(NodeChildIndexComparator.class);
        }
        Collections.sort(this.model.getViewableRows(), this.currentComparator);
        HashMap<Integer, Object> positionIndex = new HashMap<Integer, Object>();
        for (RowPanel<T> row : this.model.getViewableRows()) {
            if (!row.isRemoved()) continue;
            positionIndex.put(row.getRemoveIndex(), row);
        }
        int count = 0;
        for (final RowPanel rowPanel : this.model.getViewableRows()) {
            while (positionIndex.get(count) != null) {
                RowPanel nr = (RowPanel)positionIndex.get(count);
                nr.setSize(currentWidth, nr.getPreferredHeight());
                currentY += nr.getHeight();
                currentY += this.tableVerticalGap;
                ++count;
            }
            if (rowPanel.isRemoved()) continue;
            if (!rowPanel.isHasPosition()) {
                rowPanel.getMover().addAnimationListener(new AnimationListener(){

                    @Override
                    public void animationFinished(boolean wasFadin) {
                        rowPanel.setInMovement(false);
                        Table.this.layoutRows();
                    }
                });
                rowPanel.setInMovement(true);
                rowPanel.setLocationSmooth(-1 * currentWidth, currentY, this.tableHorizontal_row_border, currentY);
                rowPanel.setHasPosition(true);
            } else if (!rowPanel.isInMovement()) {
                rowPanel.setLocationSmooth(this.tableHorizontal_row_border, currentY);
            }
            rowPanel.setSize(currentWidth, rowPanel.getPreferredHeight());
            currentY += rowPanel.getHeight();
            currentY += this.tableVerticalGap;
            ++count;
        }
        this.viewPort.setPreferredSize(new Dimension(currentWidth + 2 * this.tableHorizontal_row_border, currentY));
        this.viewPort.revalidate();
        this.scrollPane.revalidate();
        int scrollY = 0;
        scrollY = this.isHeaderRowInUse ? this.headerRow.getY() + this.headerRow.getHeight() : this.addRow.getY() + this.addRow.getHeight();
        this.scrollPane.setLocation(this.skin.getImage12(Button.ButtonState.UP).getWidth() - 2, scrollY);
        this.scrollPane.setSize(this.getWidth() - 2 * (this.skin.getImage11(Button.ButtonState.UP).getWidth() - 2), this.getHeight() - (this.scrollPane.getY() + this.skin.getImage23(Button.ButtonState.UP).getHeight() - 2));
        if (this.isLoadingData && this.getParent() != null) {
            this.getParent().repaint(32L);
        }
    }

    protected void sortTable(Enum<?> att, boolean isAsc) {
        if (this.outsideReference != null) {
            this.outsideReference.sortColumn(att, isAsc);
        }
    }

    public void requestRelayout() {
        this.callBack4Layout();
    }

    protected void callBack4Layout() {
        this.layoutRows();
    }

    public void addRow(int dy, RowPanel aPanel, boolean fadin) {
        if (this.rows == null) {
            return;
        }
        aPanel.setProgress(0.0f);
        if (this.rows.size() >= dy && this.rows.size() > 0) {
            this.rows.add(dy, aPanel);
        } else {
            this.rows.add(aPanel);
        }
        if (this.model.isARowExpanded()) {
            aPanel.setDisabled(true);
        }
        this.viewPort.add(aPanel);
        if (fadin) {
            this.layoutRows();
            switch (MainFrame.usedState) {
                case FADIN: {
                    aPanel.getFader().setMetaParent(this);
                    aPanel.setProgress(0.0f);
                    aPanel.fadeIn();
                    break;
                }
                case MOVEIN: {
                    aPanel.setHasPosition(false);
                    aPanel.setProgress(0.0f);
                    aPanel.getFader().setMetaParent(this);
                    aPanel.getFader().fadeIn();
                    break;
                }
            }
        } else {
            switch (MainFrame.usedState) {
                case FADIN: {
                    aPanel.getFader().setMetaParent(this);
                    aPanel.setProgress(0.0f);
                    aPanel.fadeIn();
                    break;
                }
                case MOVEIN: {
                    aPanel.getFader().setMetaParent(this);
                    aPanel.setProgress(0.0f);
                    aPanel.fadeIn();
                    break;
                }
            }
        }
    }

    public void addRow(int dy, RowPanel aPanel) {
        this.addRow(dy, aPanel, true);
    }

    protected int getViewableOffsetWidth() {
        if (this.scrollPane.getVerticalScrollBar().isVisible()) {
            return (int)this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth();
        }
        return 0;
    }

    protected void updateViewableRows(List<RowPanel<T>> viewableRows) {
        for (RowPanel<T> row : this.rows) {
            if (!viewableRows.contains(row)) {
                this.viewPort.remove(row);
                continue;
            }
            Component[] allComps = this.viewPort.getComponents();
            boolean isIn = false;
            for (int i = 0; i < allComps.length; ++i) {
                if (allComps[i] != row) continue;
                isIn = true;
                i = allComps.length;
            }
            if (isIn) continue;
            this.viewPort.add(row);
        }
        this.layoutRows();
    }

    protected void registerKeyEvents() {
        this.listener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (((KeyEvent)event).getID() == 401) {
                    if (((KeyEvent)event).getKeyCode() == 38) {
                        Table.this.tryToMoveUp();
                    } else if (((KeyEvent)event).getKeyCode() == 40) {
                        Table.this.tryToMoveDown();
                    } else if (((KeyEvent)event).getKeyCode() == 10) {
                        Table.this.tryToExpand();
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 8L);
    }

    protected void derestigerKeyEvents() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.listener);
    }

    protected ArrayList<RowPanel<T>> getRowsThreadSafe() {
        return (ArrayList)this.rows.clone();
    }

    protected ArrayList<RowPanel<T>> getRows() {
        return this.rows;
    }

    protected int getViewableWidth(boolean isHeader) {
        if (isHeader) {
            return this.scrollPane.getWidth();
        }
        if (this.scrollPane != null) {
            int vH;
            int aWidth = this.scrollPane.getWidth();
            if (Math.abs(this.getWidth() - aWidth) > 5) {
                aWidth = this.getWidth() - 4;
            }
            aWidth -= 2 * this.tableHorizontal_row_border;
            int preSize = (int)((double)this.preCalcViewPortHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().getHeight());
            if (preSize > (vH = this.scrollPane.getHeight())) {
                aWidth = (int)((double)aWidth - this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            }
            return aWidth;
        }
        return 0;
    }

    public int getHorizontalRowBorder() {
        return this.tableHorizontal_row_border;
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.tableHorizontal_row_border = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_horizontal_row_border"));
            this.tableVerticalGap = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_vertical_row_border"));
            this.headerRowHeight = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_header_rowheight"));
            this.layoutRows();
        }
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.scrollPane.getHorizontalScrollBar();
    }

    private int preCalcViewPortHeight() {
        if (this.model == null) {
            return -1;
        }
        int currentY = 0;
        for (RowPanel<T> row : this.model.getViewableRows()) {
            currentY += row.getPreferredHeight();
            currentY += this.tableVerticalGap;
        }
        if (this.hiddenAddRowEditor != null && (this.hiddenAddRowEditor.isAnimating() || this.hiddenAddRowEditor.isExpanded())) {
            currentY += this.hiddenAddRowEditor.getHeight();
            currentY += this.tableVerticalGap;
            currentY += this.hiddenHeaderRowEditor.getHeight();
            currentY += this.tableVerticalGap;
        }
        return currentY;
    }

    public int getPreferredScrollBarWidth() {
        return (int)this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth();
    }

    public void removeRow(RowPanel view) {
        if (this.rows.contains(view)) {
            this.rows.remove(view);
            this.viewPort.remove(view);
        }
        this.model.getViewableRows().remove(view);
        if (this.model.getViewableRows().isEmpty()) {
            this.viewPort.repaint(32L);
        }
    }

    public void selectNode(Node node, boolean isSilent) {
        this.model.selectNode(node, isSilent);
    }

    public void addRowSelectionListener(RowSelectionListener l) {
        this.model.addRowSelectionListener(l);
    }

    public void removeRowSelectionListener(RowSelectionListener l) {
        this.model.removeRowSelectionListener(l);
    }

    @Override
    public void removeScheduled(Fadable comp) {
        this.model.installDataTable();
        this.model.fetchData();
    }

    public void stopAnimationImmediately() {
        this.model.stopAnimationImmediately();
    }

    public RowModel getExpandedRow() {
        RowModel<T> sModel;
        if (this.model != null && (sModel = this.model.getSelectedRow()) != null && sModel.getView() != null && sModel.getView().isExpanded()) {
            return sModel;
        }
        return null;
    }

    protected void switchHeaders(boolean hide) {
        if (hide) {
            this.hiddenHeaderRowEditor.getModel().setPreferredBlockHeight(this.headerRowHeight);
            this.hiddenHeaderRowEditor.refreshCalculatedHeight();
            this.hiddenHeaderRowEditor.getModel().propagateColumnWidth(true);
            this.isHeaderRowInUse = false;
            this.remove(this.headerRow);
        } else {
            this.hiddenHeaderRowEditor.getModel().setPreferredBlockHeight(0);
            this.hiddenHeaderRowEditor.refreshCalculatedHeight();
            this.hiddenHeaderRowEditor.getModel().propagateColumnWidth(true);
            this.isHeaderRowInUse = true;
            this.add(this.headerRow);
        }
        this.validate();
        this.layoutRows();
    }

    @Override
    public void scrollTo(Focusable f) {
    }

    public Object[] getAttributes(RowPanel p) {
        Object[] o = new Object[1];
        if (this.outsideReference != null) {
            o[0] = this.outsideReference.getValidationAttributes(p);
        }
        return o;
    }

    private class TableLafListener
    implements LafListener {
        private TableLafListener() {
        }

        @Override
        public void lafAttributeChanged(String att) {
            if (Table.this.headerRow != null && Table.this.hiddenHeaderRowEditor != null) {
                Table.this.hiddenHeaderRowEditor.setBackground(Table.this.headerRow.getBackground());
            }
            Table.this.viewPort.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            Table.this.scrollPane.setBackground(Table.this.viewPort.getBackground());
            Table.this.scrollPane.getVerticalScrollBar().setBackground(Table.this.viewPort.getBackground());
            Table.this.scrollPane.getHorizontalScrollBar().setBackground(Table.this.viewPort.getBackground());
            Table.this.setBackground(Table.this.viewPort.getBackground());
        }
    }

    public static enum SmartIconConfiguration {
        ONE,
        TWO,
        NONE;

    }
}

