/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.CellModel;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;

public class CellViewPeriodRenderer
extends CellRenderer
implements AttributeListener,
LafListener {
    private static final long serialVersionUID = 1L;
    private CellModel model;
    private PeriodComplete period;
    private TextLabel label1;
    private static String SUMMER = "";
    private static String WINTER = "";

    public CellViewPeriodRenderer(PeriodComplete period, CellModel model, Component delegate) {
        this.model = model;
        this.period = period;
        int i = 0;
        if (model != null) {
            i = model.getParentModel().getIndex(model);
        }
        SUMMER = Words.SUMMER;
        WINTER = Words.WINTER;
        this.setOpaque(false);
        this.setLayout(null);
        String text = "";
        if (i == 3) {
            if (period != null) {
                text = CalendarUtil.isSummerPeriod((Date)period.getStartDate(), (Date)period.getEndDate()) ? SUMMER : WINTER;
                Calendar cal = TimeUtil.createCalendar();
                cal.setTimeInMillis(this.period.getStartDate().getTime());
                text = text + " " + cal.get(1);
            } else {
                text = "";
            }
            text = "IS SEASON IN CELLVIEWPERIODRENDERER";
        } else {
            DateConverter c1 = (DateConverter)ConverterRegistry.getConverter(DateConverter.class);
            text = period == null ? "-" : c1.convert((Object)period.getStartDate(), null, new Object[0]) + " - " + c1.convert((Object)period.getEndDate(), null, new Object[0]);
        }
        this.label1 = new TextLabel(text);
        this.label1.setDelegateComponent(delegate);
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        this.add(this.label1);
    }

    @Override
    public String getStringValue() {
        return this.label1.getText();
    }

    public PeriodComplete getPeriod() {
        return this.period;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.label1 != null) {
            this.label1.kill();
            this.label1 = null;
        }
    }

    @Override
    protected void layoutCell() {
        int space = this.getWidth();
        if (this.isFirstColumn) {
            this.label1.setLocation(this.firstColumnInset, 0);
        } else {
            this.label1.setLocation(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding")), 0);
        }
        this.label1.setSize(space -= 2 * this.label1.getX(), this.getHeight());
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.layoutCell();
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.firstColumnInset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_first_column_inset"));
            this.setSize(this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        if ("All attribues changed".equals(att)) {
            if (this.model != null && this.model.getParentModel().isHeader()) {
                this.label1.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("table_header_font_size"), LafLoader.getLafLoader().getAttribute("table_default_font_style")));
            } else {
                this.label1.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("table_default_font_style")));
            }
        }
    }

    public static String getValueString(PeriodComplete value) {
        DateConverter c1 = (DateConverter)ConverterRegistry.getConverter(DateConverter.class);
        return c1.convert((Object)value.getStartDate(), null, new Object[0]) + " - " + c1.convert((Object)value.getEndDate(), null, new Object[0]);
    }
}

