/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.server.core.dtos.masterdata.SeasonComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;

public class CellViewSeasonsRenderer
extends CellRenderer {
    private SeasonComplete season;
    private TextLabel label;

    public CellViewSeasonsRenderer(SeasonComplete period, Component delegate) {
        this.season = period;
        this.label = new TextLabel();
        this.label.setDelegateComponent(delegate);
        if (period != null) {
            this.label.setText(period.getName());
        } else {
            this.label.setText(Words.NOT_SET);
        }
        this.setLayout(null);
        this.setOpaque(false);
        this.add(this.label);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.label.kill();
        this.label = null;
    }

    @Override
    public String getStringValue() {
        return this.label.getText();
    }

    public SeasonComplete getSeason() {
        return this.season;
    }

    @Override
    protected void layoutCell() {
        if (this.isFirstColumn) {
            this.label.setLocation(this.firstColumnInset, (int)(((double)this.getHeight() - this.label.getPreferredSize().getHeight()) / 2.0));
        } else {
            this.label.setLocation(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding")), (int)(((double)this.getHeight() - this.label.getPreferredSize().getHeight()) / 2.0));
        }
        this.label.setSize(this.getWidth() - 2 * this.label.getX(), (int)this.label.getPreferredSize().getHeight());
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.layoutCell();
    }

    public static String getValueString(SeasonComplete value) {
        if (value != null) {
            return value.getName();
        }
        return "";
    }
}

