/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.converter.SealCheckConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.SealCheckE;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SealTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    public static final String FRONT_DOOR_ID = "Front";
    public static final String REAR_DOOR_ID = "Rear";

    public SealTable() {
        this(false);
    }

    public SealTable(boolean editable) {
        this(editable, false, "");
    }

    public SealTable(boolean editable, boolean withTitle, String title) {
        super(editable, "Add Seal", true, withTitle, title);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                SealTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("DOOR", null, null, null, "", 130, 130, 130));
        columns.add(new TableColumnInfo("SEAL STATE", null, null, null, "", 150, 150, 150));
        columns.add(new TableColumnInfo("SEAL NO", null, null, null, "", 30, 30, 30));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
        Table2Model tModel = new Table2Model(columns, model1 -> new TableRowImpl(model1));
        this.setModel(tModel);
    }

    public void setNode(Node<List<SealComplete>> node) {
        this.getModel().setNode(node);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel idString;
        private ComboBox sealCheck;
        private TextField sealNo;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.idString = new TextLabel(m.getNode().getChildNamed(new String[]{"identifier"}));
            this.sealCheck = new ComboBox(this.model.getNode().getChildNamed(new String[]{"sealCheck"}), NodeToolkit.getAffixList(SealCheckE.class), ConverterRegistry.getConverter(SealCheckConverter.class));
            this.sealNo = new NumberTextField(m.getNode().getChildNamed(new String[]{"sealNumber"}), TextFieldType.INT);
            this.setLayout(new Layout());
            this.add(this.idString);
            this.add(this.sealCheck);
            this.add(this.sealNo);
        }

        @Override
        public boolean isInnerComponent(Component c) {
            if (this.sealCheck.isInnerComponent(c)) {
                return true;
            }
            return super.isInnerComponent(c);
        }

        public ArrayList<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.sealCheck);
            CheckedListAdder.addToList(a, this.sealNo);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new String[]{"identifier"}).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(new String[]{"sealNumber"}).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.idString.setEnabled(isEnabled);
            this.sealCheck.setEnabled(isEnabled);
            this.sealNo.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.idString != null) {
                this.idString.kill();
            }
            this.idString = null;
            if (this.sealCheck != null) {
                this.sealCheck.kill();
            }
            this.sealCheck = null;
            if (this.sealNo != null) {
                this.sealNo.kill();
            }
            this.sealNo = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.idString.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.idString.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.idString.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.idString.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.sealCheck.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.sealCheck.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.sealCheck.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.sealCheck.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.sealNo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.sealNo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.sealNo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.sealNo.getPreferredSize().getHeight());
            }
        }
    }
}

