/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.ReceivingRemarkConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollableTextArea;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.prototypes.ToggleSkinButton_NEW;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.IPopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.StringPopUpInsert;
import ch.icit.pegasus.client.gui.utils.skins.ToggleSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.server.core.dtos.store.transaction.remark.StockTransactionRemarkComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public class StockTransactionRemarkButton<T extends StockTransactionRemarkComplete>
extends ToggleSkinButton_NEW
implements Validatable,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private IPopUpInsert popUpView;
    private Node<T> remarkNode;
    private Class<T> affixes;
    private boolean useComment;
    private Node<String> commentNode;
    private boolean canEdit = true;

    public StockTransactionRemarkButton(boolean hasInnerPop, Class<T> affixes) {
        super(DefaultSkins.RemarkIcon, false);
        this.affixes = affixes;
        this.setToolTipText(Words.SHOW_REMARK);
        this.setSize(this.getPreferredSize());
        if (hasInnerPop) {
            this.addButtonListener(this);
        }
        this.setChoosen(false);
    }

    public void setEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public StockTransactionRemarkButton(Node<T> remarkNode, Class<T> affixes) {
        this(remarkNode, affixes, true);
    }

    public StockTransactionRemarkButton(Node<T> remarkNode, Class<T> affixes, boolean canEdit) {
        this(true, affixes);
        this.canEdit = canEdit;
        this.setNode(remarkNode);
    }

    public void activateComment(Node commentNode) {
        this.useComment = true;
        this.commentNode = commentNode;
    }

    public Node<T> getNode() {
        return this.remarkNode;
    }

    public void setChoosen(boolean isChoosen) {
        this.setChecked(isChoosen);
    }

    public IPopUpInsert getPopUpView() {
        return this.popUpView;
    }

    public void setPopUpView(IPopUpInsert popUpView) {
        this.popUpView = popUpView;
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        super.popUpClosed(source, xargs);
        if (this.remarkNode != null && this.remarkNode.getValue() != null) {
            this.setChoosen(true);
        } else {
            this.setChoosen(false);
        }
    }

    public static int getPreferredWidth() {
        ToggleSkin1Field skin = (ToggleSkin1Field)DefaultSkins.RemarkIcon.createDynamicSkin();
        return skin.getImage(Button.ButtonState.UP).getWidth();
    }

    @Override
    public void setInvalid() {
        this.setState(Button.ButtonState.ERROR);
    }

    @Override
    public void setValid() {
        if (this.state == Button.ButtonState.ERROR) {
            this.setState(Button.ButtonState.UP);
        }
    }

    @Override
    public void setWarning() {
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        InnerPopUp2 popUp = null;
        if (popUp == null) {
            popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(null, false, false, "Remark");
            if (this.canEdit) {
                popUp.setView(new RemarkCombo(this.useComment, this.commentNode));
            } else {
                String t = null;
                if (this.commentNode != null && this.commentNode.getValue() != null) {
                    t = (String)this.commentNode.getValue();
                }
                StockTransactionRemarkComplete r = null;
                if (this.remarkNode != null && this.remarkNode.getValue() != null) {
                    r = (StockTransactionRemarkComplete)this.remarkNode.getValue();
                }
                popUp.setView(new StringPopUpInsert(TransactionToolkit.getRemarkInfo(r, t)));
            }
            popUp.showPopUp(x, y, 200, -1, this, this, PopupType.NORMAL);
        }
    }

    public void setNode(Node<T> writableNodeImpl2) {
        this.remarkNode = writableNodeImpl2;
        if (this.remarkNode != null && this.remarkNode.getValue() != null) {
            this.setChoosen(true);
        } else {
            this.setChoosen(false);
        }
    }

    public void setAffixName(Class<T> string) {
        this.affixes = string;
    }

    @Override
    public void setPermanent(boolean isPermantent) {
    }

    private class RemarkCombo
    extends PopUpInsert {
        private static final long serialVersionUID = 1L;
        private ComboBox remarkCombo;
        private TextLabel title;
        private ScrollableTextArea commentField;

        public RemarkCombo(boolean isComment, Node<String> commentNode) {
            this.setLayout(new RemarkComboLayout());
            Node n = StockTransactionRemarkButton.this.remarkNode;
            if (n == null) {
                n = new DTONode();
            }
            Node all = NodeToolkit.getAffixList((Class)StockTransactionRemarkButton.this.affixes);
            ReceivingRemarkConverter viewConverter = (ReceivingRemarkConverter)ConverterRegistry.getConverter(ReceivingRemarkConverter.class);
            this.remarkCombo = new ComboBox(n, all, (Converter)viewConverter, true);
            this.remarkCombo.setProgress(1.0f);
            if (isComment) {
                this.title = new TextLabel("Comment");
                this.title.setProgress(1.0f);
                this.setTitleFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
                this.setTitleForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
                this.commentField = new ScrollableTextArea(commentNode);
                this.commentField.setProgress(1.0f);
                this.add(this.title);
                this.add(this.commentField);
            }
            this.setOpaque(false);
            this.setEnabled(true);
            this.add(this.remarkCombo);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.remarkCombo.setEnabled(isEnabled && StockTransactionRemarkButton.this.canEdit);
            if (this.commentField != null) {
                this.commentField.setEnabled(isEnabled && StockTransactionRemarkButton.this.canEdit);
            }
        }

        private void setTitleForeground(Color color4String) {
            if (this.title != null) {
                this.title.setForeground(color4String);
            }
        }

        private void setTitleFont(Font font4String) {
            if (this.title != null) {
                this.title.setFont(font4String);
            }
        }

        @Override
        public Object[] getValues(PopupAction isOK) {
            if (isOK == PopupAction.CANCEL) {
                return null;
            }
            return new Object[1];
        }

        @Override
        public boolean isInnerComponent(Component c) {
            if (this.remarkCombo.getCurrentPopUp() != null) {
                for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                    if (!currentC.equals(this.remarkCombo.getCurrentPopUp())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean tryToGrabFocus() {
            this.remarkCombo.requestFocusInWindow();
            return true;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.add(this.remarkCombo);
            return a;
        }

        @Override
        public boolean isClosableWithEnter() {
            if (this.remarkCombo.hasFocus()) {
                return !this.remarkCombo.isPopupVisible();
            }
            return this.commentField == null || !this.commentField.hasInnerFocus();
        }

        private class RemarkComboLayout
        extends DefaultLayout {
            private RemarkComboLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                RemarkCombo.this.remarkCombo.setLocation(0, 0);
                RemarkCombo.this.remarkCombo.setSize(parent.getWidth(), (int)RemarkCombo.this.remarkCombo.getPreferredSize().getHeight());
                if (RemarkCombo.this.commentField != null) {
                    RemarkCombo.this.title.setLocation(0, RemarkCombo.this.remarkCombo.getY() + RemarkCombo.this.remarkCombo.getHeight() + 5);
                    RemarkCombo.this.title.setSize(parent.getWidth(), (int)RemarkCombo.this.title.getPreferredSize().getHeight());
                    RemarkCombo.this.commentField.setLocation(0, RemarkCombo.this.title.getY() + RemarkCombo.this.title.getHeight() + 5);
                    RemarkCombo.this.commentField.setSize(parent.getWidth(), parent.getHeight() - RemarkCombo.this.commentField.getY());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int h = (int)RemarkCombo.this.remarkCombo.getPreferredSize().getHeight();
                if (RemarkCombo.this.commentField != null) {
                    h += 5;
                    h = (int)((double)h + RemarkCombo.this.title.getPreferredSize().getHeight());
                    h += 5;
                    h += 150;
                }
                return new Dimension(0, h);
            }
        }
    }
}

