/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.helpdesk;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.ModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class DownloadManualPopupInsert
extends PopUpInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private LoadingAnimation animation;
    private MultiLineTextLabel label;
    private File downloadedFile;
    private ModuleDefinitionComplete module;
    private SubModuleDefinitionComplete subModule;

    public DownloadManualPopupInsert(Object o) {
        if (o instanceof ModuleDefinitionComplete) {
            this.module = (ModuleDefinitionComplete)o;
        } else if (o instanceof SubModuleDefinitionComplete) {
            this.subModule = (SubModuleDefinitionComplete)o;
        }
        this.setLayout(new Layout());
        if (this.module != null && this.module.getDocumentation() != null) {
            this.ensureAnimation();
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    DownloadManualPopupInsert.this.downloadedFile = FileTransferUtil.download((PegasusFileComplete)DownloadManualPopupInsert.this.module.getDocumentation(), (FileTransferListener[])new FileTransferListener[]{new FileTransferListener(){

                        public void statusChanged(File file, FileTransferState state) {
                        }

                        public void exceptionOccurred(Exception exception) {
                        }
                    }});
                    if (DownloadManualPopupInsert.this.downloadedFile != null) {
                        String n = DownloadManualPopupInsert.this.downloadedFile.getPath();
                        n = n + ".pdf";
                        File f = new File(n);
                        if (DownloadManualPopupInsert.this.downloadedFile.renameTo(f)) {
                            DownloadManualPopupInsert.this.downloadedFile = f;
                        } else {
                            return null;
                        }
                    }
                    return new ViewNode("");
                }

                @Override
                public RemoteLoader getInvoker() {
                    return DownloadManualPopupInsert.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (this.subModule != null && this.subModule.getDocumentation() != null) {
            this.ensureAnimation();
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    DownloadManualPopupInsert.this.downloadedFile = FileTransferUtil.download((PegasusFileComplete)DownloadManualPopupInsert.this.subModule.getDocumentation(), (FileTransferListener[])new FileTransferListener[]{new FileTransferListener(){

                        public void statusChanged(File file, FileTransferState state) {
                        }

                        public void exceptionOccurred(Exception exception) {
                        }
                    }});
                    if (DownloadManualPopupInsert.this.downloadedFile != null) {
                        String n = DownloadManualPopupInsert.this.downloadedFile.getPath();
                        n = n.replaceAll(".tmp", ".pdf");
                        File f = new File(n);
                        if (DownloadManualPopupInsert.this.downloadedFile.renameTo(f)) {
                            DownloadManualPopupInsert.this.downloadedFile = f;
                        } else {
                            return null;
                        }
                    }
                    return new ViewNode("");
                }

                @Override
                public RemoteLoader getInvoker() {
                    return DownloadManualPopupInsert.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.remoteObjectLoaded(null);
        }
    }

    private void ensureAnimation() {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(Words.LOAD_DOCUMENTATION);
            this.animation.start();
            this.add(this.animation);
            this.animation.fadeIn();
        }
    }

    private void removeAnimation() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation.fadeOut(true);
            this.animation = null;
        }
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.label != null) {
            this.label.kill();
            this.label = null;
        }
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.removeAnimation();
        if (node == null || this.downloadedFile == null) {
            this.label = new MultiLineTextLabel(Words.NO_DOCUMENTATION_FOUND_FOR_THIS_MODULE);
        } else {
            this.label = new MultiLineTextLabel(Words.DOCUMENTATION_SUCCESSFULLY_LOADED);
            try {
                Desktop.getDesktop().open(this.downloadedFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.label.setProgress(1.0f);
        this.add(this.label);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(200, 150);
        }

        @Override
        public void layoutContainer(Container parent) {
            if (DownloadManualPopupInsert.this.animation != null) {
                DownloadManualPopupInsert.this.animation.setLocation((int)(((double)parent.getWidth() - DownloadManualPopupInsert.this.animation.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - DownloadManualPopupInsert.this.animation.getPreferredSize().getHeight()) / 2);
                DownloadManualPopupInsert.this.animation.setSize(DownloadManualPopupInsert.this.animation.getPreferredSize());
            } else if (DownloadManualPopupInsert.this.label != null) {
                DownloadManualPopupInsert.this.label.setLocation(10, 10);
                DownloadManualPopupInsert.this.label.setSize(parent.getWidth() - 20, (int)DownloadManualPopupInsert.this.label.getPreferredSize().getHeight());
            }
        }
    }
}

