/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.image.converter;

import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.services.exception.ClientRemoteException;
import java.awt.image.BufferedImage;

public abstract class ImageConverter {
    protected Integer preferredImage_dpi;
    protected Integer preferredHorizontalImage_size;
    protected Integer preferredVericalImage_size;

    public ImageConverter() {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.preferredImage_dpi = settings.getPreferredImage_dpi();
        this.preferredHorizontalImage_size = settings.getPreferredHorizontalImage_size();
        this.preferredVericalImage_size = settings.getPreferredVericalImage_size();
    }

    public abstract BufferedImage convertImage(BufferedImage var1, int var2, int var3) throws ClientRemoteException;

    public BufferedImage convertImage(BufferedImage image) throws ClientRemoteException {
        return this.convertImage(image, this.preferredHorizontalImage_size, this.preferredVericalImage_size);
    }

    public static ImageConverter getConverter(String fullQualifiedClassName) {
        try {
            Class<?> c = Class.forName(fullQualifiedClassName);
            ImageConverter conv = (ImageConverter)c.newInstance();
            return conv;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

