/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.layout;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.layout.CreepyLayoutComparator;
import ch.icit.pegasus.client.gui.utils.layout.CreepyLayoutConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class CreepyLayout
extends DefaultLayout {
    private final Map<JComponent, CreepyLayoutConstraints> constraints = new HashMap<JComponent, CreepyLayoutConstraints>();
    private final List<JComponent> components = new ArrayList<JComponent>();
    private final List<List<JComponent>> lines = new ArrayList<List<JComponent>>();
    private boolean isSorted = false;
    private int innerBorderV = 5;
    private int outerBorderV = 10;
    private int innerBorderH = 5;
    private int outerBorderH = 10;

    public int getInnerBorderV() {
        return this.innerBorderV;
    }

    public void setInnerBorderVertical(int innerBorderV) {
        this.innerBorderV = innerBorderV;
    }

    public int getOuterBorderVertical() {
        return this.outerBorderV;
    }

    public void setOuterBorderVertical(int outerBorderV) {
        this.outerBorderV = outerBorderV;
    }

    public int getInnerBorderHorizontal() {
        return this.innerBorderH;
    }

    public void setInnerBorderHorizontal(int innerBorderH) {
        this.innerBorderH = innerBorderH;
    }

    public int getOuterBorderHorizontal() {
        return this.outerBorderH;
    }

    public void setOuterBorderHorizontal(int outerBorderH) {
        this.outerBorderH = outerBorderH;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (this.components.contains(comp)) {
            throw new IllegalStateException("Component is already added!");
        }
        if (constraints == null || !(constraints instanceof CreepyLayoutConstraints)) {
            throw new IllegalArgumentException("Given Constraint isn't of type CreepyLayoutConstraints");
        }
        this.constraints.put((JComponent)comp, (CreepyLayoutConstraints)constraints);
        this.components.add((JComponent)comp);
        this.isSorted = false;
        super.addLayoutComponent(comp, constraints);
    }

    private void ensureSortOrder() {
        if (!this.isSorted) {
            Collections.sort(this.components, new CreepyLayoutComparator(this.constraints));
            this.isSorted = true;
            this.lines.clear();
            for (JComponent c : this.components) {
                CreepyLayoutConstraints constraint = this.constraints.get(c);
                int i = constraint.getRow();
                while (this.lines.size() <= i) {
                    this.lines.add(new ArrayList());
                }
                this.lines.get(i).add(c);
            }
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        this.ensureSortOrder();
        int currentRow = 0;
        int currentRowMaxHeight = 0;
        int currentH = this.outerBorderV;
        int maxWidth = 0;
        int currentX = this.outerBorderH;
        for (JComponent c : this.components) {
            Dimension d;
            int ch;
            CreepyLayoutConstraints constraint = this.constraints.get(c);
            if (constraint.getRow() > currentRow) {
                currentX -= this.innerBorderH;
                if (maxWidth < (currentX += this.outerBorderH)) {
                    maxWidth = currentX;
                }
                currentX = this.outerBorderH;
                currentH += currentRowMaxHeight + this.innerBorderV;
                currentRowMaxHeight = 0;
                currentRow = constraint.getRow();
            }
            if ((ch = (int)(d = c.getPreferredSize()).getHeight()) > currentRowMaxHeight) {
                currentRowMaxHeight = ch;
            }
            currentX = (int)((double)currentX + d.getWidth());
            currentX += this.innerBorderH;
        }
        currentH += currentRowMaxHeight;
        currentH += this.outerBorderV;
        currentX -= this.innerBorderH;
        if (maxWidth < (currentX += this.outerBorderH)) {
            maxWidth = currentX;
        }
        return new Dimension(maxWidth, currentH);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.ensureSortOrder();
        HashMap<Integer, Dimension> lineDimensions = new HashMap<Integer, Dimension>();
        int totalHeight = 0;
        int count = 0;
        for (List<JComponent> line : this.lines) {
            int cx = this.outerBorderH;
            int maxHeight = 0;
            for (JComponent jComponent : line) {
                Dimension d = jComponent.getPreferredSize();
                if ((double)maxHeight < d.getHeight()) {
                    maxHeight = (int)d.getHeight();
                }
                cx = (int)((double)cx + (d.getWidth() + (double)this.innerBorderH));
            }
            cx -= this.innerBorderH;
            lineDimensions.put(count, new Dimension(cx += this.outerBorderH, maxHeight));
            ++count;
            totalHeight += maxHeight;
        }
        double difY = parent.getHeight() - totalHeight;
        int currentX = this.outerBorderH;
        int currentY = this.outerBorderV;
        count = 0;
        for (List list : this.lines) {
            Dimension prefDimension = (Dimension)lineDimensions.get(count);
            double cx = prefDimension.getWidth();
            double maxHeight = 0.0;
            double difX = (double)parent.getWidth() - cx;
            for (JComponent c : list) {
                Dimension d = c.getPreferredSize();
                CreepyLayoutConstraints constraint = this.constraints.get(c);
                c.setLocation(currentX, currentY);
                c.setSize((int)(d.getWidth() + difX * constraint.getxWeight()), (int)(d.getHeight() + difY * constraint.getyWeight()));
                if ((double)c.getHeight() > maxHeight) {
                    maxHeight = c.getHeight();
                }
                currentX += c.getWidth() + this.innerBorderH;
            }
            currentY = (int)((double)currentY + (maxHeight + (double)this.innerBorderH));
            currentX = this.outerBorderH;
            ++count;
        }
    }
}

