/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.converter.SalutationConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDPhoneField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.SalutationComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ContactPanel
extends JPanelFadable
implements Focusable {
    private static final long serialVersionUID = 1L;
    private TextLabel contactDetailsTitle;
    private TitledItem<RDComboBox> salutation;
    private TitledItem<RDTextField> companyName;
    private TitledItem<RDCheckBox> solarCompany;
    private TitledItem<Table2> vatNo;
    private TitledItem<RDTextField> firstName;
    private TitledItem<RDTextField> lastName;
    private TitledItem<RDTextField> title;
    private TitledItem<RDTextField> function;
    private TitledItem<RDPhoneField2> phone;
    private TitledItem<RDPhoneField2> mobile;
    private TitledItem<RDPhoneField2> fax;
    private TitledItem<RDTextField> email;
    private TitledItem<RDTextField> station;
    private TitledItem<RDTextField> sita;
    private VerticalSeparator sep1;
    private TextLabel addressTitle;
    private TitledItem<RDTextField> locationIdentifier;
    private TitledItem<RDTextField> buildingIdentifier;
    private TitledItem<RDTextField> street;
    private TitledItem<RDTextField> number;
    private TitledItem<RDTextField> poBox;
    private TitledItem<RDTextField> district;
    private TitledItem<RDTextField> city;
    private TitledItem<RDTextField> zip;
    private TitledItem<RDTextField> country;
    private TitledItem<RDTextField> countryCode;
    private TitledItem<RDTextField> province;
    private TitledItem<RDTextField> webSite;
    private Node<?> node;
    private RDProvider provider;
    private String overrideName = "contacts";
    private boolean useWrite = false;

    public ContactPanel() {
        this(null, false, false, null, null);
    }

    public ContactPanel(boolean b) {
        this(null, b, false, null, null);
    }

    public ContactPanel(RDProvider provider) {
        this(provider, null);
    }

    public ContactPanel(RDProvider provider, String overrideName) {
        this(null, false, false, provider, overrideName);
    }

    public ContactPanel(Node<ContactComplete> node, boolean isStandalone, boolean withVAT, RDProvider provider, String overrideName) {
        this.provider = provider;
        if (overrideName != null) {
            this.overrideName = overrideName;
        }
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.install(isStandalone, withVAT);
        this.setEnabled(false);
    }

    public void setUseWrite(boolean b) {
        this.useWrite = b;
    }

    private void install(boolean isStandalone, boolean withVat) {
        this.contactDetailsTitle = new TextLabel(Words.CONTACT_DETAILS);
        this.contactDetailsTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("supplier_overview_subtitle_type")));
        this.contactDetailsTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("supplier_overview_subtitle_foreground")));
        if (isStandalone) {
            this.companyName = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.COMPANY_NAME, TitledItem.TitledItemOrientation.NORTH);
            this.companyName.getFader().setPermanent(true);
            this.companyName.getElement().setOverrideName(this.overrideName);
            this.companyName.setProgress(1.0f);
            this.solarCompany = new TitledItem<RDCheckBox>(new RDCheckBox(this.provider), "Solar Company", TitledItem.TitledItemOrientation.EAST);
            this.solarCompany.getFader().setPermanent(true);
            this.solarCompany.getElement().setOverrideName(this.overrideName);
            if (withVat) {
                Table2 table = new Table2(true, Words.ADD_VAT, true, false);
                table.setProvider(this.provider);
                table.setUseWriteAccessRight(this.useWrite);
                table.setOverrideName(this.overrideName);
                table.setButtonHandler(new Table2ButtonHandler(){

                    @Override
                    public void childRemoved() {
                        ContactPanel.this.validate();
                    }

                    @Override
                    public void addButtonPressed(int x, int y, Button source) {
                        Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)"", true, false);
                        ((Table2)ContactPanel.this.vatNo.getElement()).getModel().getNode().addChild(node, System.currentTimeMillis());
                        ContactPanel.this.invalidate();
                        ContactPanel.this.revalidate();
                        ContactPanel.this.validate();
                    }
                });
                ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
                columns.add(new TableColumnInfo(Words.NUMBER, null, null, null, "", 40, 40, 40));
                int tw = 2 * table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
                columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
                ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
                ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
                table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
                this.vatNo = new TitledItem<Table2>(table, Words.VAT_NUMBER, TitledItem.TitledItemOrientation.NORTH);
                this.vatNo.setIgnorePrefHeight(true);
                this.add(this.vatNo);
            }
            this.add(this.companyName);
            this.add(this.solarCompany);
        }
        this.salutation = new TitledItem<RDComboBox>(new RDComboBox(this.provider, ConverterRegistry.getConverter(SalutationConverter.class), true), Words.SALUTATION, TitledItem.TitledItemOrientation.NORTH);
        this.salutation.getElement().setOverrideName(this.overrideName);
        this.firstName = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.FIRST_NAME, TitledItem.TitledItemOrientation.NORTH);
        this.firstName.getElement().setOverrideName(this.overrideName);
        this.lastName = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.LAST_NAME, TitledItem.TitledItemOrientation.NORTH);
        this.lastName.getElement().setOverrideName(this.overrideName);
        this.title = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.TITLE, TitledItem.TitledItemOrientation.NORTH);
        this.title.getElement().setOverrideName(this.overrideName);
        this.function = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.FUNCTION, TitledItem.TitledItemOrientation.NORTH);
        this.function.getElement().setOverrideName(this.overrideName);
        this.phone = new TitledItem<RDPhoneField2>(new RDPhoneField2(this.provider), Words.TELEPHONE, TitledItem.TitledItemOrientation.NORTH);
        this.phone.getElement().setOverrideName(this.overrideName);
        this.mobile = new TitledItem<RDPhoneField2>(new RDPhoneField2(this.provider), Words.MOBILE, TitledItem.TitledItemOrientation.NORTH);
        this.mobile.getElement().setOverrideName(this.overrideName);
        this.email = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.EMAIL, TitledItem.TitledItemOrientation.NORTH);
        this.email.getElement().setOverrideName(this.overrideName);
        this.fax = new TitledItem<RDPhoneField2>(new RDPhoneField2(this.provider), Words.FAX, TitledItem.TitledItemOrientation.NORTH);
        this.fax.getElement().setOverrideName(this.overrideName);
        this.station = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.STATION, TitledItem.TitledItemOrientation.NORTH);
        this.station.getElement().setOverrideName(this.overrideName);
        this.sita = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.SITA, TitledItem.TitledItemOrientation.NORTH);
        this.sita.getElement().setOverrideName(this.overrideName);
        this.sep1 = new VerticalSeparator();
        this.addressTitle = new TextLabel(Words.ADDRESS);
        this.addressTitle.setFont(this.contactDetailsTitle.getFont());
        this.addressTitle.setForeground(this.contactDetailsTitle.getComponentForeground());
        this.locationIdentifier = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.LOCATION, TitledItem.TitledItemOrientation.NORTH);
        this.locationIdentifier.getElement().setOverrideName(this.overrideName);
        this.buildingIdentifier = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.BUILDING, TitledItem.TitledItemOrientation.NORTH);
        this.buildingIdentifier.getElement().setOverrideName(this.overrideName);
        this.street = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.STREET, TitledItem.TitledItemOrientation.NORTH);
        this.street.getElement().setOverrideName(this.overrideName);
        this.number = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setOverrideName(this.overrideName);
        this.poBox = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.PO_BOX, TitledItem.TitledItemOrientation.NORTH);
        this.poBox.getElement().setOverrideName(this.overrideName);
        this.district = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.DISTRICT, TitledItem.TitledItemOrientation.NORTH);
        this.district.getElement().setOverrideName(this.overrideName);
        this.city = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.CITY, TitledItem.TitledItemOrientation.NORTH);
        this.city.getElement().setOverrideName(this.overrideName);
        this.zip = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.ZIP_CODE, TitledItem.TitledItemOrientation.NORTH);
        this.zip.getElement().setOverrideName(this.overrideName);
        this.country = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.COUNTRY, TitledItem.TitledItemOrientation.NORTH);
        this.country.getElement().setOverrideName(this.overrideName);
        this.countryCode = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.COUNTRY_CODE, TitledItem.TitledItemOrientation.NORTH);
        this.countryCode.getElement().setOverrideName(this.overrideName);
        this.province = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.PROVINCE, TitledItem.TitledItemOrientation.NORTH);
        this.province.getElement().setOverrideName(this.overrideName);
        this.webSite = new TitledItem<RDTextField>(new RDTextField(this.provider), Words.WEB_SITE, TitledItem.TitledItemOrientation.NORTH);
        this.webSite.getElement().setOverrideName(this.overrideName);
        this.salutation.getFader().setPermanent(true);
        this.poBox.getFader().setPermanent(true);
        this.webSite.getFader().setPermanent(true);
        this.contactDetailsTitle.getFader().setPermanent(true);
        this.firstName.getFader().setPermanent(true);
        this.lastName.getFader().setPermanent(true);
        this.title.getFader().setPermanent(true);
        this.function.getFader().setPermanent(true);
        this.phone.getFader().setPermanent(true);
        this.mobile.getFader().setPermanent(true);
        this.fax.getFader().setPermanent(true);
        this.email.getFader().setPermanent(true);
        this.station.getFader().setPermanent(true);
        this.sita.getFader().setPermanent(true);
        this.addressTitle.getFader().setPermanent(true);
        this.locationIdentifier.getFader().setPermanent(true);
        this.buildingIdentifier.getFader().setPermanent(true);
        this.street.getFader().setPermanent(true);
        this.number.getFader().setPermanent(true);
        this.district.getFader().setPermanent(true);
        this.city.getFader().setPermanent(true);
        this.zip.getFader().setPermanent(true);
        this.country.getFader().setPermanent(true);
        this.countryCode.getFader().setPermanent(true);
        this.province.getFader().setPermanent(true);
        this.contactDetailsTitle.setProgress(1.0f);
        this.firstName.setProgress(1.0f);
        this.lastName.setProgress(1.0f);
        this.title.setProgress(1.0f);
        this.function.setProgress(1.0f);
        this.phone.setProgress(1.0f);
        this.mobile.setProgress(1.0f);
        this.fax.setProgress(1.0f);
        this.email.setProgress(1.0f);
        this.station.setProgress(1.0f);
        this.sita.setProgress(1.0f);
        this.addressTitle.setProgress(1.0f);
        this.locationIdentifier.setProgress(1.0f);
        this.buildingIdentifier.setProgress(1.0f);
        this.street.setProgress(1.0f);
        this.number.setProgress(1.0f);
        this.district.setProgress(1.0f);
        this.city.setProgress(1.0f);
        this.zip.setProgress(1.0f);
        this.country.setProgress(1.0f);
        this.countryCode.setProgress(1.0f);
        this.province.setProgress(1.0f);
        this.sep1.setVisible(true);
        this.salutation.setProgress(1.0f);
        this.poBox.setProgress(1.0f);
        this.webSite.setProgress(1.0f);
        this.add(this.contactDetailsTitle);
        this.add(this.salutation);
        this.add(this.firstName);
        this.add(this.lastName);
        this.add(this.title);
        this.add(this.function);
        this.add(this.phone);
        this.add(this.mobile);
        this.add(this.fax);
        this.add(this.email);
        this.add(this.station);
        this.add(this.sita);
        this.add(this.sep1);
        this.add(this.addressTitle);
        this.add(this.locationIdentifier);
        this.add(this.buildingIdentifier);
        this.add(this.street);
        this.add(this.number);
        this.add(this.poBox);
        this.add(this.district);
        this.add(this.city);
        this.add(this.zip);
        this.add(this.country);
        this.add(this.countryCode);
        this.add(this.province);
        this.add(this.webSite);
    }

    public Color getComponentForeground() {
        return this.addressTitle.getComponentForeground();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.contactDetailsTitle.kill();
        this.firstName.kill();
        this.lastName.kill();
        this.title.kill();
        this.function.kill();
        this.phone.kill();
        this.mobile.kill();
        this.fax.kill();
        this.email.kill();
        this.station.kill();
        this.sita.kill();
        this.addressTitle.kill();
        this.locationIdentifier.kill();
        this.buildingIdentifier.kill();
        this.street.kill();
        this.number.kill();
        this.district.kill();
        this.city.kill();
        this.zip.kill();
        this.country.kill();
        this.countryCode.kill();
        this.province.kill();
        this.salutation.kill();
        this.poBox.kill();
        this.webSite.kill();
        if (this.companyName != null) {
            this.companyName.kill();
            this.companyName = null;
        }
        if (this.solarCompany != null) {
            this.solarCompany.kill();
            this.solarCompany = null;
        }
        if (this.vatNo != null) {
            this.vatNo.kill();
            this.vatNo = null;
        }
        this.contactDetailsTitle = null;
        this.firstName = null;
        this.lastName = null;
        this.title = null;
        this.function = null;
        this.phone = null;
        this.mobile = null;
        this.fax = null;
        this.email = null;
        this.station = null;
        this.sita = null;
        this.addressTitle = null;
        this.locationIdentifier = null;
        this.buildingIdentifier = null;
        this.street = null;
        this.number = null;
        this.district = null;
        this.city = null;
        this.zip = null;
        this.country = null;
        this.countryCode = null;
        this.province = null;
        this.salutation = null;
        this.poBox = null;
        this.webSite = null;
    }

    public void setNode(Node<?> n) {
        this.node = n;
        if (this.node != null) {
            if (this.companyName != null) {
                this.companyName.getElement().setNode(n.getChildNamed(ContactComplete_.companyName));
            }
            if (this.solarCompany != null) {
                this.solarCompany.getElement().setNode(n.getChildNamed(ContactComplete_.solarCompanyType));
            }
            if (this.vatNo != null) {
                this.vatNo.getElement().getModel().setNode(n.getChildNamed(ContactComplete_.vatNumbers));
            }
            this.salutation.getElement().refreshPossibleValues(NodeToolkit.getAffixList(SalutationComplete.class));
            this.salutation.getElement().setNode(n.getChildNamed(ContactComplete_.salutation));
            this.firstName.getElement().setNode(n.getChildNamed(ContactComplete_.firstName));
            this.lastName.getElement().setNode(n.getChildNamed(ContactComplete_.lastName));
            this.title.getElement().setNode(n.getChildNamed(ContactComplete_.title));
            this.function.getElement().setNode(n.getChildNamed(ContactComplete_.function));
            this.phone.getElement().setNode(n.getChildNamed(ContactComplete_.tel));
            this.mobile.getElement().setNode(n.getChildNamed(ContactComplete_.mobile));
            this.email.getElement().setNode(n.getChildNamed(ContactComplete_.email));
            this.fax.getElement().setNode(n.getChildNamed(ContactComplete_.fax));
            this.station.getElement().setNode(n.getChildNamed(ContactComplete_.station));
            this.sita.getElement().setNode(n.getChildNamed(ContactComplete_.sitaCode));
            this.locationIdentifier.getElement().setNode(n.getChildNamed(ContactComplete_.locationIdentifier));
            this.buildingIdentifier.getElement().setNode(n.getChildNamed(ContactComplete_.buildingIdentifier));
            this.street.getElement().setNode(n.getChildNamed(ContactComplete_.street));
            this.number.getElement().setNode(n.getChildNamed(ContactComplete_.streetNumber));
            this.poBox.getElement().setNode(n.getChildNamed(ContactComplete_.poBox));
            this.webSite.getElement().setNode(n.getChildNamed(ContactComplete_.homePage));
            this.district.getElement().setNode(n.getChildNamed(ContactComplete_.district));
            this.city.getElement().setNode(n.getChildNamed(ContactComplete_.city));
            this.zip.getElement().setNode(n.getChildNamed(ContactComplete_.zipCode));
            this.country.getElement().setNode(n.getChildNamed(ContactComplete_.country));
            this.countryCode.getElement().setNode(n.getChildNamed(ContactComplete_.countryCode));
            this.province.getElement().setNode(n.getChildNamed(ContactComplete_.province));
        }
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.companyName != null) {
            this.companyName.setEnabled(isEnabled);
        }
        if (this.solarCompany != null) {
            this.solarCompany.setEnabled(isEnabled);
        }
        if (this.vatNo != null) {
            this.vatNo.setEnabled(isEnabled);
        }
        this.contactDetailsTitle.setEnabled(isEnabled);
        this.firstName.setEnabled(isEnabled);
        this.lastName.setEnabled(isEnabled);
        this.title.setEnabled(isEnabled);
        this.function.setEnabled(isEnabled);
        this.phone.setEnabled(isEnabled);
        this.mobile.setEnabled(isEnabled);
        this.fax.setEnabled(isEnabled);
        this.email.setEnabled(isEnabled);
        this.station.setEnabled(isEnabled);
        this.sita.setEnabled(isEnabled);
        this.addressTitle.setEnabled(isEnabled);
        this.locationIdentifier.setEnabled(isEnabled);
        this.buildingIdentifier.setEnabled(isEnabled);
        this.street.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.district.setEnabled(isEnabled);
        this.city.setEnabled(isEnabled);
        this.zip.setEnabled(isEnabled);
        this.country.setEnabled(isEnabled);
        this.countryCode.setEnabled(isEnabled);
        this.province.setEnabled(isEnabled);
        this.poBox.setEnabled(isEnabled);
        this.webSite.setEnabled(isEnabled);
        this.salutation.setEnabled(isEnabled);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusComponents = new ArrayList<Component>();
        CheckedListAdder.addToList(focusComponents, this.companyName);
        CheckedListAdder.addToList(focusComponents, this.solarCompany);
        CheckedListAdder.addToList(focusComponents, this.vatNo);
        CheckedListAdder.addToList(focusComponents, this.salutation);
        CheckedListAdder.addToList(focusComponents, this.firstName);
        CheckedListAdder.addToList(focusComponents, this.lastName);
        CheckedListAdder.addToList(focusComponents, this.title);
        CheckedListAdder.addToList(focusComponents, this.function);
        CheckedListAdder.addToList(focusComponents, this.phone);
        CheckedListAdder.addToList(focusComponents, this.mobile);
        CheckedListAdder.addToList(focusComponents, this.email);
        CheckedListAdder.addToList(focusComponents, this.fax);
        CheckedListAdder.addToList(focusComponents, this.station);
        CheckedListAdder.addToList(focusComponents, this.sita);
        CheckedListAdder.addToList(focusComponents, this.locationIdentifier);
        CheckedListAdder.addToList(focusComponents, this.buildingIdentifier);
        CheckedListAdder.addToList(focusComponents, this.street);
        CheckedListAdder.addToList(focusComponents, this.number);
        CheckedListAdder.addToList(focusComponents, this.poBox);
        CheckedListAdder.addToList(focusComponents, this.district);
        CheckedListAdder.addToList(focusComponents, this.city);
        CheckedListAdder.addToList(focusComponents, this.zip);
        CheckedListAdder.addToList(focusComponents, this.country);
        CheckedListAdder.addToList(focusComponents, this.countryCode);
        CheckedListAdder.addToList(focusComponents, this.province);
        CheckedListAdder.addToList(focusComponents, this.webSite);
        return focusComponents;
    }

    public void grabDefaultFocus() {
        this.firstName.getElement().requestFocusInWindowNow();
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        if (this.companyName != null) {
            this.companyName.setVisibleContainer(pane);
        }
        if (this.solarCompany != null) {
            this.solarCompany.setVisibleContainer(pane);
        }
        if (this.vatNo != null) {
            this.vatNo.setVisibleContainer(pane);
        }
        this.firstName.setVisibleContainer(pane);
        this.lastName.setVisibleContainer(pane);
        this.title.setVisibleContainer(pane);
        this.function.setVisibleContainer(pane);
        this.phone.setVisibleContainer(pane);
        this.mobile.setVisibleContainer(pane);
        this.fax.setVisibleContainer(pane);
        this.email.setVisibleContainer(pane);
        this.station.setVisibleContainer(pane);
        this.sita.setVisibleContainer(pane);
        this.locationIdentifier.setVisibleContainer(pane);
        this.buildingIdentifier.setVisibleContainer(pane);
        this.street.setVisibleContainer(pane);
        this.number.setVisibleContainer(pane);
        this.district.setVisibleContainer(pane);
        this.city.setVisibleContainer(pane);
        this.zip.setVisibleContainer(pane);
        this.country.setVisibleContainer(pane);
        this.countryCode.setVisibleContainer(pane);
        this.province.setVisibleContainer(pane);
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.salutation.requestFocusInWindowNow();
    }

    public Node<?> getNode() {
        return this.node;
    }

    @Override
    public void validate() {
        super.validate();
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextField vat;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.FOUR);
            this.vat = new TextField(m.getNode());
            this.delete = new DeleteButton(SizedSkin1Field.SkinSize.SMALL);
            this.delete.addButtonListener(this);
            this.setLayout(new InnerLayout());
            this.add(this.vat);
            this.add(this.delete);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.vat.kill();
            this.delete.kill();
            this.vat = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.vat);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.vat.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = 0;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.vat.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.vat.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.vat.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.vat.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int horizontalBorder = 10;
            int verticalBorder = 10;
            int aMinWidth = parent.getWidth() - 4 * horizontalBorder;
            aMinWidth /= 2;
            aMinWidth -= horizontalBorder;
            aMinWidth /= 2;
            ContactPanel.this.contactDetailsTitle.setLocation(0, 0);
            ContactPanel.this.contactDetailsTitle.setSize(ContactPanel.this.contactDetailsTitle.getPreferredSize());
            int cy = ContactPanel.this.contactDetailsTitle.getY() + ContactPanel.this.contactDetailsTitle.getHeight() + verticalBorder;
            if (ContactPanel.this.companyName != null) {
                ContactPanel.this.companyName.setLocation(0, cy);
                ContactPanel.this.companyName.setSize(aMinWidth * 2 + horizontalBorder, (int)ContactPanel.this.companyName.getPreferredSize().getHeight());
                cy += ContactPanel.this.companyName.getHeight() + verticalBorder;
            }
            if (ContactPanel.this.solarCompany != null) {
                ContactPanel.this.solarCompany.setLocation(0, cy);
                ContactPanel.this.solarCompany.setSize(aMinWidth * 2 + horizontalBorder, (int)ContactPanel.this.solarCompany.getPreferredSize().getHeight());
                cy += ContactPanel.this.solarCompany.getHeight() + verticalBorder;
            }
            if (ContactPanel.this.vatNo != null) {
                ContactPanel.this.vatNo.setLocation(0, cy);
                ContactPanel.this.vatNo.setSize(aMinWidth * 2 + horizontalBorder, 150);
                cy += 100 + verticalBorder;
            }
            ContactPanel.this.salutation.setLocation(0, cy);
            ContactPanel.this.salutation.setSize(aMinWidth, (int)ContactPanel.this.salutation.getPreferredSize().getHeight());
            ContactPanel.this.firstName.setLocation(0, ContactPanel.this.salutation.getY() + ContactPanel.this.salutation.getHeight() + verticalBorder);
            ContactPanel.this.firstName.setSize(aMinWidth, (int)ContactPanel.this.firstName.getPreferredSize().getHeight());
            ContactPanel.this.lastName.setLocation(ContactPanel.this.firstName.getX() + ContactPanel.this.firstName.getWidth() + horizontalBorder, ContactPanel.this.firstName.getY());
            ContactPanel.this.lastName.setSize(aMinWidth, (int)ContactPanel.this.lastName.getPreferredSize().getHeight());
            ContactPanel.this.title.setLocation(0, ContactPanel.this.firstName.getY() + ContactPanel.this.firstName.getHeight() + verticalBorder);
            ContactPanel.this.title.setSize(aMinWidth, (int)ContactPanel.this.title.getPreferredSize().getHeight());
            ContactPanel.this.function.setLocation(ContactPanel.this.lastName.getX(), ContactPanel.this.title.getY());
            ContactPanel.this.function.setSize(aMinWidth, (int)ContactPanel.this.function.getPreferredSize().getHeight());
            ContactPanel.this.phone.setLocation(0, ContactPanel.this.title.getY() + ContactPanel.this.title.getHeight() + verticalBorder);
            ContactPanel.this.phone.setSize(aMinWidth, (int)ContactPanel.this.phone.getPreferredSize().getHeight());
            ContactPanel.this.mobile.setLocation(ContactPanel.this.function.getX(), ContactPanel.this.phone.getY());
            ContactPanel.this.mobile.setSize(aMinWidth, (int)ContactPanel.this.mobile.getPreferredSize().getHeight());
            ContactPanel.this.email.setLocation(0, ContactPanel.this.phone.getY() + ContactPanel.this.phone.getHeight() + verticalBorder);
            ContactPanel.this.email.setSize(aMinWidth, (int)ContactPanel.this.email.getPreferredSize().getHeight());
            ContactPanel.this.fax.setLocation(ContactPanel.this.mobile.getX(), ContactPanel.this.email.getY());
            ContactPanel.this.fax.setSize(aMinWidth, (int)ContactPanel.this.fax.getPreferredSize().getHeight());
            ContactPanel.this.station.setLocation(0, ContactPanel.this.email.getY() + ContactPanel.this.email.getHeight() + verticalBorder);
            ContactPanel.this.station.setSize(aMinWidth, (int)ContactPanel.this.station.getPreferredSize().getHeight());
            ContactPanel.this.sita.setLocation(ContactPanel.this.fax.getX(), ContactPanel.this.station.getY());
            ContactPanel.this.sita.setSize(aMinWidth, (int)ContactPanel.this.sita.getPreferredSize().getHeight());
            ContactPanel.this.sep1.setLocation(ContactPanel.this.lastName.getX() + ContactPanel.this.lastName.getWidth() + horizontalBorder, 0);
            ContactPanel.this.sep1.setSize((int)ContactPanel.this.sep1.getPreferredSize().getWidth(), parent.getHeight());
            ContactPanel.this.addressTitle.setLocation(ContactPanel.this.sep1.getX() + horizontalBorder, 0);
            ContactPanel.this.addressTitle.setSize(ContactPanel.this.addressTitle.getPreferredSize());
            ContactPanel.this.locationIdentifier.setLocation(ContactPanel.this.addressTitle.getX(), ContactPanel.this.salutation.getY());
            ContactPanel.this.locationIdentifier.setSize(aMinWidth, (int)ContactPanel.this.locationIdentifier.getPreferredSize().getHeight());
            ContactPanel.this.buildingIdentifier.setLocation(ContactPanel.this.locationIdentifier.getX() + ContactPanel.this.locationIdentifier.getWidth() + horizontalBorder, ContactPanel.this.salutation.getY());
            ContactPanel.this.buildingIdentifier.setSize(aMinWidth, (int)ContactPanel.this.buildingIdentifier.getPreferredSize().getHeight());
            ContactPanel.this.street.setLocation(ContactPanel.this.addressTitle.getX(), ContactPanel.this.firstName.getY());
            ContactPanel.this.street.setSize(aMinWidth, (int)ContactPanel.this.street.getPreferredSize().getHeight());
            ContactPanel.this.number.setLocation(ContactPanel.this.street.getX() + ContactPanel.this.street.getWidth() + horizontalBorder, ContactPanel.this.street.getY());
            ContactPanel.this.number.setSize(aMinWidth, (int)ContactPanel.this.number.getPreferredSize().getHeight());
            ContactPanel.this.poBox.setLocation(ContactPanel.this.street.getX(), ContactPanel.this.street.getY() + ContactPanel.this.street.getHeight() + verticalBorder);
            ContactPanel.this.poBox.setSize(aMinWidth, (int)ContactPanel.this.poBox.getPreferredSize().getHeight());
            ContactPanel.this.district.setLocation(ContactPanel.this.number.getX(), ContactPanel.this.poBox.getY());
            ContactPanel.this.district.setSize(aMinWidth, (int)ContactPanel.this.district.getPreferredSize().getHeight());
            ContactPanel.this.city.setLocation(ContactPanel.this.street.getX(), ContactPanel.this.poBox.getY() + ContactPanel.this.poBox.getHeight() + verticalBorder);
            ContactPanel.this.city.setSize(aMinWidth, (int)ContactPanel.this.city.getPreferredSize().getHeight());
            ContactPanel.this.zip.setLocation(ContactPanel.this.number.getX(), ContactPanel.this.city.getY());
            ContactPanel.this.zip.setSize(aMinWidth, (int)ContactPanel.this.zip.getPreferredSize().getHeight());
            ContactPanel.this.country.setLocation(ContactPanel.this.city.getX(), ContactPanel.this.zip.getY() + ContactPanel.this.zip.getHeight() + verticalBorder);
            ContactPanel.this.country.setSize(aMinWidth, (int)ContactPanel.this.country.getPreferredSize().getHeight());
            int awh = (aMinWidth - 5) / 2;
            ContactPanel.this.countryCode.setLocation(ContactPanel.this.country.getX() + ContactPanel.this.country.getWidth() + horizontalBorder, ContactPanel.this.country.getY());
            ContactPanel.this.countryCode.setSize(awh, (int)ContactPanel.this.countryCode.getPreferredSize().getHeight());
            ContactPanel.this.province.setLocation(ContactPanel.this.countryCode.getX() + ContactPanel.this.countryCode.getWidth() + 5, ContactPanel.this.country.getY());
            ContactPanel.this.province.setSize(awh, (int)ContactPanel.this.province.getPreferredSize().getHeight());
            ContactPanel.this.webSite.setLocation(ContactPanel.this.country.getX(), ContactPanel.this.province.getY() + ContactPanel.this.province.getHeight() + verticalBorder);
            ContactPanel.this.webSite.setSize(aMinWidth, (int)ContactPanel.this.province.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int verticalBorder = 10;
            int h = 0;
            h = (int)((double)h + ContactPanel.this.contactDetailsTitle.getPreferredSize().getHeight());
            h += verticalBorder;
            if (ContactPanel.this.companyName != null) {
                h = (int)((double)h + ContactPanel.this.companyName.getPreferredSize().getHeight());
                h += verticalBorder;
            }
            if (ContactPanel.this.solarCompany != null) {
                h = (int)((double)h + ContactPanel.this.solarCompany.getPreferredSize().getHeight());
                h += verticalBorder;
            }
            if (ContactPanel.this.vatNo != null) {
                h += 150;
                h += verticalBorder;
            }
            h = (int)((double)h + ContactPanel.this.salutation.getPreferredSize().getHeight());
            h += verticalBorder;
            h = (int)((double)h + ContactPanel.this.firstName.getPreferredSize().getHeight());
            h += verticalBorder;
            h = (int)((double)h + ContactPanel.this.title.getPreferredSize().getHeight());
            h += verticalBorder;
            h = (int)((double)h + ContactPanel.this.phone.getPreferredSize().getHeight());
            h += verticalBorder;
            h = (int)((double)h + ContactPanel.this.email.getPreferredSize().getHeight());
            h += verticalBorder;
            h = (int)((double)h + ContactPanel.this.station.getPreferredSize().getHeight());
            return new Dimension(0, h);
        }
    }
}

