/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.animators.AnimationContainer;
import ch.icit.pegasus.client.gui.utils.animators.AnimationProvider;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.panels.AnimationPanel;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.util.ProgressListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;

public class LoadingAnimation
extends JPanelFadable
implements ActionListener,
LafListener,
AnimationContainer,
AttributeListener,
ImageConsumer,
ProgressListener {
    private static final long serialVersionUID = 1L;
    private static BufferedImage logo;
    private static BufferedImage[] images;
    private static boolean isInit;
    private int currentIndex = 0;
    private long animationTime = 0L;
    private long animationStartTime;
    private long minAnimationTime = 1500L;
    private boolean isPermanent;
    private int textFieldWidth = 0;
    private String postFix = "";
    private String preFix = "";
    private int textIncrement = 0;
    private TextLabel loadingText;

    public LoadingAnimation() {
        this.getFader().setProgress(0.0f);
        this.getFader().setAnimationContainer(this);
        this.setOpaque(false);
        this.loadingText = new TextLabel();
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        this.setLayout(new Layout());
        this.add(this.loadingText);
    }

    public void setPermanent(boolean b) {
        this.isPermanent = b;
    }

    private void setMaxTextForSizeing(String t) {
        this.textFieldWidth = this.loadingText.getFontMetrics(this.loadingText.getFont()).stringWidth(t + "...");
    }

    public void start() {
        AnimationProvider.registerAnimater(this);
        this.animationStartTime = System.currentTimeMillis();
    }

    public void setMetaParent(Component c) {
        this.getFader().setMetaParent(c);
    }

    public boolean isAbleToStop() {
        long t = System.currentTimeMillis();
        return t - this.animationStartTime > this.minAnimationTime;
    }

    public void stop() {
        AnimationProvider.deregisterAnimater(this);
    }

    private void incrementIndex() {
        ++this.currentIndex;
        if (images != null && this.currentIndex >= images.length) {
            this.currentIndex = 0;
        }
    }

    private void revalidateText() {
        if (this.textIncrement == 10) {
            this.preFix = this.preFix.length() >= 3 ? "." : this.preFix + ".";
            this.loadingText.setText(this.postFix + this.preFix);
            this.textIncrement = 0;
        } else {
            ++this.textIncrement;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int tw;
        int w = logo.getWidth();
        if (w < (tw = this.textFieldWidth)) {
            w = tw;
        }
        return new Dimension(w * 2, (int)((double)(logo.getHeight() + 5) + this.loadingText.getPreferredSize().getHeight()) * 2);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        float radius = 0.0f;
        radius = this.getHeight() > this.getWidth() ? (float)this.getWidth() / 2.0f : (float)this.getHeight() / 2.0f;
        int v = 95;
        Color c1 = new Color(v, v, v, 255);
        Color c2 = new Color(v, v, v, 0);
        RadialGradientPaint rgp = new RadialGradientPaint(new Point2D.Double(this.getWidth() / 2, this.getHeight() / 2), radius, new float[]{0.0f, 1.0f}, new Color[]{c1, c2});
        Paint b = g2.getPaint();
        g2.setPaint(rgp);
        g2.fillOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g2.setPaint(b);
        int y = (int)((double)(logo.getHeight() + 5) + this.loadingText.getPreferredSize().getHeight());
        y = (this.getHeight() - y) / 2;
        g2.drawImage(logo, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, (this.getWidth() - logo.getWidth()) / 2, y), null);
        if (images != null) {
            g2.drawImage(images[this.currentIndex], new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, (this.getWidth() - logo.getWidth()) / 2, y), null);
        }
        this.paintChildren(g2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.incrementIndex();
        this.revalidateText();
        this.repaint(32L);
    }

    @Override
    public void kill() {
        this.stop();
        if (this.isKilled()) {
            return;
        }
        if (this.getParent() != null) {
            Container parent = this.getParent();
            if (parent instanceof AnimationPanel) {
                Container table = parent.getParent();
                if (table instanceof Table) {
                    ((Table)table).setLoadingData(false);
                }
                if (table != null) {
                    table.remove(parent);
                }
                if (parent != null) {
                    parent.remove(this);
                }
                if (table != null) {
                    table.repaint(32L);
                }
            } else {
                parent.remove(this);
                parent.repaint(32L);
            }
        }
        super.kill();
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
    }

    @Override
    public void removeScheduled(Fadable comp) {
        if (!this.isPermanent) {
            this.kill();
        }
    }

    @Override
    public void attributeChanged(String attributeName) {
        this.animationTime = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("loading_animation_time")).intValue();
    }

    @Override
    public void loadImages() {
        if (!isInit) {
            isInit = true;
            logo = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("loading_logo"), false);
            if (logo == null) {
                logo = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("default_loading_logo"), true);
            }
            String folder = LafLoader.getLafLoader().getAttribute("loading_folder");
            String prefix = LafLoader.getLafLoader().getAttribute("loading_snake_prefix");
            String start = LafLoader.getLafLoader().getAttribute("loading_image_start");
            String end = LafLoader.getLafLoader().getAttribute("loading_image_end");
            String leadingNull = LafLoader.getLafLoader().getAttribute("loading_image_leading_null");
            String postfix = LafLoader.getLafLoader().getAttribute("loading_snake_postfix");
            int startNr = Integer.valueOf(start);
            int endNr = Integer.valueOf(end);
            int leadingNullNr = Integer.valueOf(leadingNull);
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            for (int i = startNr; i <= endNr; ++i) {
                String fileName = "" + i;
                while (fileName.length() != leadingNullNr) {
                    fileName = "0" + fileName;
                }
                fileName = folder + prefix + fileName + postfix;
                BufferedImage img = AttributesConverter.getBufferedImage4String(fileName);
                images.add(img);
            }
            LoadingAnimation.images = images.toArray(new BufferedImage[0]);
        }
    }

    @Override
    public void stateChanged(String newState) {
        this.setMaxTextForSizeing(newState);
        this.postFix = newState;
        this.loadingText.setText(newState);
        if (this.getParent() != null) {
            if (this.getParent() instanceof JComponent) {
                ((JComponent)this.getParent()).revalidate();
            } else {
                this.getParent().invalidate();
                this.getParent().validate();
            }
        }
    }

    @Override
    public void taskFinished() {
        this.stop();
        this.fadeOut(false);
    }

    @Override
    public void clearImages() {
        isInit = false;
        this.loadImages();
    }

    static {
        isInit = false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = (int)((double)(logo.getHeight() + 5) + LoadingAnimation.this.loadingText.getPreferredSize().getHeight());
            y = (parent.getHeight() - y) / 2;
            LoadingAnimation.this.loadingText.setLocation((parent.getWidth() - LoadingAnimation.this.textFieldWidth) / 2, y + logo.getHeight() + 5);
            LoadingAnimation.this.loadingText.setSize(LoadingAnimation.this.textFieldWidth, (int)LoadingAnimation.this.loadingText.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return LoadingAnimation.this.getPreferredSize();
        }
    }
}

