/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.PasswordTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SFTPDataExchangeSettingsPanel
extends DefaultPanel
implements Nodable {
    private static final long serialVersionUID = -63501969559965445L;
    private TitledItem<TextField> ftpURL = new TitledItem<TextField>(new TextField(), Words.FTP_URL, TitledItem.TitledItemOrientation.NORTH);
    private TitledItem<NumberTextField> port;
    private TitledItem<TextField> ftpFolder = new TitledItem<TextField>(new TextField(), Words.FOLDER, TitledItem.TitledItemOrientation.NORTH);
    private TitledItem<TextField> userName;
    private TitledItem<PasswordTextField> password;
    private TitledItem<CheckBox> moveFilesIntoBackup;
    private TitledItem<CheckBox> usePrivateKeyAuthentication;
    private TitledItem<TextField> localPrivateKeyPath;
    private Node<SFTPDataExchangeSettingsComplete> node;

    public SFTPDataExchangeSettingsPanel() {
        this.port = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT_NULLABLE), Words.FTP_PORT, TitledItem.TitledItemOrientation.NORTH);
        this.userName = new TitledItem<TextField>(new TextField(), Words.USER, TitledItem.TitledItemOrientation.NORTH);
        this.password = new TitledItem<PasswordTextField>(new PasswordTextField(), Words.PASSWORD, TitledItem.TitledItemOrientation.NORTH);
        this.moveFilesIntoBackup = new TitledItem<CheckBox>(new CheckBox(), Words.MOVE_PARSED_FILES_INTO_BACKUP_FOLDER, TitledItem.TitledItemOrientation.EAST);
        this.usePrivateKeyAuthentication = new TitledItem<CheckBox>(new CheckBox(), "Use Private Key Authentication", TitledItem.TitledItemOrientation.EAST);
        this.localPrivateKeyPath = new TitledItem<TextField>(new TextField(), "Local Private Key Path", TitledItem.TitledItemOrientation.NORTH);
        this.usePrivateKeyAuthentication.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        this.setLayout(new Layout());
        this.ftpURL.getFader().setPermanent(true);
        this.ftpFolder.getFader().setPermanent(true);
        this.port.getFader().setPermanent(true);
        this.userName.getFader().setPermanent(true);
        this.password.getFader().setPermanent(true);
        this.moveFilesIntoBackup.getFader().setPermanent(true);
        this.usePrivateKeyAuthentication.getFader().setPermanent(true);
        this.localPrivateKeyPath.getFader().setPermanent(true);
        this.getFader().setPermanent(true);
        this.add(this.ftpURL);
        this.add(this.ftpFolder);
        this.add(this.port);
        this.add(this.userName);
        this.add(this.password);
        this.add(this.moveFilesIntoBackup);
        this.add(this.usePrivateKeyAuthentication);
        this.add(this.localPrivateKeyPath);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enabled = isEnabled;
        this.ftpURL.setEnabled(enabled);
        this.ftpFolder.setEnabled(enabled);
        this.port.setEnabled(enabled);
        this.userName.setEnabled(enabled);
        this.password.setEnabled(enabled && !this.usePrivateKeyAuthentication.getElement().isChecked());
        this.moveFilesIntoBackup.setEnabled(enabled);
        this.usePrivateKeyAuthentication.setEnabled(enabled);
        this.localPrivateKeyPath.setEnabled(enabled && this.usePrivateKeyAuthentication.getElement().isChecked());
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.userName);
        CheckedListAdder.addToList(a, this.password);
        CheckedListAdder.addToList(a, this.ftpURL);
        CheckedListAdder.addToList(a, this.port);
        CheckedListAdder.addToList(a, this.ftpFolder);
        CheckedListAdder.addToList(a, this.moveFilesIntoBackup);
        CheckedListAdder.addToList(a, this.usePrivateKeyAuthentication);
        CheckedListAdder.addToList(a, this.localPrivateKeyPath);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.userName.setVisibleContainer(pane);
        this.password.setVisibleContainer(pane);
        this.ftpURL.setVisibleContainer(pane);
        this.port.setVisibleContainer(pane);
        this.ftpFolder.setVisibleContainer(pane);
        this.moveFilesIntoBackup.setVisibleContainer(pane);
        this.usePrivateKeyAuthentication.setVisibleContainer(pane);
        this.localPrivateKeyPath.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.userName.requestFocusInWindowNow();
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        this.ftpURL.getElement().setNode(node.getChildNamed(SFTPDataExchangeSettingsComplete_.dataExchangeURL));
        this.ftpFolder.getElement().setNode(node.getChildNamed(SFTPDataExchangeSettingsComplete_.dataExchangeFolder));
        this.port.getElement().setNode(node.getChildNamed(SFTPDataExchangeSettingsComplete_.dataExchangePort));
        this.userName.getElement().setNode(node.getChildNamed(SFTPDataExchangeSettingsComplete_.loginUser));
        this.password.getElement().setNode(node.getChildNamed(new DtoField[]{SFTPDataExchangeSettingsComplete_.loginPwd, EncryptedStringComplete_.password}));
        this.moveFilesIntoBackup.getElement().setNode(node.getChildNamed(SFTPDataExchangeSettingsComplete_.moveParsedFilesIntoBackupFolder));
        this.usePrivateKeyAuthentication.getElement().setNode(node.getChildNamed(SFTPDataExchangeSettingsComplete_.usePrivateKeyAuth));
        this.localPrivateKeyPath.getElement().setNode(node.getChildNamed(SFTPDataExchangeSettingsComplete_.localPrivateKeyPath));
    }

    @Override
    public Node<?> getNode() {
        return this.node;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            int border = 5;
            h = (int)((double)h + SFTPDataExchangeSettingsPanel.this.userName.getPreferredSize().getHeight());
            h = (int)((double)h + (SFTPDataExchangeSettingsPanel.this.ftpFolder.getPreferredSize().getHeight() + (double)border));
            h = (int)((double)h + (SFTPDataExchangeSettingsPanel.this.moveFilesIntoBackup.getPreferredSize().getHeight() + (double)border));
            h = (int)((double)h + SFTPDataExchangeSettingsPanel.this.usePrivateKeyAuthentication.getPreferredSize().getHeight());
            h = (int)((double)h + SFTPDataExchangeSettingsPanel.this.localPrivateKeyPath.getPreferredSize().getHeight());
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w2tl = (parent.getWidth() - 5) / 2;
            SFTPDataExchangeSettingsPanel.this.userName.setLocation(0, 0);
            SFTPDataExchangeSettingsPanel.this.userName.setSize(w2tl, (int)SFTPDataExchangeSettingsPanel.this.userName.getPreferredSize().getHeight());
            SFTPDataExchangeSettingsPanel.this.password.setLocation(SFTPDataExchangeSettingsPanel.this.userName.getX() + SFTPDataExchangeSettingsPanel.this.userName.getWidth() + 5, SFTPDataExchangeSettingsPanel.this.userName.getY());
            SFTPDataExchangeSettingsPanel.this.password.setSize(w2tl, (int)SFTPDataExchangeSettingsPanel.this.password.getPreferredSize().getHeight());
            w2tl = (parent.getWidth() - 70) / 2;
            SFTPDataExchangeSettingsPanel.this.ftpURL.setLocation(0, SFTPDataExchangeSettingsPanel.this.userName.getY() + SFTPDataExchangeSettingsPanel.this.userName.getHeight());
            SFTPDataExchangeSettingsPanel.this.ftpURL.setSize(w2tl, (int)SFTPDataExchangeSettingsPanel.this.ftpURL.getPreferredSize().getHeight());
            SFTPDataExchangeSettingsPanel.this.port.setLocation(SFTPDataExchangeSettingsPanel.this.ftpURL.getX() + SFTPDataExchangeSettingsPanel.this.ftpURL.getWidth() + 5, SFTPDataExchangeSettingsPanel.this.ftpURL.getY());
            SFTPDataExchangeSettingsPanel.this.port.setSize(60, (int)SFTPDataExchangeSettingsPanel.this.port.getPreferredSize().getHeight());
            SFTPDataExchangeSettingsPanel.this.ftpFolder.setLocation(SFTPDataExchangeSettingsPanel.this.port.getX() + SFTPDataExchangeSettingsPanel.this.port.getWidth() + 5, SFTPDataExchangeSettingsPanel.this.ftpURL.getY());
            SFTPDataExchangeSettingsPanel.this.ftpFolder.setSize(w2tl, (int)SFTPDataExchangeSettingsPanel.this.ftpFolder.getPreferredSize().getHeight());
            SFTPDataExchangeSettingsPanel.this.moveFilesIntoBackup.setLocation(0, SFTPDataExchangeSettingsPanel.this.ftpURL.getY() + SFTPDataExchangeSettingsPanel.this.ftpURL.getHeight() + 5);
            SFTPDataExchangeSettingsPanel.this.moveFilesIntoBackup.setSize(260, (int)SFTPDataExchangeSettingsPanel.this.moveFilesIntoBackup.getPreferredSize().getHeight());
            SFTPDataExchangeSettingsPanel.this.usePrivateKeyAuthentication.setLocation(0, SFTPDataExchangeSettingsPanel.this.moveFilesIntoBackup.getY() + SFTPDataExchangeSettingsPanel.this.moveFilesIntoBackup.getHeight() + 5);
            SFTPDataExchangeSettingsPanel.this.usePrivateKeyAuthentication.setSize(260, (int)SFTPDataExchangeSettingsPanel.this.usePrivateKeyAuthentication.getPreferredSize().getHeight());
            SFTPDataExchangeSettingsPanel.this.localPrivateKeyPath.setLocation(0, SFTPDataExchangeSettingsPanel.this.usePrivateKeyAuthentication.getY() + SFTPDataExchangeSettingsPanel.this.usePrivateKeyAuthentication.getHeight());
            SFTPDataExchangeSettingsPanel.this.localPrivateKeyPath.setSize(260, (int)SFTPDataExchangeSettingsPanel.this.localPrivateKeyPath.getPreferredSize().getHeight());
        }
    }
}

