/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.layouter.DetailsParagraphLayout;
import ch.icit.pegasus.client.gui.utils.panels.BackgroundedContainer;
import ch.icit.pegasus.client.gui.utils.panels.DisablePanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ScrollableBackground
extends BackgroundedContainer {
    private static final long serialVersionUID = 1L;
    private ScrollPane scrollPane;
    private JPanel viewPort;
    private boolean withBackground;
    private DisablePanel disablePanel;
    private LoadingAnimation animation;

    public ScrollableBackground(boolean withBackground) {
        this.install(withBackground);
    }

    public ScrollableBackground() {
        this(false);
    }

    public boolean ensureAnimation(String text) {
        if (this.disablePanel == null) {
            this.disablePanel = new DisablePanel();
            this.disablePanel.setVisible(true);
            this.add((Component)this.disablePanel, 0);
        }
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.animation.setMetaParent(this);
            this.animation.fadeIn();
            this.animation.start();
            this.add((Component)this.animation, 0);
            return false;
        }
        this.animation.stateChanged(text);
        return true;
    }

    public void udpateAnimationText(String text) {
        if (!this.ensureAnimation(text)) {
            this.animation.stateChanged(text);
        }
    }

    public void hideAnimation() {
        if (this.disablePanel != null) {
            this.disablePanel.kill();
        }
        ((DetailsParagraphLayout)this.getViewPort().getLayout()).setDisablePanel(null);
        this.disablePanel = null;
        if (this.animation != null) {
            this.animation.fadeOut(true);
        }
        this.animation = null;
        ((DetailsParagraphLayout)this.getViewPort().getLayout()).setLoadingAnimation(null);
    }

    private void install(boolean withbackground) {
        this.setOpaque(false);
        this.withBackground = withbackground;
        this.scrollPane = new ScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.viewPort = new JPanel(){

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(ScrollableBackground.this.getBackground());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.paintChildren(g2);
            }
        };
        this.scrollPane.setViewportView(this.viewPort);
        this.setInnerColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.setLayout(new Layout());
        this.add((Component)this.scrollPane, 0);
    }

    public int getViewPortWidth() {
        return (int)((double)this.scrollPane.getWidth() - this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
    }

    public JPanel getViewPort() {
        return this.viewPort;
    }

    public void addToViewPort(JComponent comp) {
        this.viewPort.add(comp);
    }

    public void setViewPortLayouter(LayoutManager layouter) {
        this.viewPort.setLayout(layouter);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.withBackground) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        g2.clip(new RoundRectangle2D.Double(1.0, 1.0, this.getWidth() - 2, this.getHeight() - 2, 5.0, 5.0));
        this.paintChildren(g2);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.scrollPane.kill();
        this.scrollPane = null;
        if (this.viewPort.getParent() != null) {
            this.viewPort.getParent().remove(this.viewPort);
        }
        this.viewPort = null;
    }

    public void setInnerColor(Color c) {
        this.scrollPane.setScrollPaneBackground(c);
        this.setBackground(c);
    }

    public ScrollPane getScrollPane() {
        return this.scrollPane;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (ScrollableBackground.this.disablePanel != null) {
                ScrollableBackground.this.disablePanel.setLocation(0, 0);
                ScrollableBackground.this.disablePanel.setSize(parent.getSize());
            }
            if (ScrollableBackground.this.animation != null) {
                ScrollableBackground.this.animation.setLocation((int)((double)parent.getWidth() - ScrollableBackground.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ScrollableBackground.this.animation.getPreferredSize().getHeight()) / 2);
                ScrollableBackground.this.animation.setSize(ScrollableBackground.this.animation.getPreferredSize());
            }
            ScrollableBackground.this.scrollPane.setLocation(1, 1);
            ScrollableBackground.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }
    }
}

