/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels.documentscan;

import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.panels.documentscan.DocumentScanPanel;
import ch.icit.pegasus.client.gui.utils.panels.documentscan.DocumentScanToolkit;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanTypeE;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.AGroupMovementAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.GroupMovementCBAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.GroupMovementPBAccess;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupLight;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class MovementDocumentScanPanel
extends DocumentScanPanel<StockMovementGroupLight> {
    public MovementDocumentScanPanel(SystemSettingsComplete settings, DocumentScanTypeE type, Node<StockMovementGroupLight> orderNode) {
        super(settings, type, orderNode);
    }

    @Override
    public void initDataNode(DocumentScanTypeE type, Node<StockMovementGroupLight> orderNode) {
        this.showAnimation("Load Scans");
        this.loadScans();
        UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        boolean hasAccess = false;
        ModuleAccessRightComplete poAccess = HUDToolkit.getCurrentAccessRight(GroupMovementCBAccess.MODULE_MOVEMENT_GROUP_CB, currentUser);
        ModuleAccessRightComplete poAccess2 = HUDToolkit.getCurrentAccessRight(GroupMovementPBAccess.MODULE_MOVEMENT_GROUP_PB, currentUser);
        for (DataFieldAccessRightComplete a : poAccess.getFieldAccessRights()) {
            if (!a.getField().getName().equals(AGroupMovementAccess.CHANGE_SCAN_DOCUMENT.getName())) continue;
            hasAccess = true;
        }
        for (DataFieldAccessRightComplete a : poAccess2.getFieldAccessRights()) {
            if (!a.getField().getName().equals(AGroupMovementAccess.CHANGE_SCAN_DOCUMENT.getName())) continue;
            hasAccess = true;
        }
        if (hasAccess) {
            this.chooseFile = new TextButton(Words.CHOOSE);
            this.chooseFile.addButtonListener((source, x, y) -> {
                File manuallySelectedFile = FileChooserUtil.loadFile();
                if (manuallySelectedFile != null) {
                    File newFile = new File(manuallySelectedFile.getParentFile().getAbsolutePath() + File.separator + "from Movement " + ((StockMovementGroupLight)orderNode.getValue(StockMovementGroupLight.class)).getNumber() + ".pdf");
                    try {
                        FileUtils.copyFile((File)manuallySelectedFile, (File)newFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        newFile = manuallySelectedFile;
                    }
                    DocumentScanComplete scan = new DocumentScanComplete();
                    scan.setClientOId(Long.valueOf(ADTO.getNextId()));
                    PegasusFileComplete pdf = new PegasusFileComplete();
                    pdf.setLocalFile(newFile);
                    pdf.setCategory(FileCategoryE.DOCUMENT);
                    pdf.setFileName(newFile.getName());
                    scan.setCreationDate(new Timestamp(System.currentTimeMillis()));
                    scan.setFileData(pdf);
                    scan.setType(type);
                    Node docNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)scan, true, false);
                    if (this.documentTable != null && this.documentTable.getModel() != null) {
                        this.documentTable.getModel().getNode().addChild(docNode, 0L);
                        Table2RowPanel panel = this.documentTable.getRowPanel4Node(docNode);
                        this.documentTable.getModel().selectRow(panel, false, true, 3);
                    }
                }
            });
            this.add(this.chooseFile);
        }
    }

    @Override
    public void loadScans() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                List<DocumentScanComplete> documentScan = DocumentScanToolkit.findDocumentScan(MovementDocumentScanPanel.this.getDefaultDocumentScanPath(), MovementDocumentScanPanel.this.type);
                if (MovementDocumentScanPanel.this.orderNode != null) {
                    DocumentScanComplete doc;
                    StockMovementGroupComplete complete = (StockMovementGroupComplete)MovementDocumentScanPanel.this.orderNode.getValue(StockMovementGroupComplete.class);
                    if (complete == null) {
                        StockMovementGroupLight light = (StockMovementGroupLight)MovementDocumentScanPanel.this.orderNode.getValue(StockMovementGroupLight.class);
                        complete = (StockMovementGroupComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStockMovementGroup(new StockMovementGroupReference(light.getId())).getValue();
                        MovementDocumentScanPanel.this.orderNode.setValue((Object)complete, 0L);
                    }
                    if ((doc = complete.getDocumentScan()) != null && doc.getFileData() != null) {
                        File file = FileTransferUtil.download((PegasusFileComplete)doc.getFileData(), (FileTransferListener[])new FileTransferListener[0]);
                        File newFile = new File(file.getParentFile().getAbsolutePath() + File.separator + "from Movement " + complete.getNumber() + ".pdf");
                        FileUtils.copyFile((File)file, (File)newFile);
                        DocumentScanComplete scan = new DocumentScanComplete();
                        scan.setClientOId(Long.valueOf(ADTO.getNextId()));
                        PegasusFileComplete pdf = new PegasusFileComplete();
                        pdf.setLocalFile(newFile);
                        pdf.setCategory(FileCategoryE.DOCUMENT);
                        pdf.setFileName(newFile.getName());
                        scan.setCreationDate(new Timestamp(System.currentTimeMillis()));
                        scan.setFileData(pdf);
                        scan.setType(MovementDocumentScanPanel.this.type);
                        documentScan.add(scan);
                    }
                }
                Node nodes = INodeCreator.getDefaultImpl().createNodes(documentScan, false);
                return nodes;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        MovementDocumentScanPanel.this.hideAnimation();
                        MovementDocumentScanPanel.this.documentTable.fadeIn();
                        MovementDocumentScanPanel.this.preview.fadeIn();
                        MovementDocumentScanPanel.this.documentTable.getModel().setNode(node);
                    }

                    public void errorOccurred(ClientException exception) {
                        MovementDocumentScanPanel.this.hideAnimation();
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)MovementDocumentScanPanel.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }
}

