/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.rightdependant;

import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.icons.impl.CheckBoxRO;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDField;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Dimension;

public class RDCheckBox
extends RDField<CheckBox, CheckBoxRO> {
    private static final long serialVersionUID = 1L;
    private ButtonListener listener;

    public RDCheckBox(RDProvider provider, Node<?> node) {
        this(provider);
        this.setNode(node);
    }

    public RDCheckBox(RDProvider provider) {
        super(provider);
    }

    @Override
    public CheckBox createEditor(Node<?> node) {
        if (node != null && node.getValue() instanceof Boolean) {
            CheckBox c = new CheckBox(node);
            if (this.listener != null) {
                c.addButtonListener(this.listener);
            }
            return c;
        }
        CheckBox b = new CheckBox();
        if (this.listener != null) {
            b.addButtonListener(this.listener);
        }
        if (node != null) {
            b.setChecked(node.getValue() != null);
        }
        b.setEnabled(this.isEnabled);
        return b;
    }

    @Override
    public Dimension getNodeLessPreferredSize() {
        int h = ((Skin1Field)DefaultSkins.CheckBoxIcon.createDynamicSkin()).getImage(Button.ButtonState.UP).getHeight();
        return new Dimension(h, h);
    }

    @Override
    public CheckBoxRO createRenderer(Node<?> node) {
        if (node != null && node.getValue() instanceof Boolean) {
            return new CheckBoxRO(node);
        }
        CheckBoxRO b = new CheckBoxRO();
        if (node != null) {
            b.setChecked(node.getValue() != null);
        } else {
            b.setChecked(false);
        }
        b.setEnabled(this.isEnabled);
        return b;
    }

    public boolean isChecked() {
        if (this.wField != null) {
            return ((CheckBox)this.wField).isChecked();
        }
        if (this.rField != null) {
            return ((CheckBoxRO)this.rField).isChecked();
        }
        return false;
    }

    public void addButtonListener(ButtonListener listener) {
        if (this.wField != null) {
            ((CheckBox)this.wField).addButtonListener(listener);
        } else {
            this.listener = listener;
        }
    }

    public void setChecked(boolean b) {
        if (this.wField != null) {
            ((CheckBox)this.wField).setChecked(b);
        }
        if (this.rField != null) {
            ((CheckBoxRO)this.rField).setChecked(b);
        }
    }
}

