/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.rightdependant;

import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.TextFieldListener;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDField;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.Comparator;

public class RDInputComboBox
extends RDField<InputComboBox, InputComboBox> {
    private static final long serialVersionUID = 1L;
    private InputComboBox.InputComboBoxType inputState;
    private DecimalFormat format;
    private boolean isMinusAllowed;
    private Node possibles;
    private Comparator defaultSorter;
    private Node defaultSortedObject;
    private int maxCommaStellen = 2;
    private boolean useMaxKommaStellen;
    private int overrideUnitWidth = -1;

    public RDInputComboBox(RDProvider provider, DecimalFormat format, InputComboBox.InputComboBoxType state) {
        super(provider);
        this.format = format;
        this.inputState = state;
    }

    public RDInputComboBox(RDProvider provider, DecimalFormat format) {
        this(provider, format, InputComboBox.InputComboBoxType.PRICE_DOUBLE);
    }

    public RDInputComboBox(RDProvider provider, InputComboBox.InputComboBoxType state) {
        this(provider, null, state);
    }

    @Override
    public Dimension getNodeLessPreferredSize() {
        int h = ((Skin3Field)DefaultSkins.TextFieldTexture.createDynamicSkin()).getImageLeft(Button.ButtonState.UP).getHeight();
        return new Dimension(h, h);
    }

    @Override
    public InputComboBox createEditor(Node<?> node) {
        InputComboBox r = null;
        r = this.format != null ? new InputComboBox(null, null, this.format, this.inputState) : new InputComboBox(null, null, this.inputState);
        r.allowMinus(this.isMinusAllowed);
        r.setProgress(1.0f);
        r.setPossibleUnits(this.possibles);
        r.setDefaultSorter(this.defaultSorter);
        r.setDefaultSorterUserObject(this.defaultSortedObject);
        r.setMaxKommaStellen(this.maxCommaStellen);
        if (this.overrideUnitWidth != -1) {
            r.setOverrideUnitWith(this.overrideUnitWidth);
        }
        r.setEnabled(this.isEnabled);
        return r;
    }

    @Override
    public InputComboBox createRenderer(Node<?> node) {
        InputComboBox r = null;
        r = this.format != null ? new InputComboBox(null, null, this.format, InputComboBox.InputComboBoxType.NONE) : new InputComboBox(null, null, InputComboBox.InputComboBoxType.NONE);
        r.setPossibleUnits(this.possibles);
        r.setDefaultSorter(this.defaultSorter);
        r.setDefaultSorterUserObject(this.defaultSortedObject);
        r.setMaxKommaStellen(this.maxCommaStellen);
        r.setUseMaxKommaStellen(this.useMaxKommaStellen);
        r.setNode(node);
        r.setEnabled(this.isEnabled);
        return r;
    }

    public void setUseMaxKommaStellen(boolean b) {
        if (this.wField != null) {
            ((InputComboBox)this.wField).setUseMaxKommaStellen(b);
        }
        this.useMaxKommaStellen = b;
    }

    public void setNode(Node value, Node unit) {
        this.ensureAccessState(value, unit);
    }

    public void ensureAccessState(Node<?> value, Node<?> unit) {
        boolean a;
        if (value == null) {
            if (this.wField != null) {
                ((InputComboBox)this.wField).kill();
                this.wField = null;
            }
            if (this.rField != null) {
                ((InputComboBox)this.rField).kill();
                this.rField = null;
            }
            return;
        }
        String name = value.getName();
        if (this.overrideName != null) {
            name = this.overrideName;
        }
        if (a = this.provider.isWritable(name)) {
            if (this.rField != null) {
                if (this.rField instanceof Killable) {
                    ((Killable)((Object)this.rField)).kill();
                    this.rField = null;
                } else {
                    this.remove(this.rField);
                    this.rField = null;
                }
            }
            if (this.wField == null) {
                this.wField = this.createEditor((Node)unit);
                ((InputComboBox)this.wField).setNode(value, unit);
                this.add(this.wField);
                if (this.wField instanceof Fadable) {
                    ((Fadable)((Object)this.wField)).fadeIn();
                }
            } else {
                ((InputComboBox)this.wField).setNode(value, unit);
            }
        } else {
            if (this.wField != null) {
                if (this.wField instanceof Killable) {
                    ((Killable)((Object)this.wField)).kill();
                    this.wField = null;
                } else {
                    this.remove(this.wField);
                    this.wField = null;
                }
            }
            if (this.rField == null) {
                this.rField = new InputComboBox(value, unit, InputComboBox.InputComboBoxType.NONE);
                ((InputComboBox)this.rField).setMaxKommaStellen(this.maxCommaStellen);
                this.add(this.rField);
                if (this.rField instanceof Fadable) {
                    ((Fadable)((Object)this.rField)).fadeIn();
                }
            } else {
                ((InputComboBox)this.rField).setNode(value, unit);
            }
        }
    }

    public void removeTextFieldListener(TextFieldListener supplierConditionDetailsPanel) {
        if (this.wField != null) {
            ((InputComboBox)this.wField).removeTextFieldListener(supplierConditionDetailsPanel);
        }
    }

    public void updateAdditional() {
        if (this.wField != null) {
            ((InputComboBox)this.wField).updateAdditional();
        }
    }

    public void setSecondUnitNode(Node childNamed) {
        if (this.wField != null) {
            ((InputComboBox)this.wField).setSecondUnitNode((Node<UnitComplete>)childNamed);
        }
        if (this.rField != null) {
            ((InputComboBox)this.rField).setSecondUnitNode((Node<UnitComplete>)childNamed);
        }
    }

    public void addTextFieldListener(TextFieldListener supplierConditionDetailsPanel) {
        if (this.wField != null) {
            ((InputComboBox)this.wField).addTextFieldListener(supplierConditionDetailsPanel);
        }
    }

    public void setMaxKommaStellen(int i) {
        if (this.wField != null) {
            ((InputComboBox)this.wField).setMaxKommaStellen(i);
        }
        this.maxCommaStellen = i;
    }

    public Node getValueNode() {
        if (this.wField != null) {
            return ((InputComboBox)this.wField).getValueNode();
        }
        if (this.rField != null) {
            return ((InputComboBox)this.rField).getValueNode();
        }
        return null;
    }

    public void allowMinus(boolean b) {
        this.isMinusAllowed = b;
        if (this.wField != null) {
            ((InputComboBox)this.wField).allowMinus(this.isMinusAllowed);
        }
    }

    public void setCurrentState(InputComboBox.InputComboBoxType stateEditPriceAndUnitDouble) {
        if (this.wField != null) {
            ((InputComboBox)this.wField).setCurrentState(stateEditPriceAndUnitDouble);
        }
    }

    public void setPossibleUnits(Node affixNamed) {
        this.possibles = affixNamed;
        if (this.wField != null) {
            ((InputComboBox)this.wField).setPossibleUnits(this.possibles);
        }
    }

    public void setDefaultSorter(Comparator comparator) {
        if (this.wField != null) {
            ((InputComboBox)this.wField).setDefaultSorter(comparator);
        }
        this.defaultSorter = comparator;
    }

    public void setDefaultSorterUserObject(Node childNamed) {
        if (this.wField != null) {
            ((InputComboBox)this.wField).setDefaultSorterUserObject(childNamed);
        }
        this.defaultSortedObject = childNamed;
    }

    public Comparator getDefaultSorter() {
        return this.defaultSorter;
    }

    public Node<?> getUnitNode() {
        if (this.wField != null) {
            return ((InputComboBox)this.wField).getUnitNode();
        }
        if (this.rField != null) {
            return ((InputComboBox)this.rField).getUnitNode();
        }
        return null;
    }

    public void setOverrideUnitWidth(int i) {
        this.overrideUnitWidth = i;
    }
}

