/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.searchbox;

import ch.icit.pegasus.client.converter.ContactConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class ContactSearchBox
extends DefaultPanel
implements SearchTextField2Listener,
RemoteLoader {
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField2> customerSearch = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(false, new DTOProxyNode()), "Customer", TitledItem.TitledItemOrientation.NORTH);
    private TitledItem<ComboBox> contactSearch = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(ContactConverter.class)), "Contact", TitledItem.TitledItemOrientation.NORTH);

    public ContactSearchBox() {
        this.customerSearch.getElement().addSearchTextFieldListener(this);
        this.setProgress(1.0f);
        this.setLayout(new Layout());
        this.add(this.customerSearch);
        this.add(this.contactSearch);
    }

    public void setNode(Node<ContactComplete> node) {
        this.contactSearch.getElement().setNode((Node)node);
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.customerSearch.getFocusComponents();
        CheckedListAdder.addToList(a, this.contactSearch);
        if (this.contactSearch.isEnabled()) {
            a.addAll(this.contactSearch.getFocusComponents());
        }
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.customerSearch.setEnabled(isEnabled);
        this.contactSearch.setEnabled(isEnabled & this.customerSearch.getElement().isItemSelected());
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        this.customerSearch.requestFocusInWindowNow();
    }

    private void reloadCustomerComplete() {
        if (this.customerSearch.getElement().getNode().getValue(CustomerComplete.class) == null) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    CustomerLight l = (CustomerLight)((SearchTextField2)ContactSearchBox.this.customerSearch.getElement()).getNode().getValue(CustomerLight.class);
                    try {
                        CustomerComplete c = (CustomerComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getCustomer((CustomerReference)l).getValue();
                        ((SearchTextField2)ContactSearchBox.this.customerSearch.getElement()).getNode().removeExistingValues();
                        ((SearchTextField2)ContactSearchBox.this.customerSearch.getElement()).getNode().setValue((Object)c, 0L);
                        return ((SearchTextField2)ContactSearchBox.this.customerSearch.getElement()).getNode();
                    }
                    catch (ClientGetFromServerException e) {
                        ViewNode r = new ViewNode("Error");
                        r.setValue((Object)e, 0L);
                        return r;
                    }
                }

                @Override
                public RemoteLoader getInvoker() {
                    return ContactSearchBox.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.remoteObjectLoaded(this.customerSearch.getElement().getNode());
        }
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        if (source.getNode().getValue() != null) {
            this.reloadCustomerComplete();
        }
    }

    public void remoteObjectLoaded(Node<?> node) {
        if (node != null) {
            this.contactSearch.getElement().refreshPossibleValues(node.getChildNamed(new String[]{"contacts"}));
            this.contactSearch.setEnabled(true);
        }
    }

    public void errorOccurred(ClientException exception) {
    }

    public ContactComplete getSelectedContact() {
        return (ContactComplete)this.contactSearch.getElement().getNode().getValue(ContactComplete.class);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)ContactSearchBox.this.customerSearch.getPreferredSize().getHeight();
            h += 5;
            h = (int)((double)h + ContactSearchBox.this.contactSearch.getPreferredSize().getHeight());
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            ContactSearchBox.this.customerSearch.setLocation(0, 0);
            ContactSearchBox.this.customerSearch.setSize(parent.getWidth(), (int)ContactSearchBox.this.customerSearch.getPreferredSize().getHeight());
            ContactSearchBox.this.contactSearch.setLocation(0, ContactSearchBox.this.customerSearch.getY() + ContactSearchBox.this.customerSearch.getHeight() + 5);
            ContactSearchBox.this.contactSearch.setSize(parent.getWidth(), (int)ContactSearchBox.this.contactSearch.getPreferredSize().getHeight());
        }
    }
}

