/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.searchfield;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.SelectionManager;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.AsynchronLoaderAnimation;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextFieldListener;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.textfield.JTextField2;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SearchTextField
extends JPanelFadable
implements LafListener,
FocusListener,
MouseListener,
Focusable,
DocumentListener,
UIStateLoadable {
    private static final long serialVersionUID = 1L;
    public AsynchronLoaderAnimation loaderAnimation;
    protected int xOffset = 0;
    private boolean isPersistable = true;
    public int minWidth = 50;
    protected List<SearchTextFieldListener> listeners = new ArrayList<SearchTextFieldListener>();
    protected JTextField textField;
    protected Skin3Field skin;
    private String id;
    private String name;
    protected String defaultText;
    protected boolean isSearchActive = false;
    protected Button.ButtonState state = Button.ButtonState.UP;
    private VisibleContainer visibleContainer;
    private boolean isDown;
    private boolean isOver;

    public SearchTextField() {
        this(DefaultSkins.SearchFieldTexture);
    }

    public SearchTextField(DefaultSkins skin) {
        this.skin = (Skin3Field)DefaultSkins.SearchFieldTexture.createDynamicSkin();
        this.textField = this.createTextField();
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.textField.setOpaque(false);
        this.getFader().setDisableWhenHidden(true);
        this.setProgress(1.0f);
        this.setFocusable(false);
        this.setOpaque(false);
        this.lafAttributeChanged("All attribues changed");
        this.addMouseListener(this);
        this.textField.addMouseListener(this);
        this.textField.addFocusListener(this);
        this.textField.getDocument().addDocumentListener(this);
        this.setLayout(new SearchTextFieldLayout());
        this.add(this.textField);
    }

    public JTextField createTextField() {
        return new JTextField2();
    }

    public void addSearchTextFieldListener(SearchTextFieldListener listener) {
        this.listeners.add(listener);
    }

    public void removeSearchTextFieldListener(SearchTextFieldListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireEvent() {
        for (SearchTextFieldListener l : this.listeners) {
            l.textChanged(this.getText(), this);
        }
    }

    @Override
    public String getPersistString() {
        return this.getText();
    }

    @Override
    public void loadState(String state, String id) {
        this.setText(state);
    }

    private void changeState(Button.ButtonState newState) {
        if (this.state != newState) {
            this.state = newState;
            this.repaint(32L);
        }
    }

    public void startAnimation() {
        if (!this.isSearchActive) {
            this.isSearchActive = true;
            if (this.loaderAnimation == null) {
                this.loaderAnimation = new AsynchronLoaderAnimation();
                this.loaderAnimation.getFader().setPermanent(true);
                this.isSearchActive = true;
                this.loaderAnimation.setProgress(0.0f);
                this.add((Component)this.loaderAnimation, 0);
                this.invalidate();
                this.validate();
            }
            this.loaderAnimation.startAnimation();
        }
    }

    public void stopAnimation() {
        if (this.isSearchActive) {
            if (this.loaderAnimation != null) {
                this.loaderAnimation.stopAnimation();
            }
            this.isSearchActive = false;
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.remove(this.textField);
        this.textField.removeMouseListener(this);
        this.textField.removeFocusListener(this);
        this.textField = null;
        this.skin = null;
        this.removeMouseListener(this);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.textField.setEnabled(isEnabled);
        if (!isEnabled) {
            this.changeState(Button.ButtonState.DISABLED);
        } else if (this.textField.hasFocus()) {
            this.changeState(Button.ButtonState.FOCUS);
        } else {
            this.changeState(Button.ButtonState.UP);
        }
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setID(String id) {
        this.id = id;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, 0, this.getWidth(), this.state);
        this.paintChildren(g2);
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, this.skin.getImageLeft(Button.ButtonState.DISABLED).getHeight());
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_searchTextField_foreground")));
        this.textField.setDisabledTextColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_disabled_color")));
        this.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_searchTextField_font_size"), LafLoader.getLafLoader().getAttribute("default_searchTextField_font_type")));
        this.setCaretColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_searchTextField_caret_color")));
        this.setSelectedTextColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_searchTextField_selected_text_color")));
        this.setSelectionColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_searchTextField_selection_color")));
    }

    @Override
    public void setForeground(Color fg) {
        if (this.textField != null) {
            this.textField.setForeground(fg);
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (this.textField != null) {
            this.textField.setBackground(bg);
        }
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public String getText() {
        return this.textField.getText();
    }

    @Override
    public void setFont(Font font) {
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    public void setCaretColor(Color cc) {
        this.textField.setCaretColor(cc);
    }

    public void setSelectedTextColor(Color c) {
        this.textField.setSelectedTextColor(c);
    }

    public void setSelectionColor(Color c) {
        this.textField.setSelectionColor(c);
    }

    public void setSelectionStart(int selectionStart) {
        this.textField.setSelectionStart(selectionStart);
    }

    public void setSelectionEnd(int selectionEnd) {
        this.textField.setSelectionEnd(selectionEnd);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.textField.getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.textField.getDocument().removeDocumentListener(listener);
    }

    public Document getDocument() {
        return this.textField.getDocument();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            SelectionManager.getSelectionManager().focusGained(this);
            this.textField.setSelectionStart(0);
            this.textField.setSelectionEnd(this.textField.getText().length());
            this.changeState(Button.ButtonState.FOCUS);
            if (!this.isDown && this.visibleContainer != null) {
                this.visibleContainer.scrollTo(this);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            if (this.isOver) {
                this.changeState(Button.ButtonState.OVER);
            } else {
                this.changeState(Button.ButtonState.UP);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED && (Button.pressedItem == null || Button.pressedItem == this)) {
            this.isOver = true;
            if (this.state != Button.ButtonState.FOCUS) {
                this.changeState(Button.ButtonState.OVER);
            }
            this.setCursor(new Cursor(2));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            this.isOver = false;
            if (this.state != Button.ButtonState.FOCUS) {
                this.changeState(Button.ButtonState.UP);
            }
            this.setCursor(new Cursor(0));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            this.isDown = true;
            Button.pressedItem = this;
            if (e.getSource() == this) {
                this.textField.requestFocusInWindow();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            this.isDown = false;
            Button.pressedItem = null;
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.add(this.textField);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.visibleContainer = pane;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireEvent();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireEvent();
    }

    @Override
    public boolean shouldPersist() {
        return this.isPersistable;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
        this.isPersistable = isPersisting;
    }

    public Skin3Field getSkin() {
        return this.skin;
    }

    public void setSkin(Skin3Field skin) {
        this.skin = skin;
    }

    private class SearchTextFieldLayout
    extends DefaultLayout {
        private SearchTextFieldLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int tailing = 0;
            if (SearchTextField.this.isSearchActive) {
                tailing = (int)SearchTextField.this.loaderAnimation.getPreferredSize().getWidth() + 5;
                SearchTextField.this.loaderAnimation.setLocation(parent.getWidth() - tailing, (int)((double)parent.getHeight() - SearchTextField.this.loaderAnimation.getPreferredSize().getHeight()) / 2);
                SearchTextField.this.loaderAnimation.setSize(SearchTextField.this.loaderAnimation.getPreferredSize());
            }
            SearchTextField.this.textField.setLocation(SearchTextField.this.getSkin().getImageLeft(Button.ButtonState.DISABLED).getWidth() + 2 + SearchTextField.this.xOffset, 3);
            SearchTextField.this.textField.setSize(parent.getWidth() - (SearchTextField.this.getSkin().getImageLeft(Button.ButtonState.DISABLED).getWidth() + SearchTextField.this.getSkin().getImageRight(Button.ButtonState.DISABLED).getWidth() + 2 + tailing), SearchTextField.this.getSkin().getImageMiddle(Button.ButtonState.DISABLED).getHeight() - 6);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(SearchTextField.this.minWidth, SearchTextField.this.getSkin().getImageLeft(Button.ButtonState.DISABLED).getHeight());
        }
    }
}

