/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.ArticlePriceCalculationConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.utils.GroupedLoader;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.BasicArticleAccess;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticlePriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticlePriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleTenderPriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleTenderPriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class ArticlePriceTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private RDProvider provider;
    private Node<UnitComplete> unitNode;
    private GroupedLoader loader;
    private boolean withCalculation;
    private boolean withCustomer;
    private boolean useTenderRights = false;
    private boolean canEditPrice;
    private boolean canEditComment;
    private boolean canEditPeriodDate;
    private boolean canEditCustomer;
    private boolean canAddVariant;
    private boolean canRemoveVariant;
    private SystemSettingsComplete settings;

    public ArticlePriceTable(boolean withTitle, RDProvider p, GroupedLoader loader) {
        this(withTitle, p, loader, false, Words.PRICES);
    }

    public ArticlePriceTable(boolean withTitle, RDProvider p, GroupedLoader loader, boolean withCustomer, String name) {
        this(withTitle, p, loader, withCustomer, true, name);
    }

    public ArticlePriceTable(boolean withTitle, RDProvider p, GroupedLoader loader, boolean withCustomer, boolean withCalculation, String name) {
        super(true, Words.ADD, withTitle, withTitle, name);
        this.provider = p;
        this.loader = loader;
        this.withCustomer = withCustomer;
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.withCalculation = withCalculation && !Boolean.TRUE.equals(this.settings.getCompany().getSolarCompanyType());
        this.setComparator((o1, o2) -> {
            if (o1.getModel().getNode().getValue() instanceof BasicArticlePriceComplete) {
                BasicArticlePriceComplete a1 = (BasicArticlePriceComplete)o1.getModel().getNode().getValue();
                BasicArticlePriceComplete a2 = (BasicArticlePriceComplete)o2.getModel().getNode().getValue();
                return a1.compareTo(a2);
            }
            BasicArticleTenderPriceComplete a1 = (BasicArticleTenderPriceComplete)o1.getModel().getNode().getValue();
            BasicArticleTenderPriceComplete a2 = (BasicArticleTenderPriceComplete)o2.getModel().getNode().getValue();
            return a1.compareTo(a2);
        });
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                ArticlePriceTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                ArticlePriceTable.this.insertNewPrice();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tk = TableColumnInfo.priceColumnWidth + 60;
        columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", tk, tk, tk));
        if (this.withCalculation) {
            columns.add(new TableColumnInfo(Words.CALCULATION, null, null, null, "", 120, 120, 120));
        }
        if (withCustomer) {
            columns.add(new TableColumnInfo(Words.CUSTOMER, null, null, null, "", 120, 120, 120));
        }
        columns.add(new TableColumnInfo(Words.COMMENT, null, null, null, "", 180, 180, 180));
        int tp = TableColumnInfo.periodColumnWidth * 2;
        columns.add(new TableColumnInfo(Words.VALIDITY, null, null, null, "", tp, tp, tp));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        int index = 1;
        if (withCalculation) {
            ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        }
        if (withCustomer) {
            ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        }
        ((TableColumnInfo)columns.get(index++)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        if (columns.size() >= index + 1) {
            ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        }
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public void insertNewPrice() {
        Node latestData = this.getModel().getNode().getChildCount() > 0 ? this.getModel().getNode().getChildAt(this.getModel().getNode().getChildCount() - 1) : null;
        BasicArticlePriceComplete np = new BasicArticlePriceComplete();
        np.setClientOId(Long.valueOf(ADTO.getNextId()));
        if (latestData != null) {
            Date d;
            Node latestDateStart = latestData.getChildNamed(new DtoField[]{BasicArticlePriceComplete_.validity, PeriodComplete_.startDate});
            Node latestDateEnd = latestData.getChildNamed(new DtoField[]{BasicArticlePriceComplete_.validity, PeriodComplete_.endDate});
            Date lastEnd = (Date)latestDateEnd.getValue();
            Date lastStart = (Date)latestDateStart.getValue();
            boolean isFuture = false;
            if (lastStart.getTime() > System.currentTimeMillis()) {
                isFuture = true;
            }
            boolean wasInfinity = false;
            if (CalendarUtil.isInfinityDate((Date)lastEnd)) {
                wasInfinity = true;
                if (isFuture) {
                    d = new Date(lastStart.getTime());
                    d = new PeriodComplete(null, d).getEndDate();
                    latestDateEnd.setValue((Object)d, 0L);
                } else {
                    d = new Date(System.currentTimeMillis());
                    d = new PeriodComplete(d, null).getStartDate();
                    d = new PeriodComplete(null, d).getEndDate();
                    latestDateEnd.setValue((Object)d, 0L);
                }
                d = new PeriodComplete(null, d).getEndDate();
            } else {
                d = lastEnd;
                d = new PeriodComplete(null, d).getEndDate();
            }
            d.setTime(d.getTime() + 2L);
            PeriodComplete period = new PeriodComplete(d, d);
            if (wasInfinity) {
                period.setEndDate(CalendarUtil.getInfinityDate());
            }
            np.setValidity(period);
        } else {
            np.setValidity(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        }
        TableRowImpl lastrow = (TableRowImpl)this.getRowAt(this.getRowCount() - 1);
        if (this.model.getNode().getParent().getParent() != null) {
            np.setArticle((BasicArticleReference)this.model.getNode().getParent().getParent().getValue());
        }
        if (lastrow != null) {
            np.setPrice(new PriceComplete((PriceComplete)lastrow.getModel().getNode().getChildNamed(BasicArticlePriceComplete_.price).getValue()));
        } else {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            np.setPrice(new PriceComplete(settings.getCurrency(), Double.valueOf(0.0)));
        }
        this.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)np, true, false), 0L);
    }

    public void setSecondUnitNode(Node<UnitComplete> unitNode) {
        this.unitNode = unitNode;
    }

    public void updateAdditional() {
        for (Table2RowPanel table2RowPanel : this.getRows()) {
            TableRowImpl r = (TableRowImpl)table2RowPanel;
            r.price.updateAdditional();
        }
    }

    public boolean getUseTenderRights() {
        return this.useTenderRights;
    }

    public void setUseTenderRights(boolean useTenderRights, boolean isNewArticle) {
        this.useTenderRights = useTenderRights;
        if (!this.useTenderRights) {
            this.canEditPrice = this.provider.isWritable(BasicArticleAccess.PRICES_PRICE) || isNewArticle;
            this.canEditComment = this.provider.isWritable(BasicArticleAccess.PRICES_COMMENT) || isNewArticle;
            this.canEditPeriodDate = this.provider.isWritable(BasicArticleAccess.PRICES_PERIOD) || isNewArticle;
            this.canEditCustomer = this.provider.isWritable(BasicArticleAccess.PRICES_CUSTOMER) || isNewArticle;
            this.canAddVariant = this.provider.isWritable(BasicArticleAccess.PRICES_ADD) || isNewArticle;
            this.canRemoveVariant = this.provider.isWritable(BasicArticleAccess.PRICES_REMOVE) || isNewArticle;
        } else {
            this.canEditPrice = this.provider.isWritable(BasicArticleAccess.TENDER_PRICES_PRICE) || isNewArticle;
            this.canEditComment = this.provider.isWritable(BasicArticleAccess.TENDER_PRICES_COMMENT) || isNewArticle;
            this.canEditPeriodDate = this.provider.isWritable(BasicArticleAccess.TENDER_PRICES_PERIOD) || isNewArticle;
            this.canEditCustomer = this.provider.isWritable(BasicArticleAccess.TENDER_PRICES_CUSTOMER) || isNewArticle;
            this.canAddVariant = this.provider.isWritable(BasicArticleAccess.TENDER_PRICES_ADD) || isNewArticle;
            this.canRemoveVariant = this.provider.isWritable(BasicArticleAccess.TENDER_PRICES_REMOVE) || isNewArticle;
        }
        this.setHasAddButton(this.canAddVariant || isNewArticle);
        this.ensureAddButton(Words.ADD, true);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private InputComboBox price;
        private TextLabel calculation;
        private TitledPeriodEditor period;
        private DeleteButton delete;
        private SearchComboBox customer;
        private TextField comment;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.price = new InputComboBox(null, null, InputComboBox.InputComboBoxType.PRICE_DOUBLE);
            this.price.setUseMaxKommaStellen(true);
            this.price.setMaxKommaStellen(3);
            this.price.setOverrideUnitWith(60);
            this.price.setNode(m.getNode().getChildNamed(new DtoField[]{BasicArticlePriceComplete_.price, PriceComplete_.price}), m.getNode().getChildNamed(new DtoField[]{BasicArticlePriceComplete_.price, PriceComplete_.currency}));
            this.price.setSecondUnitNode((Node<UnitComplete>)ArticlePriceTable.this.unitNode);
            m.getNode().getChildNamed(new DtoField[]{BasicArticlePriceComplete_.price, PriceComplete_.price}).addNodeListener((NodeListener)this);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.period = new TitledPeriodEditor(null, null, false, ArticlePriceTable.this.provider, "price-date");
            this.period.enableInfinity(false, true);
            this.period.setStartDateNode(m.getNode().getChildNamed(new DtoField[]{BasicArticlePriceComplete_.validity, PeriodComplete_.startDate}));
            this.period.setEndDateNode(m.getNode().getChildNamed(new DtoField[]{BasicArticlePriceComplete_.validity, PeriodComplete_.endDate}));
            ArticlePriceCalculationLight calculationReference = (ArticlePriceCalculationLight)this.model.getNode().getChildNamed(BasicArticlePriceComplete_.calculation).getValue();
            if (!Boolean.TRUE.equals(ArticlePriceTable.this.settings.getCompany().getSolarCompanyType())) {
                this.calculation = calculationReference != null ? new TextLabel(m.getNode().getChildNamed(BasicArticlePriceComplete_.calculation), ConverterRegistry.getConverter(ArticlePriceCalculationConverter.class)) : new TextLabel(m.getNode().getChildNamed(BasicArticlePriceComplete_.calculationName), ConverterRegistry.getConverter(StringConverter.class));
            }
            this.comment = new TextField(m.getNode().getChildNamed(BasicArticlePriceComplete_.comment));
            if (ArticlePriceTable.this.withCustomer) {
                this.customer = SearchComboBoxFactory.getCustomerSearchField(true, m.getNode().getChildNamed(BasicArticleTenderPriceComplete_.customer));
            }
            this.setLayout(new Layouter3());
            if (ArticlePriceTable.this.withCustomer) {
                this.add(this.customer);
            }
            this.add(this.delete);
            this.add(this.price);
            this.add(this.period);
            if (this.calculation != null) {
                this.add(this.calculation);
            }
            this.add(this.comment);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled && ArticlePriceTable.this.canRemoveVariant);
            this.price.setEnabled(isEnabled && ArticlePriceTable.this.canEditPrice);
            this.period.setEnabled(isEnabled && ArticlePriceTable.this.canEditPeriodDate);
            if (this.calculation != null) {
                this.calculation.setEnabled(isEnabled);
            }
            this.comment.setEnabled(isEnabled && ArticlePriceTable.this.canEditComment);
            if (this.customer != null) {
                this.customer.setEnabled(isEnabled && ArticlePriceTable.this.canEditCustomer);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getChildNamed(new DtoField[]{BasicArticlePriceComplete_.price, PriceComplete_.price}).removeNodeListener((NodeListener)this);
            this.price.kill();
            this.price = null;
            this.period.kill();
            this.period = null;
            this.delete.kill();
            this.delete = null;
            this.comment.kill();
            this.comment = null;
            if (this.calculation != null) {
                this.calculation.kill();
            }
            this.calculation = null;
            if (this.customer != null) {
                this.customer.kill();
            }
            this.customer = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.price);
            CheckedListAdder.addToList(a, this.customer);
            CheckedListAdder.addToList(a, this.comment);
            CheckedListAdder.addToList(a, this.period);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
        }

        public void valueChanged(Node<?> node) {
            if (ArticlePriceTable.this.loader != null) {
                ArticlePriceTable.this.loader.updateMe(null);
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return false;
        }

        private class Layouter3
        extends DefaultLayout {
            private Layouter3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int columnIndex = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(columnIndex++);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(columnIndex++);
                if (TableRowImpl.this.calculation != null) {
                    TableRowImpl.this.calculation.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.calculation.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.calculation.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.calculation.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(columnIndex++);
                }
                if (TableRowImpl.this.customer != null) {
                    TableRowImpl.this.customer.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customer.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.customer.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customer.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(columnIndex++);
                }
                TableRowImpl.this.comment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.comment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.comment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.comment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(columnIndex++);
                TableRowImpl.this.period.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.period.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.period.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.period.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(columnIndex++);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

