/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.RecipeCountTransactionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.RecipeCountTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class InventoryRecipeChargeCountTable
extends Table2 {
    private Node<List<RecipeCountTransactionComplete>> node = INodeCreator.getDefaultImpl().getNode4DTO(new ArrayList(), false, false);

    public InventoryRecipeChargeCountTable(final InnerPopUp2 popUp) {
        super(true, Words.ADD);
        this.setRequestFocusOnAdd(true);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                InventoryRecipeChargeCountTable.this.revalidate();
                popUp.createFocusCycle();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                RecipeCountTransactionComplete count = new RecipeCountTransactionComplete();
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                count.setQuantity(new StoreQuantityComplete(Long.valueOf(0L), settings.getDefaultRecipeUnit()));
                count.setClientOId(Long.valueOf(ADTO.getNextId()));
                InventoryRecipeChargeCountTable.this.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)count, true, false), 0L);
                popUp.createFocusCycle();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 40, Integer.MAX_VALUE, 40));
        columns.add(new TableColumnInfo(Words.COUNT, null, null, null, "", 180));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.getModel().setNode(this.node);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<RecipeComplete> recipeSearch;
        private InputComboBox2 count;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.recipeSearch = SearchTextField2Factory.getRecipeSearchField(true, m.getNode().getChildNamed(RecipeCountTransactionComplete_.recipe));
            this.recipeSearch.addSearchTextFieldListener((source, n) -> {
                Node qtyNode = this.model.getNode().getChildNamed(RecipeCountTransactionComplete_.quantity);
                qtyNode.getChildNamed(QuantityComplete_.unit).setValue((Object)((UnitComplete)n.getChildNamed(new DtoField[]{RecipeComplete_.currentVariant, RecipeVariantLight_.yield, QuantityComplete_.unit}).getValue()), 0L);
                this.initRecipeUnits(m);
            });
            this.count = new InputComboBox2(m.getNode().getChildNamed(new DtoField[]{RecipeCountTransactionComplete_.quantity, StoreQuantityComplete_.amount}), m.getNode().getChildNamed(new DtoField[]{RecipeCountTransactionComplete_.quantity, StoreQuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
            this.delete = new DeleteButton();
            this.delete.addButtonListener((source, x, y) -> m.getNode().getParent().removeChild(m.getNode(), 0L));
            this.setLayout(new Layout());
            this.add(this.recipeSearch);
            this.add(this.count);
            this.add(this.delete);
        }

        @Override
        public void requestFocusInWindowNow() {
            this.recipeSearch.requestFocusInWindowNow();
        }

        private void initRecipeUnits(Table2RowModel m) {
            List units = UnitConversionToolkit.getPossibleUnits((RecipeVariantLight)((RecipeComplete)m.getNode().getChildNamed(RecipeCountTransactionComplete_.recipe).getValue()).getCurrentVariant());
            this.count.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
            this.count.setSelectedUnit((UnitComplete)m.getNode().getChildNamed(new DtoField[]{RecipeCountTransactionComplete_.quantity, StoreQuantityComplete_.unit}).getValue());
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.recipeSearch.kill();
            this.count.kill();
            this.delete.kill();
            this.recipeSearch = null;
            this.count = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.recipeSearch);
            CheckedListAdder.addToList(focusList, this.count);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.recipeSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.recipeSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.recipeSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.recipeSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.count.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.count.getPreferredSize().getHeight());
                TableRowImpl.this.setControlsX(currentX += w);
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

