/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.PurchasePriceFactorConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.CostCalculationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.article.details.utils.CostRowPriceConverter;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PurchasePriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorComplete;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public class MaterialCostTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private JComponent parentComponent;
    private CostCalculationDetailsPanel costPanel;
    private RDProvider provider;
    private boolean tender = false;
    private boolean canRemoveFactor;
    private boolean canEditFactor;
    private boolean canEditAmount;
    private boolean canEditComment;

    public MaterialCostTable(JComponent parentComponent, RDProvider provider, CostCalculationDetailsPanel costPanel, boolean tender) {
        super(true, Words.ADD, false, false);
        this.provider = provider;
        this.parentComponent = parentComponent;
        this.costPanel = costPanel;
        this.setProvider(provider);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                MaterialCostTable.this.writeNumbers();
                MaterialCostTable.this.ensureSelectables();
                MaterialCostTable.this.enableAddButton(true);
                MaterialCostTable.this.parentComponent.validate();
                MaterialCostTable.this.costPanel.getLoader().updateMe(MaterialCostTable.this.costPanel.getTotalPrice());
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                if (MaterialCostTable.this.getModel().getNode() == null) {
                    return;
                }
                PurchasePriceFactorComplete newFactor = MaterialCostTable.this.getFreeFactor();
                if (newFactor == null) {
                    return;
                }
                MaterialCostFactorComplete m = new MaterialCostFactorComplete();
                m.setClientOId(Long.valueOf(ADTO.getNextId()));
                m.setNumber(Integer.valueOf(MaterialCostTable.this.getRowCount() + 1));
                m.setPurchasePriceFactor(MaterialCostTable.this.getFreeFactor());
                m.setValue(m.getPurchasePriceFactor().getDefaultValue());
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)m, true, false);
                MaterialCostTable.this.getModel().getNode().addChild(n, System.currentTimeMillis());
                MaterialCostTable.this.ensureAddButton();
                MaterialCostTable.this.ensureSelectables();
                MaterialCostTable.this.parentComponent.validate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.FACTOR, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", 70, 70, 70));
        if (!tender) {
            columns.add(new TableColumnInfo(Words.COST, null, null, null, "", 70, 70, 70));
        }
        columns.add(new TableColumnInfo(Words.COMMENT, null, null, null, "", 180, 180, 180));
        int tw = this.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        if (tender) {
            ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        } else {
            ((TableColumnInfo)columns.get(0)).setxExpand(0.4);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.3);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.3);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        }
        this.setModel(new Table2Model(columns, model1 -> new CostCalculationTableRowImpl(model1, this.costPanel)));
        if (this.getFreeFactor() == null) {
            this.enableAddButton(false);
        } else {
            this.enableAddButton(true);
        }
    }

    public void setTender(boolean tender, boolean isNewArticle) {
        this.tender = tender;
        if (!this.tender) {
            this.canRemoveFactor = this.provider.isWritable(BasicArticleLight_.materialCostFactorVariants.getFieldName() + "-removefactor") || isNewArticle;
            this.canEditFactor = this.provider.isWritable(BasicArticleLight_.materialCostFactorVariants.getFieldName() + "-factor") || isNewArticle;
            this.canEditAmount = this.provider.isWritable(BasicArticleLight_.materialCostFactorVariants.getFieldName() + "-amount") || isNewArticle;
            this.canEditComment = this.provider.isWritable(BasicArticleLight_.materialCostFactorVariants.getFieldName() + "-comment") || isNewArticle;
        } else {
            this.canRemoveFactor = this.provider.isWritable(BasicArticleLight_.materialCostFactorTenderVariants.getFieldName() + "-removefactor") || isNewArticle;
            this.canEditFactor = this.provider.isWritable(BasicArticleLight_.materialCostFactorTenderVariants.getFieldName() + "-factor") || isNewArticle;
            this.canEditAmount = this.provider.isWritable(BasicArticleLight_.materialCostFactorTenderVariants.getFieldName() + "-amount") || isNewArticle;
            this.canEditComment = this.provider.isWritable(BasicArticleLight_.materialCostFactorTenderVariants.getFieldName() + "-comment") || isNewArticle;
        }
    }

    public void ensureAddButton() {
        if (this.getFreeFactor() == null) {
            this.enableAddButton(false);
        } else {
            this.enableAddButton(true);
        }
    }

    private void writeNumbers() {
        int count = 1;
        long currentID = System.currentTimeMillis();
        for (Table2RowPanel p : this.getRows()) {
            p.getModel().getNode().getChildNamed(new String[]{"number"}).setValue((Object)count, currentID);
            ++count;
        }
    }

    public void ensureSelectables() {
        Node n = NodeToolkit.getAffixList(PurchasePriceFactorComplete.class);
        ArrayList<Node> possibleValues = new ArrayList<Node>();
        Iterator it = n.getChilds();
        while (it.hasNext()) {
            Node q = (Node)it.next();
            boolean found = false;
            for (Table2RowPanel p : this.getRows()) {
                if (!((MaterialCostFactorComplete)p.getModel().getNode().getValue()).getPurchasePriceFactor().equals(q.getValue())) continue;
                found = true;
            }
            if (!found) continue;
            possibleValues.add(q);
        }
        for (Table2RowPanel p : this.getRows()) {
            CostCalculationTableRowImpl pp = (CostCalculationTableRowImpl)p;
            pp.updateSelectables(possibleValues);
        }
    }

    private PurchasePriceFactorComplete getFreeFactor() {
        Node n = NodeToolkit.getAffixList(PurchasePriceFactorComplete.class);
        Iterator it = n.getChilds();
        while (it.hasNext()) {
            Node q = (Node)it.next();
            boolean found = false;
            for (Table2RowPanel p : this.getRows()) {
                if (p.getModel().getNode().getValue() == null || ((MaterialCostFactorComplete)p.getModel().getNode().getValue()).getPurchasePriceFactor() == null || !((MaterialCostFactorComplete)p.getModel().getNode().getValue()).getPurchasePriceFactor().equals(q.getValue())) continue;
                found = true;
            }
            if (found) continue;
            return (PurchasePriceFactorComplete)q.getValue();
        }
        return null;
    }

    class CostCalculationTableRowImpl
    extends Table2RowPanel
    implements NodeListener,
    ButtonListener,
    ItemListener {
        private static final long serialVersionUID = 1L;
        private ComboBox costName;
        private TextField amount;
        private TextLabel amountUnit;
        private ReloadablePriceView result;
        private DeleteButton delete;
        private CostCalculationDetailsPanel panel;
        private TextField comment;

        public CostCalculationTableRowImpl(Table2RowModel m, CostCalculationDetailsPanel p) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.panel = p;
            this.costName = new ComboBox(m.getNode().getChildNamed(new String[]{"purchasePriceFactor"}), NodeToolkit.getAffixList(PurchasePriceFactorComplete.class), ConverterRegistry.getConverter(PurchasePriceFactorConverter.class));
            this.costName.addItemListener(this);
            this.costName.setProgress(1.0f);
            this.amount = new TextField(m.getNode().getChildNamed(new String[]{"value"}), TextFieldType.DOUBLE);
            m.getNode().getChildNamed(new String[]{"value"}).addNodeListener((NodeListener)this);
            this.amountUnit = new TextLabel(Words.PERCENT_POSTFIX);
            this.comment = new TextField(m.getNode().getChildNamed(MaterialCostFactorComplete_.comment));
            CostRowPriceConverter viewConverter = (CostRowPriceConverter)ConverterRegistry.getConverter(CostRowPriceConverter.class);
            if (!MaterialCostTable.this.tender) {
                this.result = new ReloadablePriceView((LoadingGroup)this.panel.getLoader(), viewConverter);
            }
            this.setLayout(new Layouter());
            if (!MaterialCostTable.this.tender) {
                this.panel.getLoader().addFactor(this.result);
            }
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setCalc();
            if (!MaterialCostTable.this.tender) {
                this.panel.getLoader().updateMe(this.result);
            }
            this.add(this.costName);
            this.add(this.amount);
            this.add(this.amountUnit);
            if (!MaterialCostTable.this.tender) {
                this.add(this.result);
            }
            this.add(this.delete);
            this.add(this.comment);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.costName.getStringValue();
                }
                case 1: {
                    return this.amount.getStringValue();
                }
                case 2: {
                    return this.comment.getStringValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.costName.setEnabled(isEnabled && MaterialCostTable.this.canEditFactor);
            this.amount.setEnabled(isEnabled && MaterialCostTable.this.canEditAmount);
            this.amountUnit.setEnabled(isEnabled);
            if (!MaterialCostTable.this.tender) {
                this.result.setEnabled(isEnabled);
            }
            this.delete.setEnabled(isEnabled && MaterialCostTable.this.canRemoveFactor);
            this.comment.setEnabled(isEnabled && MaterialCostTable.this.canEditComment);
        }

        public void updateSelectables(ArrayList l) {
            this.costName.updateSelectableValues(l);
        }

        private void setCalc() {
            if (MaterialCostTable.this.tender) {
                return;
            }
            CalculationRunnable run = new CalculationRunnable(){

                @Override
                public void run() {
                    if (CostCalculationTableRowImpl.this.panel.isTemplate()) {
                        return;
                    }
                    CostCalculationTableRowImpl.this.model.getNode().commit(MaterialCostFactorComplete.class);
                    MaterialCostFactorComplete matFac = (MaterialCostFactorComplete)CostCalculationTableRowImpl.this.model.getNode().getValue(MaterialCostFactorComplete.class);
                    PriceComplete p = null;
                    p = ArticlePriceCalculationToolkit.getMaterialPrice((Double)CostCalculationTableRowImpl.this.panel.getUserPrice(), (MaterialCostFactorComplete)matFac, (CurrencyComplete)CostCalculationTableRowImpl.this.panel.getConverter().getHomeBaseCurrency());
                    if (p != null) {
                        Node pn = CostCalculationTableRowImpl.this.result.getNode();
                        if (pn == null) {
                            pn = new EmbeddedDTONode();
                            CostCalculationTableRowImpl.this.result.setNode(pn);
                        }
                        pn.setValue((Object)p, 0L);
                    }
                }

                @Override
                public boolean isAlive() {
                    return !CostCalculationTableRowImpl.this.result.isKilled();
                }
            };
            this.result.setRunnable(run);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getChildNamed(new String[]{"value"}).removeNodeListener((NodeListener)this);
            this.panel.getLoader().removeFactor(this.result);
            this.costName.kill();
            this.amount.kill();
            this.amountUnit.kill();
            if (!MaterialCostTable.this.tender) {
                this.result.kill();
            }
            this.delete.kill();
            this.comment.kill();
            this.costName = null;
            this.amount = null;
            this.amountUnit = null;
            this.result = null;
            this.delete = null;
            this.comment = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.costName);
            CheckedListAdder.addToList(a, this.amount);
            CheckedListAdder.addToList(a, this.comment);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.costName.requestFocusInWindowNow();
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public void valueChanged(Node<?> node) {
            this.panel.getLoader().updateMe(this.result);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        public boolean isSwingOnly() {
            return true;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Node n = (Node)e.getItem();
            PurchasePriceFactorComplete f = (PurchasePriceFactorComplete)n.getValue();
            this.model.getNode().getChildNamed(new String[]{"value"}).setValue((Object)f.getDefaultValue(), 0L);
        }

        private class Layouter
        extends DefaultLayout {
            private Layouter() {
            }

            @Override
            public void layoutContainer(Container parent) {
                CostCalculationTableRowImpl p = (CostCalculationTableRowImpl)parent;
                int currentX = 0;
                int w = p.model.getParentModel().getColumnWidth(0);
                p.costName.setLocation(currentX + p.getCellPadding(), (int)(((double)parent.getHeight() - p.costName.getPreferredSize().getHeight()) / 2.0));
                p.costName.setSize(w - (p.getCellPadding() + p.getCellPadding()), (int)p.costName.getPreferredSize().getHeight());
                currentX += w;
                w = p.model.getParentModel().getColumnWidth(1);
                p.amount.setLocation(currentX + p.getCellPadding(), (int)(((double)parent.getHeight() - p.amount.getPreferredSize().getHeight()) / 2.0));
                p.amount.setSize((int)((double)w - ((double)(3 * p.getCellPadding()) + p.amountUnit.getPreferredSize().getWidth())), (int)p.amount.getPreferredSize().getHeight());
                p.amountUnit.setLocation(p.amount.getX() + p.amount.getWidth() + p.getCellPadding(), (int)(((double)parent.getHeight() - p.amountUnit.getPreferredSize().getHeight()) / 2.0));
                p.amountUnit.setSize(p.amountUnit.getPreferredSize());
                currentX += w;
                w = p.model.getParentModel().getColumnWidth(2);
                if (!MaterialCostTable.this.tender) {
                    p.result.setLocation(currentX + p.getCellPadding(), (int)(((double)parent.getHeight() - p.result.getPreferredSize().getHeight()) / 2.0));
                    p.result.setSize(w - 2 * p.getCellPadding(), (int)p.result.getPreferredSize().getHeight());
                    currentX += w;
                    w = p.model.getParentModel().getColumnWidth(3);
                }
                p.comment.setLocation(currentX + p.getCellPadding(), (int)(((double)parent.getHeight() - p.comment.getPreferredSize().getHeight()) / 2.0));
                p.comment.setSize(w - 2 * p.getCellPadding(), (int)p.comment.getPreferredSize().getHeight());
                currentX += w;
                w = !MaterialCostTable.this.tender ? p.model.getParentModel().getColumnWidth(4) : p.model.getParentModel().getColumnWidth(3);
                p.setControlsX(currentX);
                p.delete.setLocation(currentX + p.getCellPadding(), (int)(((double)parent.getHeight() - p.delete.getPreferredSize().getHeight()) / 2.0));
                p.delete.setSize(p.delete.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                CostCalculationTableRowImpl p = (CostCalculationTableRowImpl)parent;
                return new Dimension(0, p.getDefaultRowHeight());
            }
        }
    }
}

