/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.BasicArticleNutritionStateConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleNutritionStateHistoryComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class NutritionHistoryTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public NutritionHistoryTable() {
        super(false, "", false, false, "");
        this.setSortDirection(false);
        this.setSortedColumn(0);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int dateTimeColumnWidth = TableColumnInfo.dateTimeColumnWidth + 2 * this.getCellPadding();
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", dateTimeColumnWidth, dateTimeColumnWidth, dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.OLD_STATE, null, null, null, "", 100, Integer.MAX_VALUE, 120));
        columns.add(new TableColumnInfo(Words.NEW_STATE, null, null, null, "", 100, Integer.MAX_VALUE, 120));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.5);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel date;
        private TextLabel oldState;
        private TextLabel newState;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.date = new TextLabel(m.getNode().getChildNamed(BasicArticleNutritionStateHistoryComplete_.perfomedAt), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.oldState = new TextLabel(m.getNode().getChildNamed(BasicArticleNutritionStateHistoryComplete_.oldState), ConverterRegistry.getConverter(BasicArticleNutritionStateConverter.class));
            this.newState = new TextLabel(m.getNode().getChildNamed(BasicArticleNutritionStateHistoryComplete_.newState), ConverterRegistry.getConverter(BasicArticleNutritionStateConverter.class));
            this.setLayout(new Layout3());
            this.add(this.date);
            this.add(this.oldState);
            this.add(this.newState);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.date.kill();
            this.oldState.kill();
            this.newState.kill();
            this.date = null;
            this.oldState = null;
            this.newState = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(BasicArticleNutritionStateHistoryComplete_.perfomedAt).getValue();
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.date.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.oldState.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.oldState.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.oldState.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.oldState.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.newState.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.newState.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.newState.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.newState.getPreferredSize().getHeight());
            }
        }
    }
}

