/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultTablePopupInsert;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.tables.UserSearchTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.ordering.approval.PurchaseApprovalEntryComplete;
import ch.icit.pegasus.server.core.dtos.ordering.approval.PurchaseApprovalEntryComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PurchaseApprovalEntryTable
extends Table2
implements Nodable {
    private static final long serialVersionUID = 1L;

    public PurchaseApprovalEntryTable() {
        super(true, Words.ADD, false, false, "Purchase Approval");
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                PurchaseApprovalEntryTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                PurchaseApprovalEntryComplete entry = new PurchaseApprovalEntryComplete();
                entry.setApprovalPrice(new PriceComplete(settings.getCurrency(), Double.valueOf(0.0)));
                entry.setApprovalCountNeeded(Integer.valueOf(1));
                entry.setClientOId(Long.valueOf(ADTO.getNextId()));
                PurchaseApprovalEntryTable.this.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)entry, true, false), 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.COUNT, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.USER, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    @Override
    public void setNode(Node<?> node) {
        this.getModel().setNode(node);
    }

    @Override
    public Node<?> getNode() {
        return this.getModel().getNode();
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private InputComboBox2 approvalPrice;
        private TextField approvalCount;
        private EditButton approvalUsers;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.approvalPrice = new InputComboBox2(m.getNode().getChildNamed(new DtoField[]{PurchaseApprovalEntryComplete_.approvalPrice, PriceComplete_.price}), m.getNode().getChildNamed(new DtoField[]{PurchaseApprovalEntryComplete_.approvalPrice, PriceComplete_.currency}), InputComboBox.InputComboBoxType.PRICE_DOUBLE);
            this.approvalCount = new TextField(m.getNode().getChildNamed(PurchaseApprovalEntryComplete_.approvalCountNeeded), TextFieldType.INT);
            this.approvalUsers = new EditButton();
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.approvalUsers.addButtonListener((source, x, y) -> {
                InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
                pop.setAttributes(PurchaseApprovalEntryTable.this, true, true, Words.USER);
                UserSearchTable userSearchTable = new UserSearchTable();
                userSearchTable.getModel().setNode(m.getNode().getChildNamed(PurchaseApprovalEntryComplete_.approvalUsers));
                DefaultTablePopupInsert<UserSearchTable> view = new DefaultTablePopupInsert<UserSearchTable>(userSearchTable);
                pop.setView(view);
                pop.showPopUpWithinScreenMiddle(700, 300, (source2, args) -> {}, PurchaseApprovalEntryTable.this, PopupType.NORMAL);
            });
            this.setLayout(new Layout3());
            this.add(this.approvalPrice);
            this.add(this.approvalCount);
            this.add(this.approvalUsers);
            this.add(this.delete);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        @Override
        public boolean isInnerComponent(Component c) {
            return super.isInnerComponent(c);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.approvalPrice.kill();
            this.approvalCount.kill();
            this.approvalUsers.kill();
            this.delete.kill();
            this.approvalPrice = null;
            this.approvalCount = null;
            this.approvalUsers = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.approvalPrice);
            CheckedListAdder.addToList(a, this.approvalCount);
            CheckedListAdder.addToList(a, this.approvalUsers);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.approvalPrice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.approvalPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.approvalPrice.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.approvalPrice.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.approvalCount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.approvalCount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.approvalCount.setSize(TableRowImpl.this.approvalCount.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.approvalUsers.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.approvalUsers.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.approvalUsers.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.approvalUsers.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

