/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.searcher.searchfieldimpls;

import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.MiniComboBox;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.BasicArticleSearchAlgorithm;
import ch.icit.pegasus.client.searcher.SearchFieldSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchTypeE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.utils.BarcodeType;
import ch.icit.utils.GTINCategory;
import ch.icit.utils.builder.BarcodeBuilder;

public class BasicArticleKanbanSearchFieldRemoteSearchAlgorithm
extends SearchFieldSearchAlgorithm<BasicArticleSearchAlgorithm, BasicArticleLight> {
    private MiniComboBox miniComboBox;

    public BasicArticleKanbanSearchFieldRemoteSearchAlgorithm() {
        super(SearchAlgorithmRegistry.getSearchAlgorithm(BasicArticleSearchAlgorithm.class));
    }

    public void setMiniComboBox(MiniComboBox miniComboBox) {
        this.miniComboBox = miniComboBox;
    }

    @Override
    public ASearchConfiguration<BasicArticleLight, ? extends Enum<?>> getInternalSearchParameters(Object ... xargs) {
        String t = (String)xargs[0];
        if (t.length() < 12) {
            return null;
        }
        BasicArticleSearchConfiguration c = new BasicArticleSearchConfiguration();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        Integer articleNumber = BarcodeBuilder.getBuilder().readContentAsInteger(t, settings.getCompanyCode(), GTINCategory.ARTICLE, BarcodeType.EAN_13, true);
        if (articleNumber != null) {
            c.setNumber(articleNumber);
        }
        c.setNumResults(((BasicArticleSearchAlgorithm)this.searchAlgorithm).getNumberOfShownResults());
        if (this.miniComboBox != null) {
            BasicArticleSearchTypeE type = (BasicArticleSearchTypeE)this.miniComboBox.getSelectedItem();
            if (type == null) {
                c.setSearchType(BasicArticleSearchTypeE.ALL);
            } else {
                c.setSearchType(type);
            }
        }
        return c;
    }
}

