/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.searcher.searchfieldimpls;

import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.IngredientSearchAlgorithm;
import ch.icit.pegasus.client.searcher.SearchFieldSearchAlgorithm;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.exception.SearchException;
import ch.icit.pegasus.server.core.dtos.masterdata.CommodityLight;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.search.CommoditySearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import java.sql.Date;
import java.util.Iterator;

public class IngredientSearchFieldRemoteSearchAlgorithm
extends SearchFieldSearchAlgorithm<IngredientSearchAlgorithm, CommodityLight> {
    public IngredientSearchFieldRemoteSearchAlgorithm() {
        super(SearchAlgorithmRegistry.getSearchAlgorithm(IngredientSearchAlgorithm.class));
    }

    @Override
    public ASearchConfiguration<CommodityLight, ? extends Enum<?>> getInternalSearchParameters(Object ... xargs) {
        Object[] o;
        CommoditySearchConfiguration c = new CommoditySearchConfiguration();
        String t = (String)xargs[0];
        try {
            int i = Integer.valueOf(t);
            c.setNumber(Integer.valueOf(i));
            c.setName(null);
        }
        catch (NumberFormatException e) {
            c.setNumber(null);
            c.setName(t);
        }
        c.setNumResults(((IngredientSearchAlgorithm)this.searchAlgorithm).getNumberOfShownResults());
        if (xargs.length >= 2 && xargs[1] instanceof Object[] && (o = (Object[])xargs[1]).length >= 1 && o[0] instanceof Node) {
            if (((Node)o[0]).getValue() instanceof PeriodComplete) {
                Node periodNode = (Node)o[0];
                c.setPeriod(new PeriodComplete((PeriodComplete)periodNode.getValue()));
            } else if (((Node)o[0]).getValue() instanceof Date) {
                Date d = (Date)((Node)o[0]).getValue();
                c.setPeriod(new PeriodComplete(new Date(d.getTime()), new Date(d.getTime())));
            }
        }
        return c;
    }

    @Override
    public ViewNode<SearchResult<CommodityLight>> search(ASearchConfiguration<CommodityLight, ? extends Enum<?>> conf) throws SearchException, ClientServerCallException {
        ViewNode<SearchResult<CommodityLight>> ret = super.search(conf);
        Iterator it = ((SearchResult)ret.getValue()).getResults().iterator();
        while (it.hasNext()) {
            CommodityLight c = (CommodityLight)it.next();
            if (!(c instanceof RecipeVariantLight)) continue;
            RecipeVariantLight rv = (RecipeVariantLight)c;
            CommoditySearchConfiguration cc = (CommoditySearchConfiguration)conf;
            if (cc.getPeriod() == null || cc.getPeriod().within(rv.getValidityPeriod().getStartDate()).booleanValue() || cc.getPeriod().within(rv.getValidityPeriod().getEndDate()).booleanValue() || rv.getValidityPeriod().getStartDate().getTime() <= cc.getPeriod().getStartDate().getTime() && rv.getValidityPeriod().getEndDate().getTime() >= cc.getPeriod().getEndDate().getTime()) continue;
            it.remove();
        }
        return ret;
    }
}

