/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.gui.modules.productcatalog.details.utils.ProductEntryComparator;
import ch.icit.pegasus.client.gui.modules.productcatalog.details.utils.ProductGroupEntryComparator;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.AMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.CatalogEntryComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogProductGroupComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogTypeE;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProductCatalogToolkit {
    public static List<ProductCatalogProductGroupComplete> createProductCatalogGroups(List<ProductVariantLight> products, ProductCatalogTypeE type, List<ScreenValidationObject> warningsList) {
        Hashtable<CateringServiceTypeComplete, ProductCatalogProductGroupComplete> map = new Hashtable<CateringServiceTypeComplete, ProductCatalogProductGroupComplete>();
        ProductCatalogProductGroupComplete nullList = new ProductCatalogProductGroupComplete();
        switch (type) {
            case ALACARTE: {
                break;
            }
            case SPML: {
                nullList.setName(Words.ADDITIONAL);
                break;
            }
            case STANDARD: {
                nullList.setName(Words.UNDEFINED);
                break;
            }
        }
        nullList.setClientOId(Long.valueOf(ADTO.getNextId()));
        nullList.setSequenceNumber(Integer.valueOf(1));
        int groupCount = 1;
        for (ProductVariantLight p : products) {
            if (!p.getServiceTypes().isEmpty()) {
                CateringServiceTypeComplete t = (CateringServiceTypeComplete)p.getServiceTypes().get(0);
                ProductCatalogProductGroupComplete cGroup = (ProductCatalogProductGroupComplete)map.get(t);
                if (cGroup == null) {
                    cGroup = new ProductCatalogProductGroupComplete();
                    cGroup.setClientOId(Long.valueOf(ADTO.getNextId()));
                    cGroup.setName(t.getCode());
                    cGroup.setSequenceNumber(Integer.valueOf(groupCount));
                    map.put(t, cGroup);
                    ++groupCount;
                }
                CatalogEntryComplete cEntry = new CatalogEntryComplete();
                cEntry.setClientOId(Long.valueOf(ADTO.getNextId()));
                cEntry.setProduct(p.getProduct());
                cEntry.setSequenceNumber(Integer.valueOf(cGroup.getEntries().size() + 1));
                cGroup.getEntries().add(cEntry);
                continue;
            }
            if (type == ProductCatalogTypeE.ALACARTE) {
                warningsList.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "The a la Carte Product " + p.getProduct().getNumber() + " - " + p.getName() + " hasn't a Serivce Type defined. Skipt Product."));
                continue;
            }
            if (type == ProductCatalogTypeE.SPML && !ProductCatalogToolkit.isAdditional(p.getMenuTypes())) {
                warningsList.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "The SPML Product " + p.getProduct().getNumber() + " - " + p.getName() + " hasn't a Serivce Type defined and isn't a additional SPML. Skipt Product."));
                continue;
            }
            CatalogEntryComplete cEntry = new CatalogEntryComplete();
            cEntry.setClientOId(Long.valueOf(ADTO.getNextId()));
            cEntry.setProduct(p.getProduct());
            cEntry.setSequenceNumber(Integer.valueOf(nullList.getEntries().size() + 1));
            nullList.getEntries().add(cEntry);
        }
        ArrayList<ProductCatalogProductGroupComplete> groups = new ArrayList<ProductCatalogProductGroupComplete>();
        Set set = map.entrySet();
        for (Map.Entry e : set) {
            groups.add((ProductCatalogProductGroupComplete)e.getValue());
        }
        if (nullList.getEntries().size() > 0) {
            groups.add(nullList);
        }
        Collections.sort(groups, new ProductGroupEntryComparator());
        int count = 1;
        for (ProductCatalogProductGroupComplete g : groups) {
            g.setSequenceNumber(Integer.valueOf(count));
            ++count;
            Collections.sort(g.getEntries(), new ProductEntryComparator());
            int count2 = 1;
            for (CatalogEntryComplete e : g.getEntries()) {
                e.setSequenceNumber(Integer.valueOf(count2));
                ++count2;
            }
        }
        return groups;
    }

    private static boolean isAdditional(List<AMenuTypeComplete> menuTypes) {
        for (AMenuTypeComplete aMenuTypeComplete : menuTypes) {
            SpecialMenuTypeComplete t;
            if (!(aMenuTypeComplete instanceof SpecialMenuTypeComplete) || !Boolean.TRUE.equals((t = (SpecialMenuTypeComplete)aMenuTypeComplete).getAdditional())) continue;
            return true;
        }
        return false;
    }
}

