/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.utils.recipe;

import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.recipe.CompoundIngredientComplete;
import ch.icit.pegasus.server.core.dtos.recipe.ICompoundIngredient;
import ch.icit.pegasus.server.core.dtos.recipe.IIngredient;
import ch.icit.pegasus.server.core.dtos.recipe.IRecipe;
import ch.icit.pegasus.server.core.dtos.recipe.ISimpleIngredient;
import ch.icit.pegasus.server.core.dtos.recipe.InterpolationStepComplete;
import ch.icit.pegasus.server.core.dtos.recipe.LinearQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.QuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.StepQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.DTOUtilException;
import ch.icit.pegasus.server.core.dtos.utils.InterpolationStepComparator;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.recipe.CalculatedBasicArticleIngredient;
import ch.icit.pegasus.server.core.dtos.utils.recipe.CalculatedIngredient;
import ch.icit.pegasus.server.core.dtos.utils.recipe.CalculatedRecipe;
import ch.icit.pegasus.server.core.dtos.utils.recipe.CalculatedRecipeIngredient;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RecipeCalculationToolkit {
    private static Comparator<InterpolationStepComplete> interPolationStepComparator;

    public static CalculatedRecipe calculateRecipeIngredients(IRecipe recipeVariant, QuantityComplete targetQuantity, CurrencyComplete targetCurrency, CurrencyVariantAccessor accessor, RecipeVariantAccessor recipeAccessor, Timestamp validityDate, CustomerReference customer, boolean useTender) throws Exception {
        CalculatedRecipe calcRecipe = new CalculatedRecipe();
        calcRecipe.setRecipeVariant(recipeVariant);
        calcRecipe.setQuantity(targetQuantity);
        double recipePrice = 0.0;
        ArrayList<CalculatedIngredient> calcIngredients = new ArrayList<CalculatedIngredient>();
        for (IIngredient ingredient : recipeVariant.getIngredients()) {
            CalculatedIngredient calcIngredient;
            QuantityComplete ingredientQuantity = UnitConversionToolkit.normalizeQuantity(RecipeCalculationToolkit.getIngredientQuantity(ingredient, recipeVariant.getYield(), targetQuantity));
            PriceComplete price = new PriceComplete(targetCurrency, Double.valueOf(RecipeCalculationToolkit.getIngredientPrice(ingredient, ingredientQuantity, targetCurrency, accessor, recipeAccessor, validityDate, customer, useTender)));
            if (ingredient instanceof ISimpleIngredient) {
                BasicArticleComplete article = ((ISimpleIngredient)ingredient).getArticle();
                CalculatedBasicArticleIngredient cbai = new CalculatedBasicArticleIngredient();
                cbai.setArticle((BasicArticleLight)article);
                calcIngredient = cbai;
            } else if (ingredient instanceof ICompoundIngredient) {
                CalculatedRecipeIngredient cri = new CalculatedRecipeIngredient();
                IRecipe r = (IRecipe)recipeAccessor.loadData(((ICompoundIngredient)ingredient).getUnderlyingRecipe(), validityDate);
                cri.setRecipe(RecipeCalculationToolkit.calculateRecipeIngredients(r, ingredientQuantity, targetCurrency, accessor, recipeAccessor, validityDate, customer, useTender));
                calcIngredient = cri;
            } else {
                throw new DTOUtilException("Invalid Ingredient type: " + ingredient.getClass().getSimpleName());
            }
            calcIngredient.setQuantity(ingredientQuantity);
            calcIngredient.setPrice(price);
            calcIngredient.setIngredient(ingredient);
            calcIngredients.add(calcIngredient);
            recipePrice += price.getPrice().doubleValue();
        }
        calcRecipe.setIngredients(calcIngredients);
        calcRecipe.setPrice(new PriceComplete(targetCurrency, Double.valueOf(recipePrice)));
        return calcRecipe;
    }

    public static PriceComplete getPrice(RecipeVariantComplete recipe, QuantityComplete targetQuantity, CurrencyComplete targetCurrency, CurrencyVariantAccessor accessor, RecipeVariantAccessor recipeAccessor, Timestamp validityDate, CustomerReference customer, boolean useTender) throws Exception {
        return new PriceComplete(targetCurrency, Double.valueOf(RecipeCalculationToolkit.getRecipePrice((IRecipe)recipe, targetQuantity, targetCurrency, accessor, recipeAccessor, validityDate, customer, useTender)));
    }

    private static double getRecipePrice(IRecipe recipe, QuantityComplete targetQuantity, CurrencyComplete targetCurrency, CurrencyVariantAccessor accessor, RecipeVariantAccessor recipeAccessor, Timestamp validityDate, CustomerReference customer, boolean useTender) throws Exception {
        RecipeVariantComplete rv = recipe instanceof RecipeVariantComplete ? (RecipeVariantComplete)recipe : (recipe instanceof CompoundIngredientComplete ? (RecipeVariantComplete)recipeAccessor.loadData(((CompoundIngredientComplete)recipe).getRecipe(), validityDate) : (RecipeVariantComplete)recipeAccessor.loadData((RecipeComplete)recipe, validityDate));
        QuantityComplete yieldQuantity = rv.getYield();
        double value = 0.0;
        for (IIngredient ingredient : rv.getIngredients()) {
            QuantityComplete ingredientQuantity = RecipeCalculationToolkit.getIngredientQuantity(ingredient, yieldQuantity, targetQuantity);
            if (ingredientQuantity == null) continue;
            value += RecipeCalculationToolkit.getIngredientPrice(ingredient, ingredientQuantity, targetCurrency, accessor, recipeAccessor, validityDate, customer, useTender);
        }
        return value;
    }

    public static QuantityComplete getIngredientQuantity(IIngredient ingredient, QuantityComplete yieldQuantity, QuantityComplete targetRecipeQuantity) throws DTOUtilException {
        QuantityInterpolationComplete quantityInterpolation = ingredient.getQuantityInterpolation();
        if (quantityInterpolation instanceof LinearQuantityInterpolationComplete) {
            QuantityComplete q = ((LinearQuantityInterpolationComplete)quantityInterpolation).getResultingQuantity();
            if (targetRecipeQuantity == null) {
                return q;
            }
            if (yieldQuantity == null) {
                return new QuantityComplete(Double.valueOf(q.getQuantity() * targetRecipeQuantity.getQuantity()), q.getUnit());
            }
            double targetValue = targetRecipeQuantity.getQuantity();
            double recipeValue = UnitConversionToolkit.convertUnit(yieldQuantity.getUnit(), targetRecipeQuantity.getUnit(), (double)yieldQuantity.getQuantity(), null, (Timestamp)null);
            double factor = targetValue / recipeValue;
            return new QuantityComplete(Double.valueOf(q.getQuantity() * factor), q.getUnit());
        }
        if (quantityInterpolation instanceof StepQuantityInterpolationComplete) {
            List steps = ((StepQuantityInterpolationComplete)quantityInterpolation).getSteps();
            return RecipeCalculationToolkit.resolveStep(steps, targetRecipeQuantity);
        }
        throw new DTOUtilException("Invalid QuantityInterpolation type: " + quantityInterpolation.getClass().getSimpleName());
    }

    public static double getIngredientPrice(IIngredient ingredient, QuantityComplete ingredientQuantity, CurrencyComplete targetCurrency, CurrencyVariantAccessor accessor, RecipeVariantAccessor recipeAccessor, Timestamp validityDate, CustomerReference customer, boolean useTender) throws Exception {
        if (targetCurrency == null) {
            return 0.0;
        }
        if (ingredient instanceof ISimpleIngredient) {
            BasicArticleComplete article = ((ISimpleIngredient)ingredient).getArticle();
            if (article == null) {
                return 0.0;
            }
            PriceComplete articlePrice = null;
            articlePrice = Boolean.TRUE.equals(article.getCustomerIsOwner()) || Boolean.TRUE.equals(article.getExcludeFromMaterialCostCalculations()) ? new PriceComplete(targetCurrency, Double.valueOf(0.0)) : ArticlePriceCalculationToolkit.getBruttoForQuantity(article, ingredientQuantity, validityDate, customer, useTender);
            return UnitConversionToolkit.getPriceIn(targetCurrency, articlePrice, accessor, validityDate);
        }
        if (ingredient instanceof ICompoundIngredient) {
            ICompoundIngredient recipe = (ICompoundIngredient)ingredient;
            return RecipeCalculationToolkit.getRecipePrice((IRecipe)recipe, ingredientQuantity, targetCurrency, accessor, recipeAccessor, validityDate, customer, useTender);
        }
        throw new DTOUtilException("Invalid Ingredient type: " + ingredient.getClass().getSimpleName());
    }

    private static void ensureComparator() {
        if (interPolationStepComparator == null) {
            interPolationStepComparator = new InterpolationStepComparator();
        }
    }

    public static QuantityComplete resolveStep(List<InterpolationStepComplete> steps, QuantityComplete targetYield) throws DTOUtilException {
        if (targetYield == null) {
            throw new DTOUtilException("Failed to resolve interpolation step (target quantity is null)!");
        }
        RecipeCalculationToolkit.ensureComparator();
        Collections.sort(steps, interPolationStepComparator);
        QuantityComplete q = new QuantityComplete();
        double lastBound = 0.0;
        if (targetYield.getQuantity() == lastBound && steps.size() >= 1) {
            InterpolationStepComplete step = steps.get(0);
            q.setClientOId(Long.valueOf(q.getNextId()));
            q.setQuantity(step.getResultingQuantity().getQuantity());
            q.setUnit(step.getResultingQuantity().getUnit());
            return q;
        }
        int c = 0;
        for (InterpolationStepComplete step : steps) {
            double upBound = UnitConversionToolkit.convertUnit(step.getUpperBound().getUnit(), targetYield.getUnit(), (double)step.getUpperBound().getQuantity(), null, (Timestamp)null);
            if (targetYield.getQuantity() > lastBound && targetYield.getQuantity() <= upBound) {
                q.setClientOId(Long.valueOf(q.getNextId()));
                q.setQuantity(step.getResultingQuantity().getQuantity());
                q.setUnit(step.getResultingQuantity().getUnit());
                return q;
            }
            if (++c != steps.size()) continue;
            q.setClientOId(Long.valueOf(q.getNextId()));
            q.setQuantity(step.getResultingQuantity().getQuantity());
            q.setUnit(step.getResultingQuantity().getUnit());
            return q;
        }
        return null;
    }
}

