/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.flightschedule.stowing;

import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.EquipmentDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.LabelConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.TrackableItemComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Coordinate3dComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Dimension3dComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentSystemComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.Bidirectional;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@DTO(target="ch.icit.pegasus.server.core.entities.stowing.GalleyEquipment")
public class GalleyEquipmentComplete
extends GalleyEquipmentLight
implements TrackableItemComplete {
    private Dimension3dComplete dimension;
    private Coordinate3dComplete location;
    @Bidirectional(target="containingEquipment")
    private List<DeliverySpaceComplete> deliverySpaces = new ArrayList<DeliverySpaceComplete>();
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    @IgnoreField
    private List<EquipmentDistributionRuleComplete> equipmentDistributionRules = new ArrayList<EquipmentDistributionRuleComplete>();
    @XmlAttribute
    private Boolean inUse;
    @XmlAttribute
    private String bellyPositionCode;
    @XmlAttribute
    private Boolean dishwash;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    private List<CostCenterComplete> costCenter = new ArrayList<CostCenterComplete>();
    private LabelConfigurationComplete labelConfiguration;
    @XmlAttribute
    private Boolean isOutbound = true;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private GalleyEquipmentSystemComplete equipmentSystem;
    @DTOField(target="generateDeliverySpaceLabels")
    @XmlAttribute
    private Boolean generateReservedSpaceLabels = false;

    public GalleyEquipmentComplete() {
        this.inUse = Boolean.TRUE;
        this.dishwash = Boolean.FALSE;
    }

    public GalleyEquipmentSystemComplete getEquipmentSystem() {
        return this.equipmentSystem;
    }

    public void setEquipmentSystem(GalleyEquipmentSystemComplete equipmentSystem) {
        this.equipmentSystem = equipmentSystem;
    }

    public Boolean getDishwash() {
        return this.dishwash;
    }

    public Boolean getGenerateReservedSpaceLabels() {
        return this.generateReservedSpaceLabels;
    }

    public void setGenerateReservedSpaceLabels(Boolean generateReservedSpaceLabels) {
        this.generateReservedSpaceLabels = generateReservedSpaceLabels;
    }

    public Boolean getIsOutbound() {
        return this.isOutbound;
    }

    public void setIsOutbound(Boolean isOutbound) {
        this.isOutbound = isOutbound;
    }

    public Dimension3dComplete getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension3dComplete dimension) {
        this.dimension = dimension;
    }

    public String getBellyPositionCode() {
        return this.bellyPositionCode;
    }

    public void setBellyPositionCode(String bellyPositionCode) {
        this.bellyPositionCode = bellyPositionCode;
    }

    public List<DeliverySpaceComplete> getDeliverySpaces() {
        return this.deliverySpaces;
    }

    public List<EquipmentDistributionRuleComplete> getEquipmentDistributionRules() {
        return this.equipmentDistributionRules;
    }

    public Boolean getInUse() {
        return this.inUse;
    }

    public Boolean isDishwash() {
        return this.dishwash;
    }

    public void setDeliverySpaces(List<DeliverySpaceComplete> deliverySpaces) {
        this.deliverySpaces = deliverySpaces;
    }

    public void setEquipmentDistributionRules(List<EquipmentDistributionRuleComplete> equipmentDistributionRules) {
        this.equipmentDistributionRules = equipmentDistributionRules;
    }

    public void setInUse(Boolean value) {
        this.inUse = value;
    }

    public void setDishwash(Boolean value) {
        this.dishwash = value;
    }

    public void setLocation(Coordinate3dComplete location) {
        this.location = location;
    }

    public Coordinate3dComplete getLocation() {
        return this.location;
    }

    public List<CostCenterComplete> getCostCenter() {
        return this.costCenter;
    }

    public void setCostCenter(List<CostCenterComplete> costCenter) {
        this.costCenter = costCenter;
    }

    @Override
    public LabelConfigurationComplete getLabelConfiguration() {
        return this.labelConfiguration;
    }

    @Override
    public void setLabelConfiguration(LabelConfigurationComplete labelConfiguration) {
        this.labelConfiguration = labelConfiguration;
    }

    @Override
    public String getCode() {
        return this.getPositionCode();
    }

    @Override
    public int compareTo(TrackableItemComplete o) {
        if (this.getContainingGalley() == null) {
            return o.getContainingGalley() == null ? 0 : -1;
        }
        if (o.getContainingGalley() == null) {
            return 1;
        }
        int ret = this.getContainingGalley().compareTo(o.getContainingGalley());
        if (ret != 0) {
            return ret;
        }
        if (this.getCode() == null) {
            return o.getCode() == null ? 0 : -1;
        }
        if (o.getCode() == null) {
            return 1;
        }
        return this.getCode().compareTo(o.getCode());
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object product) {
        super.afterUnmarshal(u, product);
        XmlCache.getXmlCache().put(this.getId() != null ? this.getId() : this.getClientOId(), this);
    }

    @Override
    public void beforeMarshal(Marshaller u) {
        super.beforeMarshal(u);
        XmlCache.getXmlCache().put(this.getId() != null ? this.getId() : this.getClientOId(), this);
    }
}

