/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.masterdata;

import ch.icit.pegasus.server.core.calculator.IUnit;
import ch.icit.pegasus.server.core.dtos.masterdata.AMasterDataComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DTO(target="ch.icit.pegasus.server.core.entities.supply.Unit")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class UnitComplete
extends AMasterDataComplete
implements IUnit {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.NONE)
    private static Logger logger = LoggerFactory.getLogger(UnitComplete.class);
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @DTOField(readonly=true)
    @XmlTransient
    private UnitComplete superUnit;
    @IgnoreField
    @XmlAttribute
    private Long superUnitId;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlTransient
    private UnitComplete subUnit;
    @IgnoreField
    @XmlAttribute
    private Long subUnitId;
    @XmlTransient
    private UnitSystemComplete unitSystem;
    @IgnoreField
    @XmlAttribute
    private Long unitSystemId;
    @XmlAttribute
    private Integer conversionFactor;
    @DTOField(target="unitName")
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String shortName;
    @DTOField(nullable=false)
    @XmlAttribute
    private Boolean display;
    @XmlAttribute
    private Boolean recipeYieldUnit;

    @XmlID
    public String getUnitId() {
        return Long.toString(this.getId());
    }

    public void setUnitId(String id) {
    }

    public UnitComplete() {
    }

    public UnitComplete(String name, String shortName) {
        this();
        this.name = name;
        this.shortName = shortName;
    }

    public Boolean getDisplay() {
        return this.display;
    }

    public void setDisplay(Boolean display) {
        this.display = display;
    }

    public UnitComplete getSubUnit() {
        return this.subUnit;
    }

    public Integer getConversionFactor() {
        return this.conversionFactor;
    }

    public String getName() {
        return this.name;
    }

    public UnitComplete getSuperUnit() {
        return this.superUnit;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setSubUnit(UnitComplete subUnit) {
        this.subUnit = subUnit;
    }

    public void setConversionFactor(Integer conversionFactor) {
        this.conversionFactor = conversionFactor;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSuperUnit(UnitComplete superUnit) {
        this.superUnit = superUnit;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public String toString() {
        return this.shortName;
    }

    public Boolean getRecipeYieldUnit() {
        return this.recipeYieldUnit;
    }

    public void setRecipeYieldUnit(Boolean recipeYieldUnit) {
        this.recipeYieldUnit = recipeYieldUnit;
    }

    public UnitSystemComplete getUnitSystem() {
        return this.unitSystem;
    }

    public void setUnitSystem(UnitSystemComplete unitSystem) {
        this.unitSystem = unitSystem;
    }

    public Long getUnitSystemId() {
        return this.unitSystemId;
    }

    public void setUnitSystemId(Long unitSystemId) {
        this.unitSystemId = unitSystemId;
    }

    public Long getSuperUnitId() {
        return this.superUnitId;
    }

    public void setSuperUnitId(Long superUnitId) {
        this.superUnitId = superUnitId;
    }

    public Long getSubUnitId() {
        return this.subUnitId;
    }

    public void setSubUnitId(Long subUnitId) {
        this.subUnitId = subUnitId;
    }

    public void beforeMarshal(Marshaller m) {
        try {
            if (this.getUnitSystem() != null) {
                this.setUnitSystemId(this.getUnitSystem().getId());
            }
            if (this.getSuperUnit() != null) {
                this.setSuperUnitId(this.getSuperUnit().getId());
            }
            if (this.getSubUnit() != null) {
                this.setSubUnitId(this.getSubUnit().getId());
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        if (parent instanceof ListWrapper) {
            XmlCache.getXmlCache().put(this.getId(), this);
        } else {
            this.resolveReferences();
            this.resolveParents();
            this.resolveChilds();
        }
        if (this.getUnitSystem() == null && this.getUnitSystemId() != null) {
            this.resolveReferences();
        }
    }

    public void resolveParents() {
        if (this.getSuperUnitId() != null) {
            this.setSuperUnit((UnitComplete)XmlCache.getXmlCache().get(this.getSuperUnitId()));
        }
        if (this.getSuperUnit() != null) {
            this.getSuperUnit().resolveParents();
            this.getSuperUnit().resolveReferences();
        }
    }

    public void resolveChilds() {
        if (this.getSubUnitId() != null) {
            this.setSubUnit((UnitComplete)XmlCache.getXmlCache().get(this.getSubUnitId()));
        }
        if (this.getSubUnit() != null) {
            this.getSubUnit().resolveChilds();
            this.getSubUnit().resolveReferences();
        }
    }

    public void resolveReferences() {
        if (this.getUnitSystemId() != null) {
            this.setUnitSystem((UnitSystemComplete)XmlCache.getXmlCache().get(this.getUnitSystemId()));
        }
    }
}

