/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.store;

import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionContentLight;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class StorePositionContentComplete
extends StorePositionContentLight {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    private List<ArticleChargeBatchComplete> batches = new ArrayList<ArticleChargeBatchComplete>();
    private StoreQuantityComplete storeQuantity;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    private List<ArticleChargeComplete> associatedCharges = new ArrayList<ArticleChargeComplete>();

    public List<ArticleChargeComplete> getAssociatedCharges() {
        return this.associatedCharges;
    }

    public void setAssociatedCharges(List<ArticleChargeComplete> associatedCharges) {
        this.associatedCharges = associatedCharges;
    }

    public StoreQuantityComplete getStoreQuantity() {
        return this.storeQuantity;
    }

    public void setStoreQuantity(StoreQuantityComplete storeQuantity) {
        this.storeQuantity = storeQuantity;
    }

    public List<ArticleChargeBatchComplete> getBatches() {
        return this.batches;
    }

    public void setBatches(List<ArticleChargeBatchComplete> batches) {
        this.batches = batches;
    }

    public void beforeMarshal(Marshaller m) {
        HashSet<ArticleChargeComplete> charges = new HashSet<ArticleChargeComplete>();
        for (ArticleChargeBatchComplete batch : this.batches) {
            charges.add(batch.getCharge());
        }
        this.associatedCharges.addAll(charges);
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        HashMap<Long, ArticleChargeComplete> index = new HashMap<Long, ArticleChargeComplete>();
        for (ArticleChargeComplete associatedCharge : this.associatedCharges) {
            index.put(associatedCharge.getId(), associatedCharge);
        }
        for (ArticleChargeBatchComplete batch : this.batches) {
            batch.setCharge((ArticleChargeComplete)index.get(batch.getChargeId()));
        }
    }
}

