/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.mealplan;

import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@DTO(target="ch.icit.pegasus.server.core.entities.mealplan.LoadingGroupTemplate")
public class LoadingGroupTemplateComplete
extends ALoadingGroupComplete {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.NONE)
    private static Logger logger = LoggerFactory.getLogger(LoadingGroupTemplateComplete.class);
    @DTOField(readonly=true, target="containingServiceSchedule")
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlTransient
    private CateringServiceScheduleComplete containingService;
    @IgnoreField
    @XmlAttribute
    private Long containingServiceId;

    @Override
    public CateringServiceScheduleVariantComplete getContainingService() {
        if (this.containingService != null) {
            return this.containingService.getCurrentVariant();
        }
        return null;
    }

    public void setContainingService(CateringServiceScheduleComplete containingService) {
        this.containingService = containingService;
    }

    public Long getContainingServiceId() {
        return this.containingServiceId;
    }

    public void setContainingServiceId(Long containingServiceId) {
        this.containingServiceId = containingServiceId;
    }

    public void beforeMarshal(Marshaller m) {
        try {
            if (this.containingService != null) {
                this.setContainingServiceId(this.containingService.getId());
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        if (parent instanceof CateringServiceScheduleComplete) {
            this.containingService = (CateringServiceScheduleComplete)parent;
            XmlCache.getXmlCache().put(this.containingService.getId(), this.containingService);
        } else if (this.getContainingServiceId() != null && XmlCache.getXmlCache().get(this.getContainingServiceId()) != null) {
            this.setContainingService((CateringServiceScheduleComplete)XmlCache.getXmlCache().get(this.getContainingServiceId()));
        }
        XmlCache.getXmlCache().put(this.getId() != null ? this.getId() : this.getClientOId(), this);
    }
}

