/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.masterdata;

import ch.icit.pegasus.server.core.api.masterdata.IPeriod;
import ch.icit.pegasus.server.core.dtos.AEmbeddedDTO;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.SqlDateAdapter;
import ch.icit.pegasus.server.core.util.TimeUtil;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import java.sql.Date;
import java.util.Calendar;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@DTO(target="ch.icit.pegasus.server.core.entities.masterdata.Period")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PeriodComplete
extends AEmbeddedDTO
implements IPeriod,
Comparable<PeriodComplete> {
    @XmlJavaTypeAdapter(value=SqlDateAdapter.class)
    private Date endDate;
    @XmlJavaTypeAdapter(value=SqlDateAdapter.class)
    private Date startDate;

    public PeriodComplete() {
    }

    public PeriodComplete(PeriodComplete template) {
        this(template != null ? template.getStartDate() : null, template != null ? template.getEndDate() : null);
    }

    public PeriodComplete(Date startDate, Date endDate) {
        if (startDate != null) {
            this.setStartDate(new Date(startDate.getTime()));
        }
        if (endDate != null) {
            this.setEndDate(new Date(endDate.getTime()));
        }
    }

    @Override
    public int compareTo(PeriodComplete o) {
        if (this.startDate == null) {
            return o.getStartDate() == null ? 0 : -1;
        }
        if (o.getStartDate() == null) {
            return 1;
        }
        return this.startDate.compareTo(o.getStartDate());
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setEndDate(Date value) {
        this.endDate = value;
        this.fixEndDate();
    }

    public void setStartDate(Date value) {
        this.startDate = value;
        this.fixStartDate();
    }

    @Override
    public String toString() {
        return this.startDate + " -> " + (PeriodComplete.isInfinityDate(this.endDate) ? "\u221e" : this.endDate);
    }

    private void fixStartDate() {
        if (this.startDate == null) {
            return;
        }
        DateTime dateTime = new DateTime((Object)this.startDate);
        DateTime startOfDay = dateTime.withTimeAtStartOfDay();
        this.startDate = new Date(startOfDay.getMillis());
    }

    private void fixEndDate() {
        if (this.endDate == null) {
            return;
        }
        this.endDate = this.atEndOfDay(this.endDate);
    }

    private Date atEndOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return new Date(calendar.getTimeInMillis());
    }

    public Boolean within(Date date) {
        return this.getStartDate().getTime() <= date.getTime() && this.getEndDate().getTime() >= date.getTime();
    }

    public static boolean isInfinityDate(Date date) {
        if (date == null) {
            return false;
        }
        Calendar c = TimeUtil.createCalendar();
        c.setTime(date);
        int y = c.get(1);
        int m = c.get(2);
        int d = c.get(5);
        if (y == 6666 && m == 6 && d == 6) {
            return true;
        }
        return y == 6666;
    }
}

