/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.masterdata;

import ch.icit.pegasus.server.core.calculator.IUnitSystem;
import ch.icit.pegasus.server.core.dtos.masterdata.AMasterDataComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DTO(target="ch.icit.pegasus.server.core.entities.supply.UnitSystem")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class UnitSystemComplete
extends AMasterDataComplete
implements IUnitSystem {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.NONE)
    private static Logger logger = LoggerFactory.getLogger(UnitSystemComplete.class);
    @DTOField(nullable=false)
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlTransient
    private UnitComplete maxUnit;
    @IgnoreField
    @XmlAttribute
    private Long maxUnitId;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlTransient
    private UnitComplete baseUnit;
    @IgnoreField
    @XmlAttribute
    private Long baseUnitId;
    @XmlAttribute
    private String name;

    public UnitComplete getBaseUnit() {
        return this.baseUnit;
    }

    public void setBaseUnit(UnitComplete baseUnit) {
        this.baseUnit = baseUnit;
    }

    public UnitComplete getMaxUnit() {
        return this.maxUnit;
    }

    public void setMaxUnit(UnitComplete maxUnit) {
        this.maxUnit = maxUnit;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getMaxUnitId() {
        return this.maxUnitId;
    }

    public void setMaxUnitId(Long maxUnitId) {
        this.maxUnitId = maxUnitId;
    }

    public Long getBaseUnitId() {
        return this.baseUnitId;
    }

    public void setBaseUnitId(Long baseUnitId) {
        this.baseUnitId = baseUnitId;
    }

    public void beforeMarshal(Marshaller m) {
        try {
            if (this.getBaseUnit() != null) {
                this.setBaseUnitId(this.getBaseUnit().getId());
            }
            if (this.getMaxUnit() != null) {
                this.setMaxUnitId(this.getMaxUnit().getId());
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        XmlCache.getXmlCache().put(this.getId(), this);
    }

    public void resolveReferences() {
        if (this.getMaxUnitId() != null) {
            this.setMaxUnit((UnitComplete)XmlCache.getXmlCache().get(this.getMaxUnitId()));
        }
        if (this.getBaseUnitId() != null) {
            this.setBaseUnit((UnitComplete)XmlCache.getXmlCache().get(this.getBaseUnitId()));
        }
    }
}

