/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.supply;

import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryReference;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DTO(target="ch.icit.pegasus.server.core.entities.masterdata.ProductCategory")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProductCategoryLight
extends ProductCategoryReference {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.NONE)
    private static Logger logger = LoggerFactory.getLogger(ProductCategoryLight.class);
    @XmlAttribute
    private String name;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @DTOField(target="superCategory")
    @XmlTransient
    private ProductCategoryComplete parent;
    @IgnoreField
    @XmlAttribute
    private Long parentCategoryId;
    @XmlAttribute
    private Boolean display;
    @XmlAttribute
    private String code;
    @IgnoreField
    @XmlAttribute
    private Boolean excludeFromSob = false;
    @XmlAttribute
    private Boolean commissionForCrew = false;
    @XmlAttribute
    private Boolean commissionForAirline = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProductCategoryComplete getParent() {
        return this.parent;
    }

    public void setParent(ProductCategoryComplete parent) {
        this.parent = parent;
    }

    public Boolean getDisplay() {
        return this.display;
    }

    public void setDisplay(Boolean display) {
        this.display = display;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Boolean getExcludeFromSob() {
        return this.excludeFromSob;
    }

    public void setExcludeFromSob(Boolean excludeFromSob) {
        this.excludeFromSob = excludeFromSob;
    }

    public Boolean getCommissionForCrew() {
        return this.commissionForCrew;
    }

    public void setCommissionForCrew(Boolean commissionForCrew) {
        this.commissionForCrew = commissionForCrew;
    }

    public Boolean getCommissionForAirline() {
        return this.commissionForAirline;
    }

    public void setCommissionForAirline(Boolean commissionForAirline) {
        this.commissionForAirline = commissionForAirline;
    }

    public Long getParentCategoryId() {
        return this.parentCategoryId;
    }

    public void setParentCategoryId(Long parentCategoryId) {
        this.parentCategoryId = parentCategoryId;
    }

    protected ProductCategoryComplete resolveParent() {
        try {
            ProductCategoryComplete newParent = (ProductCategoryComplete)XmlCache.getXmlCache().get(this.parentCategoryId);
            if (newParent != null) {
                this.setParent(newParent);
            }
            return newParent;
        }
        catch (Throwable e) {
            logger.error("", e);
            return null;
        }
    }

    public void beforeMarshal(Marshaller m) {
        try {
            if (this.getParent() != null) {
                this.setParentCategoryId(this.getParent().getCacheId());
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        for (ProductCategoryLight cat = this; cat != null; cat = cat.resolveParent()) {
        }
    }
}

