/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.general;

import ch.icit.pegasus.server.core.general.IUniversal;
import ch.icit.pegasus.server.core.general.SearchImplType;
import ch.icit.pegasus.server.core.general.SortColumnAdapter;
import ch.icit.pegasus.server.core.search.SortDirection;
import ch.icit.pegasus.server.core.util.Tuple;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public abstract class ASearchConfiguration<T extends IUniversal, E extends Enum<E>>
implements Serializable {
    protected static final long serialVersionUID = 1L;
    protected Class<T> returnType;
    protected int numResults = 30;
    protected int pageNumber = 0;
    protected SortDirection sortDirection = SortDirection.ASCENDING;
    @XmlJavaTypeAdapter(value=SortColumnAdapter.class)
    protected E sortColumn;
    protected Boolean isDeleted = null;
    private SearchType searchtype;

    public ASearchConfiguration() {
        this(30, 0);
    }

    public ASearchConfiguration(Integer numResults, Integer pageNumber) {
        this.numResults = numResults;
        this.pageNumber = pageNumber;
        this.returnType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public abstract E getDefaultSortColumn();

    public abstract SearchImplType getIdentifier();

    public void revertOrderDirection() {
        switch (this.sortDirection) {
            case ASCENDING: {
                this.sortDirection = SortDirection.DESCENDING;
                break;
            }
            case DESCENDING: {
                this.sortDirection = SortDirection.ASCENDING;
            }
        }
    }

    protected String limitString(String text) {
        if (text != null && text.length() > 255) {
            return text.substring(0, 255);
        }
        return text;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getNumResults() {
        return this.numResults;
    }

    public void setNumResults(int numResults) {
        this.numResults = numResults;
    }

    public SortDirection getSortDirection() {
        return this.sortDirection != null ? this.sortDirection : SortDirection.ASCENDING;
    }

    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
    }

    public final E getSortColumn() {
        return this.sortColumn != null ? this.sortColumn : this.getDefaultSortColumn();
    }

    public final void setSortColumn(E sortColumn) {
        this.sortColumn = sortColumn;
    }

    public Class<T> getReturnType() {
        return this.returnType;
    }

    public void setIsDeleted(Boolean deleted) {
        this.isDeleted = deleted;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public List<Tuple<String, String>> getSearchConfig() {
        return null;
    }

    public SearchType getSearchtype() {
        return this.searchtype;
    }

    public void setSearchtype(SearchType searchtype) {
        this.searchtype = searchtype;
    }

    public static enum SearchType {
        Full,
        Filtered,
        Page;

    }
}

