/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.services.supply;

import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionReference;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.ServiceImplementation;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import javax.ejb.Remote;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;

@Remote
@WebService(targetNamespace="https://icit.ch/pegasus/inventoryservice")
@SOAPBinding(style=SOAPBinding.Style.RPC)
@ServiceImplementation(implementation="InventoryServiceImpl")
public interface InventoryService {
    @WebMethod
    public OptionalWrapper<InventoryComplete> createInventory(InventoryComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<InventoryComplete> updateInventory(InventoryComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<InventoryComplete> get(InventoryReference var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<InventoryTransitionComplete> createInventoryTransition(InventoryTransitionComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<InventoryTransitionComplete> updateInventoryTransition(InventoryTransitionComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<InventoryTransitionComplete> getByTransition(InventoryTransitionReference var1) throws ServiceException;

    @WebMethod
    public ListWrapper<ArticleChargeBatchComplete> getRemainingArticleBatches(StoreLight var1, InventoryLight var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<InventoryComplete> startFullInventory(InventoryLight var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<InventoryComplete> closeFullInventory(InventoryLight var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StoreLight> startStoreInventory(InventoryReference var1, StoreReference var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StoreLight> closeStoreInventory(InventoryLight var1, StoreLight var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<InventoryComplete> startInventory(InventoryLight var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<InventoryComplete> closeInventory(InventoryLight var1) throws ServiceException;

    @WebMethod
    public ListWrapper<StockTransactionComplete> getInventoryTransactions(InventoryReference var1, boolean var2) throws ServiceException;

    @WebMethod
    public void revert(InventoryReference var1, StoreReference var2, Boolean var3) throws ServiceException;
}

