/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils.ftp;

import ch.icit.utils.FtpClientConfiguration;
import ch.icit.utils.FtpClientException;
import ch.icit.utils.FtpErrorCode;
import ch.icit.utils.Tuple;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpClient {
    private static final Logger log = LoggerFactory.getLogger(FtpClient.class);

    private static FTPClient initFTPClient(FtpClientConfiguration config) throws IOException {
        FTPClient ftpClient = null;
        boolean binaryTransfer = false;
        boolean localActive = false;
        boolean useEpsvWithIPv4 = false;
        ftpClient = new FTPClient();
        ftpClient.connect(config.getUrl(), config.getPort());
        ftpClient.login(config.getUser(), config.getPassword());
        if (binaryTransfer) {
            ftpClient.setFileType(2);
        } else {
            ftpClient.setFileType(0);
        }
        if (localActive) {
            ftpClient.enterLocalActiveMode();
        } else {
            ftpClient.enterLocalPassiveMode();
        }
        ftpClient.setUseEPSVwithIPv4(useEpsvWithIPv4);
        return ftpClient;
    }

    public static boolean existsRemoteFileName(FtpClientConfiguration config, String filename) throws FtpClientException {
        FTPClient ftpClient = null;
        try {
            FTPFile[] files;
            ftpClient = FtpClient.initFTPClient(config);
            String path = config.getFolder();
            FtpClient.changeDirectoryPath(ftpClient, path);
            for (FTPFile e : files = ftpClient.listFiles()) {
                String ffind = e.getName();
                if (!filename.equals(ffind)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new FtpClientException(2000, FtpErrorCode.ApacheCommonsNet, e.getMessage(), e);
        }
        finally {
            FtpClient.closeFtpConnection(ftpClient, 2000);
        }
    }

    public static List<FTPFile> getRemoteFileNames(FtpClientConfiguration config) throws FtpClientException {
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpClient.initFTPClient(config);
            String path = config.getFolder();
            FtpClient.changeDirectoryPath(ftpClient, path);
            FTPFile[] files = ftpClient.listFiles();
            ArrayList<FTPFile> remoteFileList = new ArrayList<FTPFile>();
            for (FTPFile file : files) {
                remoteFileList.add(file);
            }
            ArrayList<FTPFile> arrayList = remoteFileList;
            return arrayList;
        }
        catch (IOException e) {
            throw new FtpClientException(2000, FtpErrorCode.ApacheCommonsNet, e.getMessage(), e);
        }
        finally {
            FtpClient.closeFtpConnection(ftpClient, 2000);
        }
    }

    public static Map<String, File> readFiles(FtpClientConfiguration config, Map<String, File> fileList) throws FtpClientException {
        if (fileList == null || fileList.isEmpty()) {
            return fileList;
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpClient.initFTPClient(config);
            String path = config.getFolder();
            FtpClient.changeDirectoryPath(ftpClient, path);
            for (Map.Entry<String, File> f : fileList.entrySet()) {
                File dir = new File(f.getValue().getAbsolutePath().substring(0, f.getValue().getAbsolutePath().lastIndexOf(File.separator)));
                if (!dir.exists() || !dir.isDirectory()) {
                    dir.mkdirs();
                }
                try {
                    FileOutputStream output = new FileOutputStream(f.getValue());
                    Throwable throwable = null;
                    try {
                        ftpClient.retrieveFile(f.getKey(), (OutputStream)output);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (output == null) continue;
                        if (throwable != null) {
                            try {
                                ((OutputStream)output).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((OutputStream)output).close();
                    }
                }
                catch (IOException e) {
                    throw new FtpClientException(4000, FtpErrorCode.IOException, e.getMessage(), e);
                }
            }
            Map<String, File> map = fileList;
            return map;
        }
        catch (IOException e) {
            throw new FtpClientException(2000, FtpErrorCode.ApacheCommonsNet, e.getMessage(), e);
        }
        finally {
            FtpClient.closeFtpConnection(ftpClient, 2000);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sendFiles(FtpClientConfiguration config, Map<File, String> fileList) throws FtpClientException {
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpClient.initFTPClient(config);
            String path = config.getFolder();
            FtpClient.changeDirectoryPath(ftpClient, path);
            for (Map.Entry<File, String> file : fileList.entrySet()) {
                try {
                    FileInputStream input = new FileInputStream(file.getKey());
                    Throwable throwable = null;
                    try {
                        ftpClient.storeFile(file.getValue(), (InputStream)input);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (input == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)input).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)input).close();
                    }
                }
                catch (IOException e) {
                    throw new FtpClientException(4000, FtpErrorCode.IOException, e.getMessage(), e);
                    return;
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new FtpClientException(3000, FtpErrorCode.FileNotFoundException, e.getMessage(), e);
        }
        catch (IOException e) {
            throw new FtpClientException(4000, FtpErrorCode.IOException, e.getMessage(), e);
        }
        finally {
            FtpClient.closeFtpConnection(ftpClient, 4000);
        }
    }

    private static void closeFtpConnection(FTPClient ftpClient, int i) throws FtpClientException {
        if (ftpClient != null) {
            try {
                if (ftpClient.isConnected()) {
                    ftpClient.logout();
                }
                ftpClient.disconnect();
            }
            catch (IOException e) {
                throw new FtpClientException(i, FtpErrorCode.ApacheCommonsNet, e.getMessage(), e);
            }
        }
    }

    public static void deleteFiles(FtpClientConfiguration config, List<String> fileList) throws FtpClientException {
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpClient.initFTPClient(config);
            String path = config.getFolder();
            FtpClient.changeDirectoryPath(ftpClient, path);
            for (String file : fileList) {
                ftpClient.deleteFile(file);
            }
        }
        catch (IOException e) {
            throw new FtpClientException(2000, FtpErrorCode.IOException, e.getMessage(), e);
        }
        finally {
            FtpClient.closeFtpConnection(ftpClient, 2000);
        }
    }

    public static void deleteFiles(FtpClientConfiguration config, Map<FTPFile, Tuple<Timestamp, String>> fileList) throws FtpClientException {
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpClient.initFTPClient(config);
            String path = config.getFolder();
            FtpClient.changeDirectoryPath(ftpClient, path);
            for (Map.Entry<FTPFile, Tuple<Timestamp, String>> file : fileList.entrySet()) {
                ftpClient.deleteFile(file.getKey().getName());
            }
        }
        catch (IOException e) {
            throw new FtpClientException(2000, FtpErrorCode.IOException, e.getMessage(), e);
        }
        finally {
            FtpClient.closeFtpConnection(ftpClient, 2000);
        }
    }

    public static void moveParsedFilesIntoBackupFolder(FtpClientConfiguration config, List<Tuple<String, Date>> fileList, String destinationDirectory) throws FtpClientException {
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpClient.initFTPClient(config);
            String path = config.getFolder();
            FtpClient.changeDirectoryPath(ftpClient, path);
            ArrayList<Date> dateList = new ArrayList<Date>();
            for (Tuple<String, Date> originFile : fileList) {
                if (originFile.getT() != null && !dateList.contains(originFile.getT())) {
                    dateList.add(originFile.getT());
                    System.out.println("date" + originFile.getT());
                    FtpClient.existsDirectory(ftpClient, destinationDirectory, FtpClient.getMonthOrYear(originFile.getT(), 1, 0), FtpClient.getMonthOrYear(originFile.getT(), 2, 1));
                }
                String destinationFile = destinationDirectory + "/" + FtpClient.getMonthOrYear(originFile.getT(), 1, 0) + "/" + FtpClient.getMonthOrYear(originFile.getT(), 2, 1) + "/" + originFile.getS();
                ftpClient.rename(originFile.getS(), destinationFile);
            }
        }
        catch (IOException e) {
            throw new FtpClientException(2000, FtpErrorCode.IOException, e.getMessage(), e);
        }
        finally {
            FtpClient.closeFtpConnection(ftpClient, 2000);
        }
    }

    private static boolean existsDirectory(FTPClient ftpClient, String directory, String year, String month) {
        try {
            boolean b = ftpClient.changeWorkingDirectory(directory);
            if (!b) {
                ftpClient.makeDirectory(directory);
            }
            ftpClient.changeWorkingDirectory(directory);
            b = ftpClient.changeWorkingDirectory(year);
            if (!b) {
                ftpClient.makeDirectory(year);
            }
            ftpClient.changeWorkingDirectory(year);
            b = ftpClient.changeWorkingDirectory(month);
            if (!b) {
                ftpClient.makeDirectory(month);
            }
            ftpClient.changeWorkingDirectory("..");
            ftpClient.changeWorkingDirectory("..");
            return b;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static void changeDirectoryPath(FTPClient ftpClient, String path) throws IOException {
        log.debug("00: changeDirectoryPath OK:" + File.separator + "|" + path);
        ftpClient.changeWorkingDirectory(path);
    }

    private static String getMonthOrYear(Date date, int calendarType, int addition) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int i = cal.get(calendarType) + addition;
        if (i < 10) {
            return "0" + i;
        }
        return "" + i;
    }
}

