/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PrettyPrinter {
    private static final List LEAVES = Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class, String.class);

    private static String toStringRecursive(Object o) {
        try {
            return PrettyPrinter.toStringRecursive(o, "", new ArrayList<Object>(), false);
        }
        catch (Exception e) {
            return "Failure to Read";
        }
    }

    private static String toStringRecursive(Object o, String offset, List<Object> index, boolean parentArray) throws Exception {
        if (o == null) {
            return "null\n";
        }
        if (LEAVES.contains(o.getClass())) {
            if (parentArray) {
                return offset + o.toString() + "\n";
            }
            return o.toString() + "\n";
        }
        if (index.contains(System.identityHashCode(o))) {
            if (parentArray) {
                return offset + "Backreference \n";
            }
            return "Backreference \n";
        }
        index.add(System.identityHashCode(o));
        StringBuilder sb = new StringBuilder();
        if (parentArray) {
            sb.append(offset + o.getClass().getSimpleName()).append(": [\n");
        } else {
            sb.append(o.getClass().getSimpleName()).append(": [\n");
        }
        for (Field f : o.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            f.setAccessible(true);
            if (f.getType().isArray()) {
                Object[] object = (Object[])f.get(o);
                for (int j = 0; j < object.length; ++j) {
                    sb.append(PrettyPrinter.toStringRecursive(object[j], offset + "  ", index, true));
                }
                continue;
            }
            sb.append(offset + "  " + f.getName()).append(": ");
            sb.append(PrettyPrinter.toStringRecursive(f.get(o), offset + "  ", index, false));
        }
        sb.append(offset + "]\n");
        return sb.toString();
    }
}

